/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo.path;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.HashSet;
import java.util.Set;
import ome.services.blitz.repo.path.FilePathRestrictions;
import ome.services.blitz.util.CurrentPlatform;

public enum FilePathRestrictionInstance {
    WINDOWS_REQUIRED("Windows required"),
    WINDOWS_OPTIONAL("Windows optional"),
    UNIX_REQUIRED("UNIX required"),
    UNIX_OPTIONAL("UNIX optional"),
    LOCAL_REQUIRED("local required"),
    LOCAL_OPTIONAL("local optional");

    private static ImmutableMap<String, FilePathRestrictionInstance> nameLookup;
    public final String name;
    private FilePathRestrictions rules;

    static int getCodePoint(char character) {
        char[] singletonCharacterArray = new char[]{character};
        return Character.codePointAt(singletonCharacterArray, 0);
    }

    public static FilePathRestrictions getFilePathRestrictions(String ... names) {
        FilePathRestrictionInstance[] enums = new FilePathRestrictionInstance[names.length];
        for (int index = 0; index < names.length; ++index) {
            enums[index] = (FilePathRestrictionInstance)((Object)nameLookup.get((Object)names[index]));
        }
        return FilePathRestrictionInstance.getFilePathRestrictions(enums);
    }

    public static FilePathRestrictions getFilePathRestrictions(FilePathRestrictionInstance ... enums) {
        FilePathRestrictions[] rules = new FilePathRestrictions[enums.length];
        for (int index = 0; index < enums.length; ++index) {
            rules[index] = enums[index].rules;
        }
        return FilePathRestrictions.combineFilePathRestrictions(rules);
    }

    private FilePathRestrictionInstance(String name) {
        this.name = name;
    }

    static {
        ImmutableMap.Builder nameLookupBuilder = ImmutableMap.builder();
        nameLookupBuilder.put((Object)FilePathRestrictionInstance.WINDOWS_REQUIRED.name, (Object)WINDOWS_REQUIRED);
        nameLookupBuilder.put((Object)FilePathRestrictionInstance.WINDOWS_OPTIONAL.name, (Object)WINDOWS_OPTIONAL);
        nameLookupBuilder.put((Object)FilePathRestrictionInstance.UNIX_REQUIRED.name, (Object)UNIX_REQUIRED);
        nameLookupBuilder.put((Object)FilePathRestrictionInstance.UNIX_OPTIONAL.name, (Object)UNIX_OPTIONAL);
        nameLookupBuilder.put((Object)FilePathRestrictionInstance.LOCAL_REQUIRED.name, (Object)LOCAL_REQUIRED);
        nameLookupBuilder.put((Object)FilePathRestrictionInstance.LOCAL_OPTIONAL.name, (Object)LOCAL_OPTIONAL);
        nameLookup = nameLookupBuilder.build();
        ImmutableSet safeCharacters = ImmutableSet.of((Object)Character.valueOf('_'));
        int safeCodePoint = FilePathRestrictionInstance.getCodePoint(((Character)safeCharacters.iterator().next()).charValue());
        HashMultimap transformationMatrix = HashMultimap.create();
        HashSet<String> unsafePrefixes = new HashSet<String>();
        HashSet<String> unsafeSuffixes = new HashSet<String>();
        HashSet<String> unsafeNames = new HashSet<String>();
        for (int codePoint = 0; codePoint < 32; ++codePoint) {
            transformationMatrix.put((Object)codePoint, (Object)safeCodePoint);
        }
        transformationMatrix.put((Object)34, (Object)FilePathRestrictionInstance.getCodePoint('\''));
        transformationMatrix.put((Object)42, (Object)FilePathRestrictionInstance.getCodePoint('x'));
        transformationMatrix.put((Object)47, (Object)FilePathRestrictionInstance.getCodePoint('!'));
        transformationMatrix.put((Object)58, (Object)FilePathRestrictionInstance.getCodePoint(';'));
        transformationMatrix.put((Object)60, (Object)FilePathRestrictionInstance.getCodePoint('['));
        transformationMatrix.put((Object)62, (Object)FilePathRestrictionInstance.getCodePoint(']'));
        transformationMatrix.put((Object)63, (Object)FilePathRestrictionInstance.getCodePoint('%'));
        transformationMatrix.put((Object)92, (Object)FilePathRestrictionInstance.getCodePoint('!'));
        transformationMatrix.put((Object)124, (Object)FilePathRestrictionInstance.getCodePoint('!'));
        unsafeNames.add("AUX");
        unsafeNames.add("CLOCK$");
        unsafeNames.add("CON");
        unsafeNames.add("NUL");
        unsafeNames.add("PRN");
        for (char number = '1'; number <= '9'; number = (char)(number + '\u0001')) {
            unsafeNames.add("COM" + number);
            unsafeNames.add("LPT" + number);
        }
        for (String unsafeName : unsafeNames) {
            unsafePrefixes.add(unsafeName + ".");
        }
        unsafePrefixes.add("$");
        FilePathRestrictionInstance.WINDOWS_REQUIRED.rules = new FilePathRestrictions((SetMultimap<Integer, Integer>)transformationMatrix, unsafePrefixes, null, unsafeNames, (Set<Character>)safeCharacters);
        unsafeSuffixes.clear();
        unsafeSuffixes.add(".");
        unsafeSuffixes.add(" ");
        FilePathRestrictionInstance.WINDOWS_OPTIONAL.rules = new FilePathRestrictions(null, null, unsafeSuffixes, null, (Set<Character>)safeCharacters);
        transformationMatrix.clear();
        transformationMatrix.put((Object)0, (Object)safeCodePoint);
        transformationMatrix.put((Object)47, (Object)FilePathRestrictionInstance.getCodePoint('!'));
        FilePathRestrictionInstance.UNIX_REQUIRED.rules = new FilePathRestrictions((SetMultimap<Integer, Integer>)transformationMatrix, null, null, null, (Set<Character>)safeCharacters);
        unsafePrefixes.clear();
        unsafePrefixes.add(".");
        unsafePrefixes.add("-");
        FilePathRestrictionInstance.UNIX_OPTIONAL.rules = new FilePathRestrictions(null, unsafePrefixes, null, null, (Set<Character>)safeCharacters);
        if (CurrentPlatform.isWindows()) {
            FilePathRestrictionInstance.LOCAL_REQUIRED.rules = FilePathRestrictionInstance.WINDOWS_REQUIRED.rules;
            FilePathRestrictionInstance.LOCAL_OPTIONAL.rules = FilePathRestrictionInstance.WINDOWS_OPTIONAL.rules;
        } else if (CurrentPlatform.isLinux() || CurrentPlatform.isMacOSX()) {
            FilePathRestrictionInstance.LOCAL_REQUIRED.rules = FilePathRestrictionInstance.UNIX_REQUIRED.rules;
            FilePathRestrictionInstance.LOCAL_OPTIONAL.rules = FilePathRestrictionInstance.UNIX_OPTIONAL.rules;
        } else {
            FilePathRestrictionInstance.LOCAL_REQUIRED.rules = FilePathRestrictionInstance.getFilePathRestrictions(WINDOWS_REQUIRED, UNIX_REQUIRED);
            FilePathRestrictionInstance.LOCAL_OPTIONAL.rules = FilePathRestrictionInstance.getFilePathRestrictions(WINDOWS_OPTIONAL, UNIX_OPTIONAL);
        }
    }
}

