/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo.path;

import com.google.common.base.Function;
import java.io.File;
import java.io.IOException;
import ome.services.blitz.repo.path.FsFile;

public class ServerFilePathTransformer {
    private File baseDirFile;
    private FsFile baseDirFsFile;
    private Function<String, String> pathSanitizer;

    public File getServerFileFromFsFile(FsFile fsFile) {
        return fsFile.toFile(this.baseDirFile);
    }

    public FsFile getFsFileFromServerFile(File serverFile) throws IOException {
        FsFile fullFsFile = new FsFile(serverFile);
        FsFile childFsFile = fullFsFile.getPathFrom(this.baseDirFsFile);
        if (childFsFile == null) {
            throw new IllegalArgumentException("server files must be within the repository");
        }
        return childFsFile;
    }

    public boolean isLegalFsFile(FsFile fsFile) {
        return fsFile.transform(this.pathSanitizer).equals(fsFile);
    }

    public Function<String, String> getPathSanitizer() {
        return this.pathSanitizer;
    }

    public void setPathSanitizer(Function<String, String> pathSanitizer) {
        this.pathSanitizer = pathSanitizer;
    }

    public void setBaseDirFile(File baseDirFile) {
        if (!baseDirFile.isDirectory()) {
            throw new IllegalArgumentException(baseDirFile.getPath() + " must specify an existing FS repository directory");
        }
        this.baseDirFile = baseDirFile.getAbsoluteFile();
        this.baseDirFsFile = new FsFile(this.baseDirFile);
    }
}

