/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.IObject;
import ome.security.ACLVoter;
import ome.security.basic.LightAdminPrivileges;
import ome.services.delete.Deletion;
import ome.services.graphs.GraphPathBean;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphTraversal;
import ome.services.util.ReadOnlyStatus;
import ome.system.Roles;
import omero.cmd.Delete2;
import omero.cmd.Delete2Response;
import omero.cmd.ERR;
import omero.cmd.GraphException;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.cmd.graphs.BaseGraphTraversalProcessor;
import omero.cmd.graphs.GraphHelper;
import omero.cmd.graphs.GraphUtil;
import omero.cmd.graphs.IgnoreTypePolicy;
import omero.cmd.graphs.WrappableRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class Delete2I
extends Delete2
implements IRequest,
ReadOnlyStatus.IsAware,
WrappableRequest<Delete2> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Delete2I.class);
    private static final ImmutableMap<String, String> ALL_GROUPS_CONTEXT = ImmutableMap.of((Object)"omero.group", (Object)"-1");
    private static final Set<GraphPolicy.Ability> REQUIRED_ABILITIES = ImmutableSet.of((Object)GraphPolicy.Ability.DELETE);
    private final ACLVoter aclVoter;
    private final GraphPathBean graphPathBean;
    private final Set<Class<? extends IObject>> targetClasses;
    private final Deletion deletionInstance;
    private GraphPolicy graphPolicy;
    private final SetMultimap<String, String> unnullable;
    private final ApplicationContext applicationContext;
    private List<Function<GraphPolicy, GraphPolicy>> graphPolicyAdjusters = new ArrayList<Function<GraphPolicy, GraphPolicy>>();
    private Helper helper;
    private GraphHelper graphHelper;
    private GraphTraversal graphTraversal;
    private GraphTraversal.PlanExecutor unlinker;
    private GraphTraversal.PlanExecutor processor;
    private int targetObjectCount = 0;
    private int deletedObjectCount = 0;

    public Delete2I(ACLVoter aclVoter, Roles securityRoles, GraphPathBean graphPathBean, LightAdminPrivileges adminPrivileges, Deletion deletionInstance, Set<Class<? extends IObject>> targetClasses, GraphPolicy graphPolicy, SetMultimap<String, String> unnullable, ApplicationContext applicationContext) {
        this.aclVoter = aclVoter;
        this.graphPathBean = graphPathBean;
        this.deletionInstance = deletionInstance;
        this.targetClasses = targetClasses;
        this.graphPolicy = graphPolicy;
        this.unnullable = unnullable;
        this.applicationContext = applicationContext;
    }

    @Override
    public Map<String, String> getCallContext() {
        return new HashMap<String, String>((Map<String, String>)ALL_GROUPS_CONTEXT);
    }

    @Override
    public void init(Helper helper) {
        if (LOGGER.isDebugEnabled()) {
            GraphUtil.ParameterReporter arguments = new GraphUtil.ParameterReporter();
            arguments.addParameter("targetObjects", this.targetObjects);
            arguments.addParameter("childOptions", (Object)this.childOptions);
            arguments.addParameter("typesToIgnore", (Object)this.typesToIgnore);
            arguments.addParameter("dryRun", this.dryRun);
            LOGGER.debug("request: " + arguments);
        }
        this.helper = helper;
        helper.setSteps(this.dryRun ? 4 : 6);
        this.graphHelper = new GraphHelper(helper, this.graphPathBean);
        this.graphPolicy = IgnoreTypePolicy.getIgnoreTypePolicy(this.graphPolicy, this.graphHelper.getClassesFromNames(this.typesToIgnore));
        this.graphTraversal = this.graphHelper.prepareGraphTraversal(this.childOptions, REQUIRED_ABILITIES, this.graphPolicy, this.graphPolicyAdjusters, this.aclVoter, this.graphPathBean, this.unnullable, new InternalProcessor(), this.dryRun);
        this.graphPolicyAdjusters = null;
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        try {
            switch (step) {
                case 0: {
                    SetMultimap<String, Long> targetMultimap = this.graphHelper.getTargetMultimap(this.targetClasses, this.targetObjects);
                    this.targetObjectCount += targetMultimap.size();
                    Map.Entry plan = this.graphTraversal.planOperation(targetMultimap, false, true);
                    if (!((SetMultimap)plan.getKey()).isEmpty()) {
                        IllegalStateException e = new IllegalStateException("deletion does not do anything other than delete");
                        this.helper.cancel(new ERR(), (Throwable)e, "graph-fail", new String[0]);
                    }
                    return GraphUtil.arrangeDeletionTargets(this.helper.getSession(), (SetMultimap<String, Long>)((SetMultimap)plan.getValue()));
                }
                case 1: {
                    this.graphTraversal.assertNoPolicyViolations();
                    return null;
                }
                case 2: {
                    this.processor = this.graphTraversal.processTargets();
                    return null;
                }
                case 3: {
                    this.unlinker = this.graphTraversal.unlinkTargets(true);
                    this.graphTraversal = null;
                    return null;
                }
                case 4: {
                    this.unlinker.execute();
                    return null;
                }
                case 5: {
                    this.processor.execute();
                    return null;
                }
            }
            IllegalArgumentException e = new IllegalArgumentException("model object graph operation has no step " + step);
            throw this.helper.cancel(new ERR(), (Throwable)e, "bad-step", new String[0]);
        }
        catch (HandleI.Cancel c) {
            throw c;
        }
        catch (ome.services.graphs.GraphException ge) {
            GraphException graphERR = new GraphException();
            graphERR.message = ge.message;
            throw this.helper.cancel((ERR)graphERR, (Throwable)ge, "graph-fail", new String[0]);
        }
        catch (Throwable t) {
            throw this.helper.cancel(new ERR(), t, "graph-fail", new String[0]);
        }
    }

    @Override
    public void finish() {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (step == 0) {
            SetMultimap result = (SetMultimap)object;
            if (!this.dryRun) {
                try {
                    this.deletionInstance.deleteFiles(GraphUtil.trimPackageNames(result));
                }
                catch (Exception e) {
                    this.helper.cancel(new ERR(), (Throwable)e, "file-delete-fail", new String[0]);
                }
            }
            Map<String, List<Long>> deletedObjects = GraphUtil.copyMultimapForResponse((SetMultimap<String, Long>)result);
            this.deletedObjectCount += result.size();
            Delete2Response response = new Delete2Response(deletedObjects);
            this.helper.setResponseIfNull(response);
            this.helper.info("in " + (this.dryRun ? "mock " : "") + "delete of " + this.targetObjectCount + ", deleted " + this.deletedObjectCount + " in total", new Object[0]);
            if (LOGGER.isDebugEnabled()) {
                GraphUtil.ParameterReporter arguments = new GraphUtil.ParameterReporter();
                arguments.addParameter("deletedObjects", response.deletedObjects);
                LOGGER.debug("response: " + arguments);
            }
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    @Override
    public void copyFieldsTo(Delete2 request) {
        GraphUtil.copyFields(this, request);
    }

    @Override
    public void adjustGraphPolicy(Function<GraphPolicy, GraphPolicy> adjuster) {
        if (this.graphPolicyAdjusters == null) {
            throw new IllegalStateException("request is already initialized");
        }
        this.graphPolicyAdjusters.add(adjuster);
    }

    @Override
    public int getStepProvidingCompleteResponse() {
        return 0;
    }

    @Override
    public GraphPolicy.Action getActionForStarting() {
        return GraphPolicy.Action.DELETE;
    }

    @Override
    public Map<String, List<Long>> getStartFrom(Response response) {
        return ((Delete2Response)response).deletedObjects;
    }

    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        return this.dryRun;
    }

    private final class InternalProcessor
    extends BaseGraphTraversalProcessor {
        public InternalProcessor() {
            super(Delete2I.this.helper.getSession());
        }

        @Override
        public void deleteInstances(String className, Collection<Long> ids) throws ome.services.graphs.GraphException {
            super.deleteInstances(className, ids);
            Delete2I.this.graphHelper.publishEventLog(Delete2I.this.applicationContext, "DELETE", className, ids);
        }

        public void processInstances(String className, Collection<Long> ids) throws ome.services.graphs.GraphException {
            this.deleteInstances(className, ids);
        }

        public Set<GraphPolicy.Ability> getRequiredPermissions() {
            return REQUIRED_ABILITIES;
        }
    }
}

