/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway;

import com.google.common.collect.ImmutableList;
import java.util.List;
import omero.IllegalArgumentException;
import omero.gateway.ServerInformation;
import omero.gateway.UserCredentials;

public class LoginCredentials {
    private UserCredentials user = new UserCredentials();
    private ServerInformation server = new ServerInformation();
    private String applicationName;
    private boolean encryption = true;
    private boolean checkNetwork = true;
    private float compression = 0.85f;
    private long groupID = -1L;
    private ImmutableList<String> args = null;

    public LoginCredentials() {
    }

    public LoginCredentials(String[] args) {
        this();
        if (args == null) {
            throw new IllegalArgumentException("No connection arguments");
        }
        this.args = ImmutableList.copyOf((Object[])args);
    }

    public LoginCredentials(String username, String password, String host) {
        this(username, password, host, 4064);
    }

    public LoginCredentials(String username, String password, String host, int port) {
        this();
        this.user.setUsername(username);
        this.user.setPassword(password);
        this.server.setHostname(host);
        this.server.setPort(port);
    }

    public List<String> getArguments() {
        return this.args;
    }

    public boolean isEncryption() {
        return this.encryption;
    }

    public void setEncryption(boolean encryption) {
        this.encryption = encryption;
    }

    public boolean isCheckNetwork() {
        return this.checkNetwork;
    }

    public void setCheckNetwork(boolean checkNetwork) {
        this.checkNetwork = checkNetwork;
    }

    public float getCompression() {
        return this.compression;
    }

    public void setCompression(float compression) {
        this.compression = compression;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public UserCredentials getUser() {
        return this.user;
    }

    public ServerInformation getServer() {
        return this.server;
    }

    public long getGroupID() {
        return this.groupID;
    }

    public void setGroupID(long groupID) {
        this.groupID = groupID;
    }
}

