/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.ArrayList;
import java.util.List;
import omero.RBool;
import omero.RString;
import omero.gateway.model.DataObject;
import omero.gateway.model.GroupData;
import omero.gateway.model.SetMutator;
import omero.model.Experimenter;
import omero.model.ExperimenterI;
import omero.model.GroupExperimenterMap;
import omero.rtypes;
import org.apache.commons.collections.CollectionUtils;

public class ExperimenterData
extends DataObject {
    public static final String FIRSTNAME = "ome.model.meta.Experimenter_firstName";
    public static final String MIDDLENAME = "ome.model.meta.Experimenter_middleName";
    public static final String LASTNAME = "ome.model.meta.Experimenter_lastName";
    public static final String EMAIL = "ome.model.meta.Experimenter_email";
    public static final String OMENAME = "ome.model.meta.Experimenter_omeName";
    public static final String INSTITUTION = "ome.model.meta.Experimenter_institution";
    public static final String GROUP_EXPERIMENTER_MAP = "ome.model.meta.Experimenter_groupExperimenterMap";
    private List<GroupData> groups;

    public ExperimenterData() {
        this.setDirty(true);
        this.setValue(new ExperimenterI());
    }

    public ExperimenterData(Experimenter experimenter) {
        if (experimenter == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(experimenter);
    }

    public void setFirstName(String firstName) {
        this.setDirty(true);
        this.asExperimenter().setFirstName(rtypes.rstring(firstName));
    }

    public String getFirstName() {
        RString n = this.asExperimenter().getFirstName();
        if (n == null || n.getValue() == null) {
            return "";
        }
        return n.getValue();
    }

    public void setLastName(String lastName) {
        this.setDirty(true);
        this.asExperimenter().setLastName(rtypes.rstring(lastName));
    }

    public String getLastName() {
        RString n = this.asExperimenter().getLastName();
        if (n == null || n.getValue() == null) {
            return "";
        }
        return n.getValue();
    }

    public String getUserName() {
        RString n = this.asExperimenter().getOmeName();
        if (n == null || n.getValue() == null) {
            throw new IllegalStateException("The name should never have been null");
        }
        return n.getValue();
    }

    public void setEmail(String email) {
        this.setDirty(true);
        this.asExperimenter().setEmail(rtypes.rstring(email));
    }

    public String getEmail() {
        RString e = this.asExperimenter().getEmail();
        return e == null ? null : e.getValue();
    }

    public void setInstitution(String institution) {
        this.setDirty(true);
        this.asExperimenter().setInstitution(institution == null ? null : rtypes.rstring(institution));
    }

    public String getInstitution() {
        RString i = this.asExperimenter().getInstitution();
        return i == null ? null : i.getValue();
    }

    public List<GroupData> getGroups() {
        if (this.groups == null && this.asExperimenter().sizeOfGroupExperimenterMap() >= 0) {
            this.groups = new ArrayList<GroupData>();
            List<GroupExperimenterMap> links = this.asExperimenter().copyGroupExperimenterMap();
            for (GroupExperimenterMap link : links) {
                if (link == null) continue;
                this.groups.add(new GroupData(link.getParent()));
            }
        }
        return this.groups == null ? null : new ArrayList<GroupData>(this.groups);
    }

    public void setGroups(List<GroupData> newValue) {
        ArrayList<GroupData> currentValue = new ArrayList<GroupData>(this.getGroups());
        SetMutator<GroupData> m = new SetMutator<GroupData>(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asExperimenter().unlinkExperimenterGroup(m.nextDeletion().asGroup());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asExperimenter().linkExperimenterGroup(m.nextAddition().asGroup());
        }
        this.groups = m.result();
    }

    public GroupData getDefaultGroup() {
        List<GroupData> groups = this.getGroups();
        if (CollectionUtils.isEmpty(groups)) {
            return null;
        }
        return groups.get(0);
    }

    public String getMiddleName() {
        RString n = this.asExperimenter().getMiddleName();
        if (n == null || n.getValue() == null) {
            throw new IllegalStateException("The name should never have been null");
        }
        return n.getValue();
    }

    public void setMiddleName(String middleName) {
        this.setDirty(true);
        this.asExperimenter().setMiddleName(rtypes.rstring(middleName));
    }

    public boolean isActive() {
        List<GroupData> groups = this.getGroups();
        if (CollectionUtils.isEmpty(groups)) {
            return false;
        }
        for (GroupData g : groups) {
            if (!"user".equals(g.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getGroupId() {
        GroupData g = this.getDefaultGroup();
        if (g == null) {
            return -1L;
        }
        return g.getId();
    }

    public boolean isMemberOfGroup(long groupId) {
        for (GroupData group : this.getGroups()) {
            if (group.getId() != groupId) continue;
            return true;
        }
        return false;
    }

    public boolean isLDAP() {
        RBool ldap = this.asExperimenter().getLdap();
        if (ldap == null) {
            return false;
        }
        return ldap.getValue();
    }
}

