/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import omero.RString;
import omero.gateway.model.DataObject;
import omero.model.IObject;
import omero.model.OriginalFile;

public class FileData
extends DataObject {
    private String description;
    private boolean directory;
    private boolean hidden;
    private String repositoryPath;

    public FileData(OriginalFile object) {
        this(object, false, false);
    }

    public FileData(OriginalFile object, boolean directory) {
        this(object, directory, false);
    }

    public FileData(OriginalFile object, boolean directory, boolean hidden) {
        if (!(object instanceof OriginalFile)) {
            throw new IllegalArgumentException("File not supported.");
        }
        this.setValue(object);
        this.directory = directory;
        this.hidden = hidden;
        this.repositoryPath = "";
    }

    public void setRegisteredFile(OriginalFile object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof OriginalFile)) {
            throw new IllegalArgumentException("File not supported.");
        }
        OriginalFile of = (OriginalFile)this.asIObject();
        of.setId(object.getId());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRepositoryPath(String path) {
        if (path == null) {
            path = "";
        }
        this.repositoryPath = path;
    }

    public String getName() {
        OriginalFile of = (OriginalFile)this.asIObject();
        RString value = of.getName();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getPath() {
        OriginalFile of = (OriginalFile)this.asIObject();
        RString value = of.getPath();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getAbsolutePath() {
        return this.repositoryPath + this.getPath() + this.getName();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public long lastModified() {
        IObject o = this.asIObject();
        if (o == null) {
            return -1L;
        }
        if (o instanceof OriginalFile) {
            return ((OriginalFile)o).getCtime().getValue();
        }
        return -1L;
    }

    public boolean isDirectory() {
        return this.directory;
    }
}

