/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import ome.model.units.BigResult;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.Pixels;
import omero.model.PixelsI;
import omero.model.PixelsType;
import omero.model.enums.UnitsLength;
import omero.rtypes;

public class PixelsData
extends DataObject {
    public static final String IMAGE = "ome.model.core.Pixels_image";
    public static final String INT8_TYPE = "int8";
    public static final String INT16_TYPE = "int16";
    public static final String INT32_TYPE = "int32";
    public static final String UINT8_TYPE = "uint8";
    public static final String UINT16_TYPE = "uint16";
    public static final String UINT32_TYPE = "uint32";
    public static final String FLOAT_TYPE = "float";
    public static final String DOUBLE_TYPE = "double";
    public static final String COMPLEX_TYPE = "complex";
    public static final String DOUBLE_COMPLEX_TYPE = "double-complex";
    private ImageData image;

    public PixelsData() {
        this.setDirty(true);
        this.setValue(new PixelsI());
    }

    public PixelsData(Pixels pixels) {
        if (pixels == null) {
            throw new IllegalArgumentException("The object cannot be null.");
        }
        this.setValue(pixels);
    }

    public void setSizeX(int sizeX) {
        this.setDirty(true);
        this.asPixels().setSizeX(rtypes.rint(sizeX));
    }

    public int getSizeX() {
        return this.nullSafe(this.asPixels().getSizeX());
    }

    public void setSizeY(int sizeY) {
        this.setDirty(true);
        this.asPixels().setSizeY(rtypes.rint(sizeY));
    }

    public int getSizeY() {
        return this.nullSafe(this.asPixels().getSizeY());
    }

    public void setSizeZ(int sizeZ) {
        this.setDirty(true);
        this.asPixels().setSizeZ(rtypes.rint(sizeZ));
    }

    public int getSizeZ() {
        return this.nullSafe(this.asPixels().getSizeZ());
    }

    public void setSizeC(int sizeC) {
        this.setDirty(true);
        this.asPixels().setSizeC(rtypes.rint(sizeC));
    }

    public int getSizeC() {
        return this.nullSafe(this.asPixels().getSizeC());
    }

    public void setSizeT(int sizeT) {
        this.setDirty(true);
        this.asPixels().setSizeT(rtypes.rint(sizeT));
    }

    public int getSizeT() {
        return this.nullSafe(this.asPixels().getSizeT());
    }

    public void setPixelSizeX(Length pixelSizeX) {
        this.setDirty(true);
        this.asPixels().setPhysicalSizeX(pixelSizeX);
    }

    public Length getPixelSizeX(UnitsLength unit) throws BigResult {
        Length l = this.asPixels().getPhysicalSizeX();
        if (l == null || l.getUnit().equals(UnitsLength.PIXEL)) {
            return null;
        }
        return unit == null ? l : new LengthI(l, unit);
    }

    public void setPixelSizeY(Length pixelSizeY) {
        this.setDirty(true);
        this.asPixels().setPhysicalSizeY(pixelSizeY);
    }

    public Length getPixelSizeY(UnitsLength unit) throws BigResult {
        Length l = this.asPixels().getPhysicalSizeY();
        if (l == null || l.getUnit().equals(UnitsLength.PIXEL)) {
            return null;
        }
        return unit == null ? l : new LengthI(l, unit);
    }

    public void setPixelSizeZ(Length pixelSizeZ) {
        this.setDirty(true);
        this.asPixels().setPhysicalSizeZ(pixelSizeZ);
    }

    public Length getPixelSizeZ(UnitsLength unit) throws BigResult {
        Length l = this.asPixels().getPhysicalSizeZ();
        if (l == null || l.getUnit().equals(UnitsLength.PIXEL)) {
            return null;
        }
        return unit == null ? l : new LengthI(l, unit);
    }

    public String getPixelType() {
        PixelsType type = this.asPixels().getPixelsType();
        return type == null ? null : (type.getValue() == null ? null : type.getValue().getValue());
    }

    public ImageData getImage() {
        if (this.image == null && this.asPixels().getImage() != null) {
            this.image = new ImageData(this.asPixels().getImage());
        }
        return this.image;
    }

    public void setImage(ImageData image) {
        this.setDirty(true);
        this.image = image;
        if (image == null) {
            this.asPixels().setImage(null);
        } else {
            this.asPixels().setImage(image.asImage());
        }
    }
}

