/*
 * Decompiled with CFR 0.152.
 */
package omero.grid;

import Ice.Current;
import Ice.Identity;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import omero.RInt;
import omero.ServerError;
import omero.client;
import omero.grid.ProcessCallbackPrx;
import omero.grid.ProcessCallbackPrxHelper;
import omero.grid.ProcessPrx;
import omero.grid._ProcessCallbackDisp;

public class ProcessCallbackI
extends _ProcessCallbackDisp {
    private final ObjectAdapter adapter;
    private final Identity id;
    private final BlockingQueue<Action> q = new LinkedBlockingQueue<Action>();
    private final boolean poll;
    protected final ProcessPrx process;

    public ProcessCallbackI(ProcessCallbackI pcb) throws ServerError {
        this(pcb.adapter, pcb.id.category, pcb.process);
    }

    public ProcessCallbackI(client client2, ProcessPrx process) throws ServerError {
        this(client2, process, true);
    }

    public ProcessCallbackI(client client2, ProcessPrx process, boolean poll) throws ServerError {
        this(client2.getAdapter(), client2.getCategory(), process, poll);
    }

    public ProcessCallbackI(ObjectAdapter adapter, String category, ProcessPrx process) throws ServerError {
        this(adapter, category, process, true);
    }

    public ProcessCallbackI(ObjectAdapter adapter, String category, ProcessPrx process, boolean poll) throws ServerError {
        this.adapter = adapter;
        this.poll = poll;
        this.process = process;
        this.id = new Identity();
        this.id.name = UUID.randomUUID().toString();
        this.id.category = category;
        ObjectPrx prx = adapter.add((Object)this, this.id);
        ProcessCallbackPrx cb = ProcessCallbackPrxHelper.uncheckedCast(prx);
        process.registerCallback(cb);
    }

    public Action block(long ms) throws InterruptedException {
        if (this.poll) {
            try {
                RInt rc = this.process.poll();
                if (rc != null) {
                    this.processFinished(rc.getValue(), null);
                }
            }
            catch (Exception e) {
                System.err.println("Error calling poll:" + e);
            }
        }
        return this.q.poll(ms, TimeUnit.MILLISECONDS);
    }

    @Override
    public void processCancelled(boolean success, Current __current) {
        try {
            this.q.put(Action.CANCELLED);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processFinished(int returncode, Current __current) {
        try {
            this.q.put(Action.FINISHED);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processKilled(boolean success, Current __current) {
        try {
            this.q.put(Action.KILLED);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.adapter.remove(this.id);
    }

    public static enum Action {
        FINISHED,
        CANCELLED,
        KILLED;

    }
}

