/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import Ice.DispatchStatus;
import Ice.FormatType;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import IceInternal.BasicStream;
import IceInternal.Ex;
import IceInternal.Incoming;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import omero.RInt;
import omero.RIntHolder;
import omero.RLong;
import omero.RString;
import omero.RStringHolder;
import omero.model.Details;
import omero.model.Dichroic;
import omero.model.DichroicHolder;
import omero.model.Filter;
import omero.model.FilterHolder;
import omero.model.FilterSetEmissionFilterLink;
import omero.model.FilterSetEmissionFilterLinkHolder;
import omero.model.FilterSetEmissionFilterLinkSeqHelper;
import omero.model.FilterSetExcitationFilterLink;
import omero.model.FilterSetExcitationFilterLinkHolder;
import omero.model.FilterSetExcitationFilterLinkSeqHelper;
import omero.model.FilterSetHolder;
import omero.model.FilterSetLinkedEmissionFilterSeqHelper;
import omero.model.FilterSetLinkedExcitationFilterSeqHelper;
import omero.model.IObject;
import omero.model.Instrument;
import omero.model.InstrumentHolder;
import omero.model._FilterSetOperations;
import omero.model._FilterSetOperationsNC;
import omero.sys.CountMapHelper;

public abstract class FilterSet
extends IObject
implements _FilterSetOperations,
_FilterSetOperationsNC {
    public static final String[] __ids = new String[]{"::Ice::Object", "::omero::model::FilterSet", "::omero::model::IObject"};
    private static final String[] __all = new String[]{"addAllFilterSetEmissionFilterLinkSet", "addAllFilterSetExcitationFilterLinkSet", "addFilterSetEmissionFilterLink", "addFilterSetEmissionFilterLinkToBoth", "addFilterSetExcitationFilterLink", "addFilterSetExcitationFilterLinkToBoth", "clearEmissionFilterLink", "clearExcitationFilterLink", "copyEmissionFilterLink", "copyExcitationFilterLink", "findFilterSetEmissionFilterLink", "findFilterSetExcitationFilterLink", "getDetails", "getDichroic", "getEmissionFilterLinkCountPerOwner", "getExcitationFilterLinkCountPerOwner", "getId", "getInstrument", "getLotNumber", "getManufacturer", "getModel", "getSerialNumber", "getVersion", "ice_id", "ice_ids", "ice_isA", "ice_ping", "isAnnotated", "isGlobal", "isLink", "isLoaded", "isMutable", "linkEmissionFilter", "linkExcitationFilter", "linkedEmissionFilterList", "linkedExcitationFilterList", "proxy", "reloadEmissionFilterLink", "reloadExcitationFilterLink", "removeAllFilterSetEmissionFilterLinkSet", "removeAllFilterSetExcitationFilterLinkSet", "removeFilterSetEmissionFilterLink", "removeFilterSetEmissionFilterLinkFromBoth", "removeFilterSetExcitationFilterLink", "removeFilterSetExcitationFilterLinkFromBoth", "setDichroic", "setId", "setInstrument", "setLotNumber", "setManufacturer", "setModel", "setSerialNumber", "setVersion", "shallowCopy", "sizeOfEmissionFilterLink", "sizeOfExcitationFilterLink", "unlinkEmissionFilter", "unlinkExcitationFilter", "unload", "unloadCollections", "unloadDetails", "unloadEmissionFilterLink", "unloadExcitationFilterLink"};
    protected RInt version;
    protected RString manufacturer;
    protected RString model;
    protected RString lotNumber;
    protected RString serialNumber;
    protected Instrument instrument;
    protected List<FilterSetExcitationFilterLink> excitationFilterLinkSeq;
    protected boolean excitationFilterLinkLoaded;
    protected Map<Long, Long> excitationFilterLinkCountPerOwner;
    protected Dichroic dichroic;
    protected List<FilterSetEmissionFilterLink> emissionFilterLinkSeq;
    protected boolean emissionFilterLinkLoaded;
    protected Map<Long, Long> emissionFilterLinkCountPerOwner;
    public static final long serialVersionUID = -3220472105228078194L;

    public FilterSet() {
    }

    public FilterSet(RLong id, Details details, boolean loaded, RInt version, RString manufacturer, RString model, RString lotNumber, RString serialNumber, Instrument instrument, List<FilterSetExcitationFilterLink> excitationFilterLinkSeq, boolean excitationFilterLinkLoaded, Map<Long, Long> excitationFilterLinkCountPerOwner, Dichroic dichroic, List<FilterSetEmissionFilterLink> emissionFilterLinkSeq, boolean emissionFilterLinkLoaded, Map<Long, Long> emissionFilterLinkCountPerOwner) {
        super(id, details, loaded);
        this.version = version;
        this.manufacturer = manufacturer;
        this.model = model;
        this.lotNumber = lotNumber;
        this.serialNumber = serialNumber;
        this.instrument = instrument;
        this.excitationFilterLinkSeq = excitationFilterLinkSeq;
        this.excitationFilterLinkLoaded = excitationFilterLinkLoaded;
        this.excitationFilterLinkCountPerOwner = excitationFilterLinkCountPerOwner;
        this.dichroic = dichroic;
        this.emissionFilterLinkSeq = emissionFilterLinkSeq;
        this.emissionFilterLinkLoaded = emissionFilterLinkLoaded;
        this.emissionFilterLinkCountPerOwner = emissionFilterLinkCountPerOwner;
    }

    @Override
    public boolean ice_isA(String s) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public boolean ice_isA(String s, Current __current) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public String[] ice_ids() {
        return __ids;
    }

    @Override
    public String[] ice_ids(Current __current) {
        return __ids;
    }

    @Override
    public String ice_id() {
        return __ids[1];
    }

    @Override
    public String ice_id(Current __current) {
        return __ids[1];
    }

    public static String ice_staticId() {
        return __ids[1];
    }

    @Override
    public final void addAllFilterSetEmissionFilterLinkSet(List<FilterSetEmissionFilterLink> targets) {
        this.addAllFilterSetEmissionFilterLinkSet(targets, null);
    }

    @Override
    public final void addAllFilterSetExcitationFilterLinkSet(List<FilterSetExcitationFilterLink> targets) {
        this.addAllFilterSetExcitationFilterLinkSet(targets, null);
    }

    @Override
    public final void addFilterSetEmissionFilterLink(FilterSetEmissionFilterLink target) {
        this.addFilterSetEmissionFilterLink(target, null);
    }

    @Override
    public final void addFilterSetEmissionFilterLinkToBoth(FilterSetEmissionFilterLink link, boolean bothSides) {
        this.addFilterSetEmissionFilterLinkToBoth(link, bothSides, null);
    }

    @Override
    public final void addFilterSetExcitationFilterLink(FilterSetExcitationFilterLink target) {
        this.addFilterSetExcitationFilterLink(target, null);
    }

    @Override
    public final void addFilterSetExcitationFilterLinkToBoth(FilterSetExcitationFilterLink link, boolean bothSides) {
        this.addFilterSetExcitationFilterLinkToBoth(link, bothSides, null);
    }

    @Override
    public final void clearEmissionFilterLink() {
        this.clearEmissionFilterLink(null);
    }

    @Override
    public final void clearExcitationFilterLink() {
        this.clearExcitationFilterLink(null);
    }

    @Override
    public final List<FilterSetEmissionFilterLink> copyEmissionFilterLink() {
        return this.copyEmissionFilterLink(null);
    }

    @Override
    public final List<FilterSetExcitationFilterLink> copyExcitationFilterLink() {
        return this.copyExcitationFilterLink(null);
    }

    @Override
    public final List<FilterSetEmissionFilterLink> findFilterSetEmissionFilterLink(Filter removal) {
        return this.findFilterSetEmissionFilterLink(removal, null);
    }

    @Override
    public final List<FilterSetExcitationFilterLink> findFilterSetExcitationFilterLink(Filter removal) {
        return this.findFilterSetExcitationFilterLink(removal, null);
    }

    @Override
    public final Dichroic getDichroic() {
        return this.getDichroic(null);
    }

    @Override
    public final Map<Long, Long> getEmissionFilterLinkCountPerOwner() {
        return this.getEmissionFilterLinkCountPerOwner(null);
    }

    @Override
    public final Map<Long, Long> getExcitationFilterLinkCountPerOwner() {
        return this.getExcitationFilterLinkCountPerOwner(null);
    }

    @Override
    public final Instrument getInstrument() {
        return this.getInstrument(null);
    }

    @Override
    public final RString getLotNumber() {
        return this.getLotNumber(null);
    }

    @Override
    public final RString getManufacturer() {
        return this.getManufacturer(null);
    }

    @Override
    public final RString getModel() {
        return this.getModel(null);
    }

    @Override
    public final RString getSerialNumber() {
        return this.getSerialNumber(null);
    }

    @Override
    public final RInt getVersion() {
        return this.getVersion(null);
    }

    @Override
    public final FilterSetEmissionFilterLink linkEmissionFilter(Filter addition) {
        return this.linkEmissionFilter(addition, null);
    }

    @Override
    public final FilterSetExcitationFilterLink linkExcitationFilter(Filter addition) {
        return this.linkExcitationFilter(addition, null);
    }

    @Override
    public final List<Filter> linkedEmissionFilterList() {
        return this.linkedEmissionFilterList(null);
    }

    @Override
    public final List<Filter> linkedExcitationFilterList() {
        return this.linkedExcitationFilterList(null);
    }

    @Override
    public final void reloadEmissionFilterLink(FilterSet toCopy) {
        this.reloadEmissionFilterLink(toCopy, null);
    }

    @Override
    public final void reloadExcitationFilterLink(FilterSet toCopy) {
        this.reloadExcitationFilterLink(toCopy, null);
    }

    @Override
    public final void removeAllFilterSetEmissionFilterLinkSet(List<FilterSetEmissionFilterLink> targets) {
        this.removeAllFilterSetEmissionFilterLinkSet(targets, null);
    }

    @Override
    public final void removeAllFilterSetExcitationFilterLinkSet(List<FilterSetExcitationFilterLink> targets) {
        this.removeAllFilterSetExcitationFilterLinkSet(targets, null);
    }

    @Override
    public final void removeFilterSetEmissionFilterLink(FilterSetEmissionFilterLink theTarget) {
        this.removeFilterSetEmissionFilterLink(theTarget, null);
    }

    @Override
    public final void removeFilterSetEmissionFilterLinkFromBoth(FilterSetEmissionFilterLink link, boolean bothSides) {
        this.removeFilterSetEmissionFilterLinkFromBoth(link, bothSides, null);
    }

    @Override
    public final void removeFilterSetExcitationFilterLink(FilterSetExcitationFilterLink theTarget) {
        this.removeFilterSetExcitationFilterLink(theTarget, null);
    }

    @Override
    public final void removeFilterSetExcitationFilterLinkFromBoth(FilterSetExcitationFilterLink link, boolean bothSides) {
        this.removeFilterSetExcitationFilterLinkFromBoth(link, bothSides, null);
    }

    @Override
    public final void setDichroic(Dichroic theDichroic) {
        this.setDichroic(theDichroic, null);
    }

    @Override
    public final void setInstrument(Instrument theInstrument) {
        this.setInstrument(theInstrument, null);
    }

    @Override
    public final void setLotNumber(RString theLotNumber) {
        this.setLotNumber(theLotNumber, null);
    }

    @Override
    public final void setManufacturer(RString theManufacturer) {
        this.setManufacturer(theManufacturer, null);
    }

    @Override
    public final void setModel(RString theModel) {
        this.setModel(theModel, null);
    }

    @Override
    public final void setSerialNumber(RString theSerialNumber) {
        this.setSerialNumber(theSerialNumber, null);
    }

    @Override
    public final void setVersion(RInt theVersion) {
        this.setVersion(theVersion, null);
    }

    @Override
    public final int sizeOfEmissionFilterLink() {
        return this.sizeOfEmissionFilterLink(null);
    }

    @Override
    public final int sizeOfExcitationFilterLink() {
        return this.sizeOfExcitationFilterLink(null);
    }

    @Override
    public final void unlinkEmissionFilter(Filter removal) {
        this.unlinkEmissionFilter(removal, null);
    }

    @Override
    public final void unlinkExcitationFilter(Filter removal) {
        this.unlinkExcitationFilter(removal, null);
    }

    @Override
    public final void unloadEmissionFilterLink() {
        this.unloadEmissionFilterLink(null);
    }

    @Override
    public final void unloadExcitationFilterLink() {
        this.unloadExcitationFilterLink(null);
    }

    public static DispatchStatus ___getVersion(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RInt __ret = __obj.getVersion(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setVersion(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RIntHolder theVersion = new RIntHolder();
        __is.readObject((IceInternal.Patcher)theVersion);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setVersion((RInt)theVersion.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getManufacturer(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RString __ret = __obj.getManufacturer(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setManufacturer(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RStringHolder theManufacturer = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theManufacturer);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setManufacturer((RString)theManufacturer.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getModel(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RString __ret = __obj.getModel(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setModel(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RStringHolder theModel = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theModel);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setModel((RString)theModel.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getLotNumber(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RString __ret = __obj.getLotNumber(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setLotNumber(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RStringHolder theLotNumber = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theLotNumber);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setLotNumber((RString)theLotNumber.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getSerialNumber(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RString __ret = __obj.getSerialNumber(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setSerialNumber(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RStringHolder theSerialNumber = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theSerialNumber);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setSerialNumber((RString)theSerialNumber.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getInstrument(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Instrument __ret = __obj.getInstrument(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setInstrument(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        InstrumentHolder theInstrument = new InstrumentHolder();
        __is.readObject((IceInternal.Patcher)theInstrument);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setInstrument((Instrument)theInstrument.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadExcitationFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        __obj.unloadExcitationFilterLink(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfExcitationFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        int __ret = __obj.sizeOfExcitationFilterLink(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeInt(__ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyExcitationFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        List __ret = __obj.copyExcitationFilterLink(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        FilterSetExcitationFilterLinkSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addFilterSetExcitationFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterSetExcitationFilterLinkHolder target = new FilterSetExcitationFilterLinkHolder();
        __is.readObject((IceInternal.Patcher)target);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addFilterSetExcitationFilterLink((FilterSetExcitationFilterLink)target.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllFilterSetExcitationFilterLinkSet(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        List<FilterSetExcitationFilterLink> targets = FilterSetExcitationFilterLinkSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addAllFilterSetExcitationFilterLinkSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeFilterSetExcitationFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterSetExcitationFilterLinkHolder theTarget = new FilterSetExcitationFilterLinkHolder();
        __is.readObject((IceInternal.Patcher)theTarget);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeFilterSetExcitationFilterLink((FilterSetExcitationFilterLink)theTarget.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllFilterSetExcitationFilterLinkSet(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        List<FilterSetExcitationFilterLink> targets = FilterSetExcitationFilterLinkSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeAllFilterSetExcitationFilterLinkSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearExcitationFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        __obj.clearExcitationFilterLink(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadExcitationFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterSetHolder toCopy = new FilterSetHolder();
        __is.readObject((IceInternal.Patcher)toCopy);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.reloadExcitationFilterLink((FilterSet)toCopy.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getExcitationFilterLinkCountPerOwner(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Map __ret = __obj.getExcitationFilterLinkCountPerOwner(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        CountMapHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkExcitationFilter(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterHolder addition = new FilterHolder();
        __is.readObject((IceInternal.Patcher)addition);
        __is.readPendingObjects();
        __inS.endReadParams();
        FilterSetExcitationFilterLink __ret = __obj.linkExcitationFilter((Filter)addition.value, __current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addFilterSetExcitationFilterLinkToBoth(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterSetExcitationFilterLinkHolder link = new FilterSetExcitationFilterLinkHolder();
        __is.readObject((IceInternal.Patcher)link);
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addFilterSetExcitationFilterLinkToBoth((FilterSetExcitationFilterLink)link.value, bothSides, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___findFilterSetExcitationFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterHolder removal = new FilterHolder();
        __is.readObject((IceInternal.Patcher)removal);
        __is.readPendingObjects();
        __inS.endReadParams();
        List __ret = __obj.findFilterSetExcitationFilterLink((Filter)removal.value, __current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        FilterSetExcitationFilterLinkSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unlinkExcitationFilter(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterHolder removal = new FilterHolder();
        __is.readObject((IceInternal.Patcher)removal);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.unlinkExcitationFilter((Filter)removal.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeFilterSetExcitationFilterLinkFromBoth(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterSetExcitationFilterLinkHolder link = new FilterSetExcitationFilterLinkHolder();
        __is.readObject((IceInternal.Patcher)link);
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeFilterSetExcitationFilterLinkFromBoth((FilterSetExcitationFilterLink)link.value, bothSides, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkedExcitationFilterList(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        List __ret = __obj.linkedExcitationFilterList(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        FilterSetLinkedExcitationFilterSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getDichroic(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Dichroic __ret = __obj.getDichroic(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setDichroic(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        DichroicHolder theDichroic = new DichroicHolder();
        __is.readObject((IceInternal.Patcher)theDichroic);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setDichroic((Dichroic)theDichroic.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadEmissionFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        __obj.unloadEmissionFilterLink(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfEmissionFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        int __ret = __obj.sizeOfEmissionFilterLink(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeInt(__ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyEmissionFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        List __ret = __obj.copyEmissionFilterLink(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        FilterSetEmissionFilterLinkSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addFilterSetEmissionFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterSetEmissionFilterLinkHolder target = new FilterSetEmissionFilterLinkHolder();
        __is.readObject((IceInternal.Patcher)target);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addFilterSetEmissionFilterLink((FilterSetEmissionFilterLink)target.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllFilterSetEmissionFilterLinkSet(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        List<FilterSetEmissionFilterLink> targets = FilterSetEmissionFilterLinkSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addAllFilterSetEmissionFilterLinkSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeFilterSetEmissionFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterSetEmissionFilterLinkHolder theTarget = new FilterSetEmissionFilterLinkHolder();
        __is.readObject((IceInternal.Patcher)theTarget);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeFilterSetEmissionFilterLink((FilterSetEmissionFilterLink)theTarget.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllFilterSetEmissionFilterLinkSet(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        List<FilterSetEmissionFilterLink> targets = FilterSetEmissionFilterLinkSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeAllFilterSetEmissionFilterLinkSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearEmissionFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        __obj.clearEmissionFilterLink(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadEmissionFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterSetHolder toCopy = new FilterSetHolder();
        __is.readObject((IceInternal.Patcher)toCopy);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.reloadEmissionFilterLink((FilterSet)toCopy.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getEmissionFilterLinkCountPerOwner(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Map __ret = __obj.getEmissionFilterLinkCountPerOwner(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        CountMapHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkEmissionFilter(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterHolder addition = new FilterHolder();
        __is.readObject((IceInternal.Patcher)addition);
        __is.readPendingObjects();
        __inS.endReadParams();
        FilterSetEmissionFilterLink __ret = __obj.linkEmissionFilter((Filter)addition.value, __current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addFilterSetEmissionFilterLinkToBoth(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterSetEmissionFilterLinkHolder link = new FilterSetEmissionFilterLinkHolder();
        __is.readObject((IceInternal.Patcher)link);
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addFilterSetEmissionFilterLinkToBoth((FilterSetEmissionFilterLink)link.value, bothSides, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___findFilterSetEmissionFilterLink(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterHolder removal = new FilterHolder();
        __is.readObject((IceInternal.Patcher)removal);
        __is.readPendingObjects();
        __inS.endReadParams();
        List __ret = __obj.findFilterSetEmissionFilterLink((Filter)removal.value, __current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        FilterSetEmissionFilterLinkSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unlinkEmissionFilter(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterHolder removal = new FilterHolder();
        __is.readObject((IceInternal.Patcher)removal);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.unlinkEmissionFilter((Filter)removal.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeFilterSetEmissionFilterLinkFromBoth(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterSetEmissionFilterLinkHolder link = new FilterSetEmissionFilterLinkHolder();
        __is.readObject((IceInternal.Patcher)link);
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeFilterSetEmissionFilterLinkFromBoth((FilterSetEmissionFilterLink)link.value, bothSides, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkedEmissionFilterList(FilterSet __obj, Incoming __inS, Current __current) {
        FilterSet.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        List __ret = __obj.linkedEmissionFilterList(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        FilterSetLinkedEmissionFilterSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    @Override
    public DispatchStatus __dispatch(Incoming in, Current __current) {
        int pos = Arrays.binarySearch(__all, __current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
        }
        switch (pos) {
            case 0: {
                return FilterSet.___addAllFilterSetEmissionFilterLinkSet(this, in, __current);
            }
            case 1: {
                return FilterSet.___addAllFilterSetExcitationFilterLinkSet(this, in, __current);
            }
            case 2: {
                return FilterSet.___addFilterSetEmissionFilterLink(this, in, __current);
            }
            case 3: {
                return FilterSet.___addFilterSetEmissionFilterLinkToBoth(this, in, __current);
            }
            case 4: {
                return FilterSet.___addFilterSetExcitationFilterLink(this, in, __current);
            }
            case 5: {
                return FilterSet.___addFilterSetExcitationFilterLinkToBoth(this, in, __current);
            }
            case 6: {
                return FilterSet.___clearEmissionFilterLink(this, in, __current);
            }
            case 7: {
                return FilterSet.___clearExcitationFilterLink(this, in, __current);
            }
            case 8: {
                return FilterSet.___copyEmissionFilterLink(this, in, __current);
            }
            case 9: {
                return FilterSet.___copyExcitationFilterLink(this, in, __current);
            }
            case 10: {
                return FilterSet.___findFilterSetEmissionFilterLink(this, in, __current);
            }
            case 11: {
                return FilterSet.___findFilterSetExcitationFilterLink(this, in, __current);
            }
            case 12: {
                return IObject.___getDetails(this, in, __current);
            }
            case 13: {
                return FilterSet.___getDichroic(this, in, __current);
            }
            case 14: {
                return FilterSet.___getEmissionFilterLinkCountPerOwner(this, in, __current);
            }
            case 15: {
                return FilterSet.___getExcitationFilterLinkCountPerOwner(this, in, __current);
            }
            case 16: {
                return IObject.___getId(this, in, __current);
            }
            case 17: {
                return FilterSet.___getInstrument(this, in, __current);
            }
            case 18: {
                return FilterSet.___getLotNumber(this, in, __current);
            }
            case 19: {
                return FilterSet.___getManufacturer(this, in, __current);
            }
            case 20: {
                return FilterSet.___getModel(this, in, __current);
            }
            case 21: {
                return FilterSet.___getSerialNumber(this, in, __current);
            }
            case 22: {
                return FilterSet.___getVersion(this, in, __current);
            }
            case 23: {
                return FilterSet.___ice_id((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 24: {
                return FilterSet.___ice_ids((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 25: {
                return FilterSet.___ice_isA((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 26: {
                return FilterSet.___ice_ping((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 27: {
                return IObject.___isAnnotated(this, in, __current);
            }
            case 28: {
                return IObject.___isGlobal(this, in, __current);
            }
            case 29: {
                return IObject.___isLink(this, in, __current);
            }
            case 30: {
                return IObject.___isLoaded(this, in, __current);
            }
            case 31: {
                return IObject.___isMutable(this, in, __current);
            }
            case 32: {
                return FilterSet.___linkEmissionFilter(this, in, __current);
            }
            case 33: {
                return FilterSet.___linkExcitationFilter(this, in, __current);
            }
            case 34: {
                return FilterSet.___linkedEmissionFilterList(this, in, __current);
            }
            case 35: {
                return FilterSet.___linkedExcitationFilterList(this, in, __current);
            }
            case 36: {
                return IObject.___proxy(this, in, __current);
            }
            case 37: {
                return FilterSet.___reloadEmissionFilterLink(this, in, __current);
            }
            case 38: {
                return FilterSet.___reloadExcitationFilterLink(this, in, __current);
            }
            case 39: {
                return FilterSet.___removeAllFilterSetEmissionFilterLinkSet(this, in, __current);
            }
            case 40: {
                return FilterSet.___removeAllFilterSetExcitationFilterLinkSet(this, in, __current);
            }
            case 41: {
                return FilterSet.___removeFilterSetEmissionFilterLink(this, in, __current);
            }
            case 42: {
                return FilterSet.___removeFilterSetEmissionFilterLinkFromBoth(this, in, __current);
            }
            case 43: {
                return FilterSet.___removeFilterSetExcitationFilterLink(this, in, __current);
            }
            case 44: {
                return FilterSet.___removeFilterSetExcitationFilterLinkFromBoth(this, in, __current);
            }
            case 45: {
                return FilterSet.___setDichroic(this, in, __current);
            }
            case 46: {
                return IObject.___setId(this, in, __current);
            }
            case 47: {
                return FilterSet.___setInstrument(this, in, __current);
            }
            case 48: {
                return FilterSet.___setLotNumber(this, in, __current);
            }
            case 49: {
                return FilterSet.___setManufacturer(this, in, __current);
            }
            case 50: {
                return FilterSet.___setModel(this, in, __current);
            }
            case 51: {
                return FilterSet.___setSerialNumber(this, in, __current);
            }
            case 52: {
                return FilterSet.___setVersion(this, in, __current);
            }
            case 53: {
                return IObject.___shallowCopy(this, in, __current);
            }
            case 54: {
                return FilterSet.___sizeOfEmissionFilterLink(this, in, __current);
            }
            case 55: {
                return FilterSet.___sizeOfExcitationFilterLink(this, in, __current);
            }
            case 56: {
                return FilterSet.___unlinkEmissionFilter(this, in, __current);
            }
            case 57: {
                return FilterSet.___unlinkExcitationFilter(this, in, __current);
            }
            case 58: {
                return IObject.___unload(this, in, __current);
            }
            case 59: {
                return IObject.___unloadCollections(this, in, __current);
            }
            case 60: {
                return IObject.___unloadDetails(this, in, __current);
            }
            case 61: {
                return FilterSet.___unloadEmissionFilterLink(this, in, __current);
            }
            case 62: {
                return FilterSet.___unloadExcitationFilterLink(this, in, __current);
            }
        }
        assert (false);
        throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    @Override
    protected void __writeImpl(BasicStream __os) {
        __os.startWriteSlice(FilterSet.ice_staticId(), -1, false);
        __os.writeObject((Ice.Object)this.version);
        __os.writeObject((Ice.Object)this.manufacturer);
        __os.writeObject((Ice.Object)this.model);
        __os.writeObject((Ice.Object)this.lotNumber);
        __os.writeObject((Ice.Object)this.serialNumber);
        __os.writeObject((Ice.Object)this.instrument);
        FilterSetExcitationFilterLinkSeqHelper.write(__os, this.excitationFilterLinkSeq);
        __os.writeBool(this.excitationFilterLinkLoaded);
        CountMapHelper.write(__os, this.excitationFilterLinkCountPerOwner);
        __os.writeObject((Ice.Object)this.dichroic);
        FilterSetEmissionFilterLinkSeqHelper.write(__os, this.emissionFilterLinkSeq);
        __os.writeBool(this.emissionFilterLinkLoaded);
        CountMapHelper.write(__os, this.emissionFilterLinkCountPerOwner);
        __os.endWriteSlice();
        super.__writeImpl(__os);
    }

    @Override
    protected void __readImpl(BasicStream __is) {
        __is.startReadSlice();
        __is.readObject((IceInternal.Patcher)new Patcher(0));
        __is.readObject((IceInternal.Patcher)new Patcher(1));
        __is.readObject((IceInternal.Patcher)new Patcher(2));
        __is.readObject((IceInternal.Patcher)new Patcher(3));
        __is.readObject((IceInternal.Patcher)new Patcher(4));
        __is.readObject((IceInternal.Patcher)new Patcher(5));
        this.excitationFilterLinkSeq = FilterSetExcitationFilterLinkSeqHelper.read(__is);
        this.excitationFilterLinkLoaded = __is.readBool();
        this.excitationFilterLinkCountPerOwner = CountMapHelper.read(__is);
        __is.readObject((IceInternal.Patcher)new Patcher(6));
        this.emissionFilterLinkSeq = FilterSetEmissionFilterLinkSeqHelper.read(__is);
        this.emissionFilterLinkLoaded = __is.readBool();
        this.emissionFilterLinkCountPerOwner = CountMapHelper.read(__is);
        __is.endReadSlice();
        super.__readImpl(__is);
    }

    @Override
    public FilterSet clone() {
        return (FilterSet)super.clone();
    }

    private class Patcher
    implements IceInternal.Patcher {
        private int __member;
        private String __typeId;

        Patcher(int member) {
            this.__member = member;
        }

        public void patch(Ice.Object v) {
            switch (this.__member) {
                case 0: {
                    this.__typeId = "::omero::RInt";
                    if (v == null || v instanceof RInt) {
                        FilterSet.this.version = (RInt)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 1: {
                    this.__typeId = "::omero::RString";
                    if (v == null || v instanceof RString) {
                        FilterSet.this.manufacturer = (RString)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 2: {
                    this.__typeId = "::omero::RString";
                    if (v == null || v instanceof RString) {
                        FilterSet.this.model = (RString)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 3: {
                    this.__typeId = "::omero::RString";
                    if (v == null || v instanceof RString) {
                        FilterSet.this.lotNumber = (RString)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 4: {
                    this.__typeId = "::omero::RString";
                    if (v == null || v instanceof RString) {
                        FilterSet.this.serialNumber = (RString)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 5: {
                    this.__typeId = "::omero::model::Instrument";
                    if (v == null || v instanceof Instrument) {
                        FilterSet.this.instrument = (Instrument)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 6: {
                    this.__typeId = "::omero::model::Dichroic";
                    if (v == null || v instanceof Dichroic) {
                        FilterSet.this.dichroic = (Dichroic)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                }
            }
        }

        public String type() {
            return this.__typeId;
        }
    }
}

