/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Length;
import omero.model.Plate;
import omero.model.PlateAcquisition;
import omero.model.PlateAnnotationLink;
import omero.model.PlateAnnotationLinkI;
import omero.model.Screen;
import omero.model.ScreenPlateLink;
import omero.model.ScreenPlateLinkI;
import omero.model.Well;
import omero.rtypes;
import omero.util.IceMapper;

public class PlateI
extends Plate
implements ModelBased {
    public static final String DEFAULTSAMPLE = "ome.model.screen.Plate_defaultSample";
    public static final String COLUMNNAMINGCONVENTION = "ome.model.screen.Plate_columnNamingConvention";
    public static final String ROWNAMINGCONVENTION = "ome.model.screen.Plate_rowNamingConvention";
    public static final String WELLORIGINX = "ome.model.screen.Plate_wellOriginX";
    public static final String WELLORIGINY = "ome.model.screen.Plate_wellOriginY";
    public static final String ROWS = "ome.model.screen.Plate_rows";
    public static final String COLUMNS = "ome.model.screen.Plate_columns";
    public static final String STATUS = "ome.model.screen.Plate_status";
    public static final String EXTERNALIDENTIFIER = "ome.model.screen.Plate_externalIdentifier";
    public static final String SCREENLINKS = "ome.model.screen.Plate_screenLinks";
    public static final String WELLS = "ome.model.screen.Plate_wells";
    public static final String PLATEACQUISITIONS = "ome.model.screen.Plate_plateAcquisitions";
    public static final String ANNOTATIONLINKS = "ome.model.screen.Plate_annotationLinks";
    public static final String NAME = "ome.model.screen.Plate_name";
    public static final String DESCRIPTION = "ome.model.screen.Plate_description";
    public static final String DETAILS = "ome.model.screen.Plate_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.screenLinksSeq = new ArrayList();
            this.screenLinksLoaded = true;
        } else {
            this.screenLinksSeq = null;
            this.screenLinksLoaded = false;
        }
        if (load) {
            this.wellsSeq = new ArrayList();
            this.wellsLoaded = true;
        } else {
            this.wellsSeq = null;
            this.wellsLoaded = false;
        }
        if (load) {
            this.plateAcquisitionsSeq = new ArrayList();
            this.plateAcquisitionsLoaded = true;
        } else {
            this.plateAcquisitionsSeq = null;
            this.plateAcquisitionsLoaded = false;
        }
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public PlateI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public PlateI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public PlateI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadDefaultSample();
        this.unloadColumnNamingConvention();
        this.unloadRowNamingConvention();
        this.unloadWellOriginX();
        this.unloadWellOriginY();
        this.unloadRows();
        this.unloadColumns();
        this.unloadStatus();
        this.unloadExternalIdentifier();
        this.unloadScreenLinks();
        this.unloadWells();
        this.unloadPlateAcquisitions();
        this.unloadAnnotationLinks();
        this.unloadName();
        this.unloadDescription();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        PlateI copy = new PlateI();
        copy.id = this.id;
        copy.version = this.version;
        copy.defaultSample = this.defaultSample;
        copy.columnNamingConvention = this.columnNamingConvention;
        copy.rowNamingConvention = this.rowNamingConvention;
        copy.wellOriginX = this.wellOriginX == null ? null : this.wellOriginX.copy();
        copy.wellOriginY = this.wellOriginY == null ? null : this.wellOriginY.copy();
        copy.rows = this.rows;
        copy.columns = this.columns;
        copy.status = this.status;
        copy.externalIdentifier = this.externalIdentifier;
        if (!this.screenLinksLoaded) {
            copy.screenLinksLoaded = false;
            copy.screenLinksSeq = null;
        } else {
            copy.screenLinksLoaded = true;
            copy.screenLinksSeq = new ArrayList<ScreenPlateLink>();
            for (IObject item : this.screenLinksSeq) {
                copy.screenLinksSeq.add(item == null ? null : (ScreenPlateLink)item.proxy());
            }
        }
        if (!this.wellsLoaded) {
            copy.wellsLoaded = false;
            copy.wellsSeq = null;
        } else {
            copy.wellsLoaded = true;
            copy.wellsSeq = new ArrayList<Well>();
            for (IObject item : this.wellsSeq) {
                copy.wellsSeq.add(item == null ? null : (Well)item.proxy());
            }
        }
        if (!this.plateAcquisitionsLoaded) {
            copy.plateAcquisitionsLoaded = false;
            copy.plateAcquisitionsSeq = null;
        } else {
            copy.plateAcquisitionsLoaded = true;
            copy.plateAcquisitionsSeq = new ArrayList<PlateAcquisition>();
            for (IObject item : this.plateAcquisitionsSeq) {
                copy.plateAcquisitionsSeq.add(item == null ? null : (PlateAcquisition)item.proxy());
            }
        }
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<PlateAnnotationLink>();
            for (IObject item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (PlateAnnotationLink)item.proxy());
            }
        }
        copy.name = this.name;
        copy.description = this.description;
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new PlateI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadDefaultSample() {
        this.defaultSample = null;
    }

    @Override
    public RInt getDefaultSample(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.defaultSample;
    }

    @Override
    public void setDefaultSample(RInt defaultSample, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.defaultSample = defaultSample;
    }

    private void copyDefaultSample(ome.model.screen.Plate source, IceMapper mapper) {
        this.defaultSample = source.getDefaultSample() == null ? null : rtypes.rint(source.getDefaultSample());
    }

    private void fillDefaultSample(ome.model.screen.Plate target, IceMapper mapper) {
        try {
            target.setDefaultSample((Integer)mapper.fromRType(this.getDefaultSample()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadColumnNamingConvention() {
        this.columnNamingConvention = null;
    }

    @Override
    public RString getColumnNamingConvention(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.columnNamingConvention;
    }

    @Override
    public void setColumnNamingConvention(RString columnNamingConvention, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.columnNamingConvention = columnNamingConvention;
    }

    private void copyColumnNamingConvention(ome.model.screen.Plate source, IceMapper mapper) {
        this.columnNamingConvention = source.getColumnNamingConvention() == null ? null : rtypes.rstring(source.getColumnNamingConvention());
    }

    private void fillColumnNamingConvention(ome.model.screen.Plate target, IceMapper mapper) {
        try {
            target.setColumnNamingConvention((String)mapper.fromRType(this.getColumnNamingConvention()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadRowNamingConvention() {
        this.rowNamingConvention = null;
    }

    @Override
    public RString getRowNamingConvention(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.rowNamingConvention;
    }

    @Override
    public void setRowNamingConvention(RString rowNamingConvention, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.rowNamingConvention = rowNamingConvention;
    }

    private void copyRowNamingConvention(ome.model.screen.Plate source, IceMapper mapper) {
        this.rowNamingConvention = source.getRowNamingConvention() == null ? null : rtypes.rstring(source.getRowNamingConvention());
    }

    private void fillRowNamingConvention(ome.model.screen.Plate target, IceMapper mapper) {
        try {
            target.setRowNamingConvention((String)mapper.fromRType(this.getRowNamingConvention()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadWellOriginX() {
        this.wellOriginX = null;
    }

    @Override
    public Length getWellOriginX(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.wellOriginX;
    }

    @Override
    public void setWellOriginX(Length wellOriginX, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.wellOriginX = wellOriginX;
    }

    private void copyWellOriginX(ome.model.screen.Plate source, IceMapper mapper) {
        this.wellOriginX = (Length)mapper.findTarget(source.getWellOriginX());
    }

    private void fillWellOriginX(ome.model.screen.Plate target, IceMapper mapper) {
        target.putAt(WELLORIGINX, (Object)mapper.reverse((ModelBased)this.getWellOriginX()));
    }

    public void unloadWellOriginY() {
        this.wellOriginY = null;
    }

    @Override
    public Length getWellOriginY(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.wellOriginY;
    }

    @Override
    public void setWellOriginY(Length wellOriginY, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.wellOriginY = wellOriginY;
    }

    private void copyWellOriginY(ome.model.screen.Plate source, IceMapper mapper) {
        this.wellOriginY = (Length)mapper.findTarget(source.getWellOriginY());
    }

    private void fillWellOriginY(ome.model.screen.Plate target, IceMapper mapper) {
        target.putAt(WELLORIGINY, (Object)mapper.reverse((ModelBased)this.getWellOriginY()));
    }

    public void unloadRows() {
        this.rows = null;
    }

    @Override
    public RInt getRows(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.rows;
    }

    @Override
    public void setRows(RInt rows, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.rows = rows;
    }

    private void copyRows(ome.model.screen.Plate source, IceMapper mapper) {
        this.rows = source.getRows() == null ? null : rtypes.rint(source.getRows());
    }

    private void fillRows(ome.model.screen.Plate target, IceMapper mapper) {
        try {
            target.setRows((Integer)mapper.fromRType(this.getRows()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadColumns() {
        this.columns = null;
    }

    @Override
    public RInt getColumns(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.columns;
    }

    @Override
    public void setColumns(RInt columns, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.columns = columns;
    }

    private void copyColumns(ome.model.screen.Plate source, IceMapper mapper) {
        this.columns = source.getColumns() == null ? null : rtypes.rint(source.getColumns());
    }

    private void fillColumns(ome.model.screen.Plate target, IceMapper mapper) {
        try {
            target.setColumns((Integer)mapper.fromRType(this.getColumns()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadStatus() {
        this.status = null;
    }

    @Override
    public RString getStatus(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.status;
    }

    @Override
    public void setStatus(RString status, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.status = status;
    }

    private void copyStatus(ome.model.screen.Plate source, IceMapper mapper) {
        this.status = source.getStatus() == null ? null : rtypes.rstring(source.getStatus());
    }

    private void fillStatus(ome.model.screen.Plate target, IceMapper mapper) {
        try {
            target.setStatus((String)mapper.fromRType(this.getStatus()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadExternalIdentifier() {
        this.externalIdentifier = null;
    }

    @Override
    public RString getExternalIdentifier(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.externalIdentifier;
    }

    @Override
    public void setExternalIdentifier(RString externalIdentifier, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.externalIdentifier = externalIdentifier;
    }

    private void copyExternalIdentifier(ome.model.screen.Plate source, IceMapper mapper) {
        this.externalIdentifier = source.getExternalIdentifier() == null ? null : rtypes.rstring(source.getExternalIdentifier());
    }

    private void fillExternalIdentifier(ome.model.screen.Plate target, IceMapper mapper) {
        try {
            target.setExternalIdentifier((String)mapper.fromRType(this.getExternalIdentifier()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void unloadScreenLinks(Current current) {
        this.screenLinksLoaded = false;
        this.screenLinksSeq = null;
    }

    protected List getScreenLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.screenLinksSeq;
    }

    protected void setScreenLinks(List screenLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.screenLinksSeq = screenLinks == null ? new ArrayList() : new ArrayList(screenLinks);
        this.screenLinksLoaded = screenLinks != null;
    }

    private void copyScreenLinks(ome.model.screen.Plate source, IceMapper mapper) {
        this.setScreenLinks((List)mapper.findCollection((Collection)source.retrieve(SCREENLINKS)), null);
        this.screenLinksCountPerOwner = source.getScreenLinksCountPerOwner();
    }

    private void fillScreenLinks(ome.model.screen.Plate target, IceMapper mapper) {
        if (this.screenLinksLoaded) {
            target.putAt(SCREENLINKS, (Object)mapper.reverse(this.screenLinksSeq, Set.class));
        } else {
            target.putAt(SCREENLINKS, null);
        }
    }

    public boolean isScreenLinksLoaded() {
        return this.screenLinksLoaded;
    }

    @Override
    public int sizeOfScreenLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenLinksLoaded) {
            return -1;
        }
        return this.screenLinksSeq.size();
    }

    public List copyScreenLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenLinksLoaded) {
            this.throwNullCollectionException("screenLinksSeq");
        }
        ArrayList result = new ArrayList(this.screenLinksSeq);
        return result;
    }

    public Iterator iterateScreenLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenLinksLoaded) {
            this.throwNullCollectionException("screenLinksSeq");
        }
        return this.screenLinksSeq.iterator();
    }

    @Override
    public void addScreenPlateLink(ScreenPlateLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenLinksLoaded) {
            this.throwNullCollectionException("screenLinksSeq");
        }
        this.screenLinksSeq.add(target);
        target.setChild(this);
    }

    @Override
    public void addAllScreenPlateLinkSet(List<ScreenPlateLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenLinksLoaded) {
            this.throwNullCollectionException("screenLinksSeq");
        }
        this.screenLinksSeq.addAll(targets);
        for (ScreenPlateLink target : targets) {
            target.setChild(this);
        }
    }

    @Override
    public void removeScreenPlateLink(ScreenPlateLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenLinksLoaded) {
            this.throwNullCollectionException("screenLinksSeq");
        }
        this.screenLinksSeq.remove(target);
        target.setChild(null);
    }

    @Override
    public void removeAllScreenPlateLinkSet(List<ScreenPlateLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenLinksLoaded) {
            this.throwNullCollectionException("screenLinksSeq");
        }
        for (ScreenPlateLink elt : targets) {
            elt.setChild(null);
            this.screenLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearScreenLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenLinksLoaded) {
            this.throwNullCollectionException("screenLinksSeq");
        }
        for (ScreenPlateLink elt : this.screenLinksSeq) {
            elt.setChild(null);
        }
        this.screenLinksSeq.clear();
    }

    @Override
    public void reloadScreenLinks(Plate toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.screenLinksLoaded) {
            throw new ClientError("Cannot reload active collection: screenLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<ScreenPlateLink> copy = toCopy.copyScreenLinks();
        for (ScreenPlateLink elt : copy) {
            elt.setChild(this);
        }
        this.screenLinksSeq = new ArrayList<ScreenPlateLink>(copy);
        toCopy.unloadScreenLinks();
        this.screenLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getScreenLinksCountPerOwner(Current current) {
        return this.screenLinksCountPerOwner;
    }

    @Override
    public ScreenPlateLink linkScreen(Screen addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenLinksLoaded) {
            this.throwNullCollectionException("screenLinksSeq");
        }
        ScreenPlateLinkI link = new ScreenPlateLinkI();
        link.link(addition, this);
        this.addScreenPlateLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addScreenPlateLinkToBoth(ScreenPlateLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenLinksLoaded) {
            this.throwNullCollectionException("screenLinksSeq");
        }
        this.screenLinksSeq.add(link);
        if (bothSides && link.getParent().isLoaded()) {
            link.getParent().addScreenPlateLinkToBoth(link, false);
        }
    }

    @Override
    public List<ScreenPlateLink> findScreenPlateLink(Screen removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenLinksLoaded) {
            this.throwNullCollectionException("screenLinksSeq");
        }
        ArrayList<ScreenPlateLink> result = new ArrayList<ScreenPlateLink>();
        for (ScreenPlateLink link : this.screenLinksSeq) {
            if (link.getParent() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkScreen(Screen removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenLinksLoaded) {
            this.throwNullCollectionException("screenLinksSeq");
        }
        List<ScreenPlateLink> toRemove = this.findScreenPlateLink(removal);
        Iterator<ScreenPlateLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeScreenPlateLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeScreenPlateLinkFromBoth(ScreenPlateLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.screenLinksLoaded) {
            this.throwNullCollectionException("screenLinksSeq");
        }
        this.screenLinksSeq.remove(link);
        if (bothSides && link.getParent().isLoaded()) {
            link.getParent().removeScreenPlateLinkFromBoth(link, false);
        }
    }

    @Override
    public List<Screen> linkedScreenList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.screenLinksLoaded) {
            this.throwNullCollectionException("ScreenLinks");
        }
        ArrayList<Screen> linked = new ArrayList<Screen>();
        for (ScreenPlateLink link : this.screenLinksSeq) {
            linked.add(link.getParent());
        }
        return linked;
    }

    @Override
    public void unloadWells(Current current) {
        this.wellsLoaded = false;
        this.wellsSeq = null;
    }

    protected List getWells(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.wellsSeq;
    }

    protected void setWells(List wells, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.wellsSeq = wells == null ? new ArrayList() : new ArrayList(wells);
        this.wellsLoaded = wells != null;
    }

    private void copyWells(ome.model.screen.Plate source, IceMapper mapper) {
        this.setWells((List)mapper.findCollection((Collection)source.retrieve(WELLS)), null);
    }

    private void fillWells(ome.model.screen.Plate target, IceMapper mapper) {
        if (this.wellsLoaded) {
            target.putAt(WELLS, (Object)mapper.reverse(this.wellsSeq, Set.class));
        } else {
            target.putAt(WELLS, null);
        }
    }

    public boolean isWellsLoaded() {
        return this.wellsLoaded;
    }

    @Override
    public int sizeOfWells(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellsLoaded) {
            return -1;
        }
        return this.wellsSeq.size();
    }

    public List copyWells(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellsLoaded) {
            this.throwNullCollectionException("wellsSeq");
        }
        ArrayList result = new ArrayList(this.wellsSeq);
        return result;
    }

    public Iterator iterateWells() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellsLoaded) {
            this.throwNullCollectionException("wellsSeq");
        }
        return this.wellsSeq.iterator();
    }

    @Override
    public void addWell(Well target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellsLoaded) {
            this.throwNullCollectionException("wellsSeq");
        }
        this.wellsSeq.add(target);
        target.setPlate(this);
    }

    @Override
    public void addAllWellSet(List<Well> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellsLoaded) {
            this.throwNullCollectionException("wellsSeq");
        }
        this.wellsSeq.addAll(targets);
        for (Well target : targets) {
            target.setPlate(this);
        }
    }

    @Override
    public void removeWell(Well target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellsLoaded) {
            this.throwNullCollectionException("wellsSeq");
        }
        this.wellsSeq.remove(target);
        target.setPlate(null);
    }

    @Override
    public void removeAllWellSet(List<Well> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellsLoaded) {
            this.throwNullCollectionException("wellsSeq");
        }
        for (Well elt : targets) {
            elt.setPlate(null);
            this.wellsSeq.remove(elt);
        }
    }

    @Override
    public void clearWells(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.wellsLoaded) {
            this.throwNullCollectionException("wellsSeq");
        }
        for (Well elt : this.wellsSeq) {
            elt.setPlate(null);
        }
        this.wellsSeq.clear();
    }

    @Override
    public void reloadWells(Plate toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.wellsLoaded) {
            throw new ClientError("Cannot reload active collection: wellsSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<Well> copy = toCopy.copyWells();
        for (Well elt : copy) {
            elt.setPlate(this);
        }
        this.wellsSeq = new ArrayList<Well>(copy);
        toCopy.unloadWells();
        this.wellsLoaded = true;
    }

    @Override
    public void unloadPlateAcquisitions(Current current) {
        this.plateAcquisitionsLoaded = false;
        this.plateAcquisitionsSeq = null;
    }

    protected List getPlateAcquisitions(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.plateAcquisitionsSeq;
    }

    protected void setPlateAcquisitions(List plateAcquisitions, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.plateAcquisitionsSeq = plateAcquisitions == null ? new ArrayList() : new ArrayList(plateAcquisitions);
        this.plateAcquisitionsLoaded = plateAcquisitions != null;
    }

    private void copyPlateAcquisitions(ome.model.screen.Plate source, IceMapper mapper) {
        this.setPlateAcquisitions((List)mapper.findCollection((Collection)source.retrieve(PLATEACQUISITIONS)), null);
    }

    private void fillPlateAcquisitions(ome.model.screen.Plate target, IceMapper mapper) {
        if (this.plateAcquisitionsLoaded) {
            target.putAt(PLATEACQUISITIONS, (Object)mapper.reverse(this.plateAcquisitionsSeq, Set.class));
        } else {
            target.putAt(PLATEACQUISITIONS, null);
        }
    }

    public boolean isPlateAcquisitionsLoaded() {
        return this.plateAcquisitionsLoaded;
    }

    @Override
    public int sizeOfPlateAcquisitions(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateAcquisitionsLoaded) {
            return -1;
        }
        return this.plateAcquisitionsSeq.size();
    }

    public List copyPlateAcquisitions(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateAcquisitionsLoaded) {
            this.throwNullCollectionException("plateAcquisitionsSeq");
        }
        ArrayList result = new ArrayList(this.plateAcquisitionsSeq);
        return result;
    }

    public Iterator iteratePlateAcquisitions() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateAcquisitionsLoaded) {
            this.throwNullCollectionException("plateAcquisitionsSeq");
        }
        return this.plateAcquisitionsSeq.iterator();
    }

    @Override
    public void addPlateAcquisition(PlateAcquisition target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateAcquisitionsLoaded) {
            this.throwNullCollectionException("plateAcquisitionsSeq");
        }
        this.plateAcquisitionsSeq.add(target);
        target.setPlate(this);
    }

    @Override
    public void addAllPlateAcquisitionSet(List<PlateAcquisition> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateAcquisitionsLoaded) {
            this.throwNullCollectionException("plateAcquisitionsSeq");
        }
        this.plateAcquisitionsSeq.addAll(targets);
        for (PlateAcquisition target : targets) {
            target.setPlate(this);
        }
    }

    @Override
    public void removePlateAcquisition(PlateAcquisition target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateAcquisitionsLoaded) {
            this.throwNullCollectionException("plateAcquisitionsSeq");
        }
        this.plateAcquisitionsSeq.remove(target);
        target.setPlate(null);
    }

    @Override
    public void removeAllPlateAcquisitionSet(List<PlateAcquisition> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateAcquisitionsLoaded) {
            this.throwNullCollectionException("plateAcquisitionsSeq");
        }
        for (PlateAcquisition elt : targets) {
            elt.setPlate(null);
            this.plateAcquisitionsSeq.remove(elt);
        }
    }

    @Override
    public void clearPlateAcquisitions(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.plateAcquisitionsLoaded) {
            this.throwNullCollectionException("plateAcquisitionsSeq");
        }
        for (PlateAcquisition elt : this.plateAcquisitionsSeq) {
            elt.setPlate(null);
        }
        this.plateAcquisitionsSeq.clear();
    }

    @Override
    public void reloadPlateAcquisitions(Plate toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.plateAcquisitionsLoaded) {
            throw new ClientError("Cannot reload active collection: plateAcquisitionsSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<PlateAcquisition> copy = toCopy.copyPlateAcquisitions();
        for (PlateAcquisition elt : copy) {
            elt.setPlate(this);
        }
        this.plateAcquisitionsSeq = new ArrayList<PlateAcquisition>(copy);
        toCopy.unloadPlateAcquisitions();
        this.plateAcquisitionsLoaded = true;
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.screen.Plate source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.screen.Plate target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, (Object)mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addPlateAnnotationLink(PlateAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllPlateAnnotationLinkSet(List<PlateAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (PlateAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removePlateAnnotationLink(PlateAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllPlateAnnotationLinkSet(List<PlateAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (PlateAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (PlateAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(Plate toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<PlateAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (PlateAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<PlateAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public PlateAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        PlateAnnotationLinkI link = new PlateAnnotationLinkI();
        link.link(this, addition);
        this.addPlateAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addPlateAnnotationLinkToBoth(PlateAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<PlateAnnotationLink> findPlateAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<PlateAnnotationLink> result = new ArrayList<PlateAnnotationLink>();
        for (PlateAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<PlateAnnotationLink> toRemove = this.findPlateAnnotationLink(removal);
        Iterator<PlateAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removePlateAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removePlateAnnotationLinkFromBoth(PlateAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (PlateAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    public void unloadName() {
        this.name = null;
    }

    @Override
    public RString getName(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.name;
    }

    @Override
    public void setName(RString name, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.name = name;
    }

    private void copyName(ome.model.screen.Plate source, IceMapper mapper) {
        this.name = source.getName() == null ? null : rtypes.rstring(source.getName());
    }

    private void fillName(ome.model.screen.Plate target, IceMapper mapper) {
        try {
            target.setName((String)mapper.fromRType(this.getName()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadDescription() {
        this.description = null;
    }

    @Override
    public RString getDescription(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.description;
    }

    @Override
    public void setDescription(RString description, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.description = description;
    }

    private void copyDescription(ome.model.screen.Plate source, IceMapper mapper) {
        this.description = source.getDescription() == null ? null : rtypes.rstring(source.getDescription());
    }

    private void fillDescription(ome.model.screen.Plate target, IceMapper mapper) {
        try {
            target.setDescription((String)mapper.fromRType(this.getDescription()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.screen.Plate) {
            ome.model.screen.Plate source = (ome.model.screen.Plate)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyDefaultSample(source, mapper);
                this.copyColumnNamingConvention(source, mapper);
                this.copyRowNamingConvention(source, mapper);
                this.copyWellOriginX(source, mapper);
                this.copyWellOriginY(source, mapper);
                this.copyRows(source, mapper);
                this.copyColumns(source, mapper);
                this.copyStatus(source, mapper);
                this.copyExternalIdentifier(source, mapper);
                this.copyScreenLinks(source, mapper);
                this.copyWells(source, mapper);
                this.copyPlateAcquisitions(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyName(source, mapper);
                this.copyDescription(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Plate cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.screen.Plate target = new ome.model.screen.Plate();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillDefaultSample(target, mapper);
            this.fillColumnNamingConvention(target, mapper);
            this.fillRowNamingConvention(target, mapper);
            this.fillWellOriginX(target, mapper);
            this.fillWellOriginY(target, mapper);
            this.fillRows(target, mapper);
            this.fillColumns(target, mapper);
            this.fillStatus(target, mapper);
            this.fillExternalIdentifier(target, mapper);
            this.fillScreenLinks(target, mapper);
            this.fillWells(target, mapper);
            this.fillPlateAcquisitions(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillName(target, mapper);
            this.fillDescription(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<PlateI> cast(List list) {
        return list;
    }
}

