/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Channel;
import ome.xml.model.Dataset;
import ome.xml.model.Detector;
import ome.xml.model.Dichroic;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterGroup;
import ome.xml.model.Filter;
import ome.xml.model.Folder;
import ome.xml.model.Image;
import ome.xml.model.Instrument;
import ome.xml.model.LightPath;
import ome.xml.model.LightSource;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Objective;
import ome.xml.model.Plane;
import ome.xml.model.Plate;
import ome.xml.model.PlateAcquisition;
import ome.xml.model.Project;
import ome.xml.model.ROI;
import ome.xml.model.Reagent;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.Screen;
import ome.xml.model.Shape;
import ome.xml.model.Well;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Annotation
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Annotation.class);
    private String namespace;
    private String id;
    private String annotator;
    private String description;
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private List<Image> imageLinks = new ReferenceList<Image>();
    private List<Plane> planeLinks = new ReferenceList<Plane>();
    private List<Channel> channelLinks = new ReferenceList<Channel>();
    private List<Instrument> instrumentLinks = new ReferenceList<Instrument>();
    private List<LightSource> lightSourceLinks = new ReferenceList<LightSource>();
    private List<Project> projectLinks = new ReferenceList<Project>();
    private List<ExperimenterGroup> experimenterGroupLinks = new ReferenceList<ExperimenterGroup>();
    private List<Dataset> datasetLinks = new ReferenceList<Dataset>();
    private List<Experimenter> experimenterLinks = new ReferenceList<Experimenter>();
    private List<Folder> folderLinks = new ReferenceList<Folder>();
    private List<Objective> objectiveLinks = new ReferenceList<Objective>();
    private List<Detector> detectorLinks = new ReferenceList<Detector>();
    private List<Filter> filterLinks = new ReferenceList<Filter>();
    private List<Dichroic> dichroicLinks = new ReferenceList<Dichroic>();
    private List<LightPath> lightPathLinks = new ReferenceList<LightPath>();
    private List<ROI> roiLinks = new ReferenceList<ROI>();
    private List<Shape> shapeLinks = new ReferenceList<Shape>();
    private List<Plate> plateLinks = new ReferenceList<Plate>();
    private List<Reagent> reagentLinks = new ReferenceList<Reagent>();
    private List<Screen> screenLinks = new ReferenceList<Screen>();
    private List<PlateAcquisition> plateAcquisitionLinks = new ReferenceList<PlateAcquisition>();
    private List<Well> wellLinks = new ReferenceList<Well>();

    public Annotation() {
    }

    public Annotation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Annotation(Annotation orig) {
        this.namespace = orig.namespace;
        this.id = orig.id;
        this.annotator = orig.annotator;
        this.description = orig.description;
        this.annotationLinks = orig.annotationLinks;
        this.imageLinks = orig.imageLinks;
        this.planeLinks = orig.planeLinks;
        this.channelLinks = orig.channelLinks;
        this.instrumentLinks = orig.instrumentLinks;
        this.lightSourceLinks = orig.lightSourceLinks;
        this.projectLinks = orig.projectLinks;
        this.experimenterGroupLinks = orig.experimenterGroupLinks;
        this.datasetLinks = orig.datasetLinks;
        this.experimenterLinks = orig.experimenterLinks;
        this.folderLinks = orig.folderLinks;
        this.objectiveLinks = orig.objectiveLinks;
        this.detectorLinks = orig.detectorLinks;
        this.filterLinks = orig.filterLinks;
        this.dichroicLinks = orig.dichroicLinks;
        this.lightPathLinks = orig.lightPathLinks;
        this.roiLinks = orig.roiLinks;
        this.shapeLinks = orig.shapeLinks;
        this.plateLinks = orig.plateLinks;
        this.reagentLinks = orig.reagentLinks;
        this.screenLinks = orig.screenLinks;
        this.plateAcquisitionLinks = orig.plateAcquisitionLinks;
        this.wellLinks = orig.wellLinks;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (element.hasAttribute("Namespace")) {
            this.setNamespace(String.valueOf(element.getAttribute("Namespace")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Annotation missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Annotator")) {
            this.setAnnotator(String.valueOf(element.getAttribute("Annotator")));
        }
        if ((Description_nodeList = Annotation.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> AnnotationRef_nodeList = Annotation.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            this.annotationLinks.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getAnnotator() {
        return this.annotator;
    }

    public void setAnnotator(String annotator) {
        this.annotator = annotator;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        return this.annotationLinks.remove(o);
    }

    public int sizeOfLinkedImageList() {
        return this.imageLinks.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.imageLinks);
    }

    public Image getLinkedImage(int index) {
        return this.imageLinks.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.imageLinks.set(index, o);
    }

    public boolean linkImage(Image o) {
        return this.imageLinks.add(o);
    }

    public boolean unlinkImage(Image o) {
        return this.imageLinks.remove(o);
    }

    public int sizeOfLinkedPlaneList() {
        return this.planeLinks.size();
    }

    public List<Plane> copyLinkedPlaneList() {
        return new ArrayList<Plane>(this.planeLinks);
    }

    public Plane getLinkedPlane(int index) {
        return this.planeLinks.get(index);
    }

    public Plane setLinkedPlane(int index, Plane o) {
        return this.planeLinks.set(index, o);
    }

    public boolean linkPlane(Plane o) {
        return this.planeLinks.add(o);
    }

    public boolean unlinkPlane(Plane o) {
        return this.planeLinks.remove(o);
    }

    public int sizeOfLinkedChannelList() {
        return this.channelLinks.size();
    }

    public List<Channel> copyLinkedChannelList() {
        return new ArrayList<Channel>(this.channelLinks);
    }

    public Channel getLinkedChannel(int index) {
        return this.channelLinks.get(index);
    }

    public Channel setLinkedChannel(int index, Channel o) {
        return this.channelLinks.set(index, o);
    }

    public boolean linkChannel(Channel o) {
        return this.channelLinks.add(o);
    }

    public boolean unlinkChannel(Channel o) {
        return this.channelLinks.remove(o);
    }

    public int sizeOfLinkedInstrumentList() {
        return this.instrumentLinks.size();
    }

    public List<Instrument> copyLinkedInstrumentList() {
        return new ArrayList<Instrument>(this.instrumentLinks);
    }

    public Instrument getLinkedInstrument(int index) {
        return this.instrumentLinks.get(index);
    }

    public Instrument setLinkedInstrument(int index, Instrument o) {
        return this.instrumentLinks.set(index, o);
    }

    public boolean linkInstrument(Instrument o) {
        return this.instrumentLinks.add(o);
    }

    public boolean unlinkInstrument(Instrument o) {
        return this.instrumentLinks.remove(o);
    }

    public int sizeOfLinkedLightSourceList() {
        return this.lightSourceLinks.size();
    }

    public List<LightSource> copyLinkedLightSourceList() {
        return new ArrayList<LightSource>(this.lightSourceLinks);
    }

    public LightSource getLinkedLightSource(int index) {
        return this.lightSourceLinks.get(index);
    }

    public LightSource setLinkedLightSource(int index, LightSource o) {
        return this.lightSourceLinks.set(index, o);
    }

    public boolean linkLightSource(LightSource o) {
        return this.lightSourceLinks.add(o);
    }

    public boolean unlinkLightSource(LightSource o) {
        return this.lightSourceLinks.remove(o);
    }

    public int sizeOfLinkedProjectList() {
        return this.projectLinks.size();
    }

    public List<Project> copyLinkedProjectList() {
        return new ArrayList<Project>(this.projectLinks);
    }

    public Project getLinkedProject(int index) {
        return this.projectLinks.get(index);
    }

    public Project setLinkedProject(int index, Project o) {
        return this.projectLinks.set(index, o);
    }

    public boolean linkProject(Project o) {
        return this.projectLinks.add(o);
    }

    public boolean unlinkProject(Project o) {
        return this.projectLinks.remove(o);
    }

    public int sizeOfLinkedExperimenterGroupList() {
        return this.experimenterGroupLinks.size();
    }

    public List<ExperimenterGroup> copyLinkedExperimenterGroupList() {
        return new ArrayList<ExperimenterGroup>(this.experimenterGroupLinks);
    }

    public ExperimenterGroup getLinkedExperimenterGroup(int index) {
        return this.experimenterGroupLinks.get(index);
    }

    public ExperimenterGroup setLinkedExperimenterGroup(int index, ExperimenterGroup o) {
        return this.experimenterGroupLinks.set(index, o);
    }

    public boolean linkExperimenterGroup(ExperimenterGroup o) {
        return this.experimenterGroupLinks.add(o);
    }

    public boolean unlinkExperimenterGroup(ExperimenterGroup o) {
        return this.experimenterGroupLinks.remove(o);
    }

    public int sizeOfLinkedDatasetList() {
        return this.datasetLinks.size();
    }

    public List<Dataset> copyLinkedDatasetList() {
        return new ArrayList<Dataset>(this.datasetLinks);
    }

    public Dataset getLinkedDataset(int index) {
        return this.datasetLinks.get(index);
    }

    public Dataset setLinkedDataset(int index, Dataset o) {
        return this.datasetLinks.set(index, o);
    }

    public boolean linkDataset(Dataset o) {
        return this.datasetLinks.add(o);
    }

    public boolean unlinkDataset(Dataset o) {
        return this.datasetLinks.remove(o);
    }

    public int sizeOfLinkedExperimenterList() {
        return this.experimenterLinks.size();
    }

    public List<Experimenter> copyLinkedExperimenterList() {
        return new ArrayList<Experimenter>(this.experimenterLinks);
    }

    public Experimenter getLinkedExperimenter(int index) {
        return this.experimenterLinks.get(index);
    }

    public Experimenter setLinkedExperimenter(int index, Experimenter o) {
        return this.experimenterLinks.set(index, o);
    }

    public boolean linkExperimenter(Experimenter o) {
        return this.experimenterLinks.add(o);
    }

    public boolean unlinkExperimenter(Experimenter o) {
        return this.experimenterLinks.remove(o);
    }

    public int sizeOfLinkedFolderList() {
        return this.folderLinks.size();
    }

    public List<Folder> copyLinkedFolderList() {
        return new ArrayList<Folder>(this.folderLinks);
    }

    public Folder getLinkedFolder(int index) {
        return this.folderLinks.get(index);
    }

    public Folder setLinkedFolder(int index, Folder o) {
        return this.folderLinks.set(index, o);
    }

    public boolean linkFolder(Folder o) {
        return this.folderLinks.add(o);
    }

    public boolean unlinkFolder(Folder o) {
        return this.folderLinks.remove(o);
    }

    public int sizeOfLinkedObjectiveList() {
        return this.objectiveLinks.size();
    }

    public List<Objective> copyLinkedObjectiveList() {
        return new ArrayList<Objective>(this.objectiveLinks);
    }

    public Objective getLinkedObjective(int index) {
        return this.objectiveLinks.get(index);
    }

    public Objective setLinkedObjective(int index, Objective o) {
        return this.objectiveLinks.set(index, o);
    }

    public boolean linkObjective(Objective o) {
        return this.objectiveLinks.add(o);
    }

    public boolean unlinkObjective(Objective o) {
        return this.objectiveLinks.remove(o);
    }

    public int sizeOfLinkedDetectorList() {
        return this.detectorLinks.size();
    }

    public List<Detector> copyLinkedDetectorList() {
        return new ArrayList<Detector>(this.detectorLinks);
    }

    public Detector getLinkedDetector(int index) {
        return this.detectorLinks.get(index);
    }

    public Detector setLinkedDetector(int index, Detector o) {
        return this.detectorLinks.set(index, o);
    }

    public boolean linkDetector(Detector o) {
        return this.detectorLinks.add(o);
    }

    public boolean unlinkDetector(Detector o) {
        return this.detectorLinks.remove(o);
    }

    public int sizeOfLinkedFilterList() {
        return this.filterLinks.size();
    }

    public List<Filter> copyLinkedFilterList() {
        return new ArrayList<Filter>(this.filterLinks);
    }

    public Filter getLinkedFilter(int index) {
        return this.filterLinks.get(index);
    }

    public Filter setLinkedFilter(int index, Filter o) {
        return this.filterLinks.set(index, o);
    }

    public boolean linkFilter(Filter o) {
        return this.filterLinks.add(o);
    }

    public boolean unlinkFilter(Filter o) {
        return this.filterLinks.remove(o);
    }

    public int sizeOfLinkedDichroicList() {
        return this.dichroicLinks.size();
    }

    public List<Dichroic> copyLinkedDichroicList() {
        return new ArrayList<Dichroic>(this.dichroicLinks);
    }

    public Dichroic getLinkedDichroic(int index) {
        return this.dichroicLinks.get(index);
    }

    public Dichroic setLinkedDichroic(int index, Dichroic o) {
        return this.dichroicLinks.set(index, o);
    }

    public boolean linkDichroic(Dichroic o) {
        return this.dichroicLinks.add(o);
    }

    public boolean unlinkDichroic(Dichroic o) {
        return this.dichroicLinks.remove(o);
    }

    public int sizeOfLinkedLightPathList() {
        return this.lightPathLinks.size();
    }

    public List<LightPath> copyLinkedLightPathList() {
        return new ArrayList<LightPath>(this.lightPathLinks);
    }

    public LightPath getLinkedLightPath(int index) {
        return this.lightPathLinks.get(index);
    }

    public LightPath setLinkedLightPath(int index, LightPath o) {
        return this.lightPathLinks.set(index, o);
    }

    public boolean linkLightPath(LightPath o) {
        return this.lightPathLinks.add(o);
    }

    public boolean unlinkLightPath(LightPath o) {
        return this.lightPathLinks.remove(o);
    }

    public int sizeOfLinkedROIList() {
        return this.roiLinks.size();
    }

    public List<ROI> copyLinkedROIList() {
        return new ArrayList<ROI>(this.roiLinks);
    }

    public ROI getLinkedROI(int index) {
        return this.roiLinks.get(index);
    }

    public ROI setLinkedROI(int index, ROI o) {
        return this.roiLinks.set(index, o);
    }

    public boolean linkROI(ROI o) {
        return this.roiLinks.add(o);
    }

    public boolean unlinkROI(ROI o) {
        return this.roiLinks.remove(o);
    }

    public int sizeOfLinkedShapeList() {
        return this.shapeLinks.size();
    }

    public List<Shape> copyLinkedShapeList() {
        return new ArrayList<Shape>(this.shapeLinks);
    }

    public Shape getLinkedShape(int index) {
        return this.shapeLinks.get(index);
    }

    public Shape setLinkedShape(int index, Shape o) {
        return this.shapeLinks.set(index, o);
    }

    public boolean linkShape(Shape o) {
        return this.shapeLinks.add(o);
    }

    public boolean unlinkShape(Shape o) {
        return this.shapeLinks.remove(o);
    }

    public int sizeOfLinkedPlateList() {
        return this.plateLinks.size();
    }

    public List<Plate> copyLinkedPlateList() {
        return new ArrayList<Plate>(this.plateLinks);
    }

    public Plate getLinkedPlate(int index) {
        return this.plateLinks.get(index);
    }

    public Plate setLinkedPlate(int index, Plate o) {
        return this.plateLinks.set(index, o);
    }

    public boolean linkPlate(Plate o) {
        return this.plateLinks.add(o);
    }

    public boolean unlinkPlate(Plate o) {
        return this.plateLinks.remove(o);
    }

    public int sizeOfLinkedReagentList() {
        return this.reagentLinks.size();
    }

    public List<Reagent> copyLinkedReagentList() {
        return new ArrayList<Reagent>(this.reagentLinks);
    }

    public Reagent getLinkedReagent(int index) {
        return this.reagentLinks.get(index);
    }

    public Reagent setLinkedReagent(int index, Reagent o) {
        return this.reagentLinks.set(index, o);
    }

    public boolean linkReagent(Reagent o) {
        return this.reagentLinks.add(o);
    }

    public boolean unlinkReagent(Reagent o) {
        return this.reagentLinks.remove(o);
    }

    public int sizeOfLinkedScreenList() {
        return this.screenLinks.size();
    }

    public List<Screen> copyLinkedScreenList() {
        return new ArrayList<Screen>(this.screenLinks);
    }

    public Screen getLinkedScreen(int index) {
        return this.screenLinks.get(index);
    }

    public Screen setLinkedScreen(int index, Screen o) {
        return this.screenLinks.set(index, o);
    }

    public boolean linkScreen(Screen o) {
        return this.screenLinks.add(o);
    }

    public boolean unlinkScreen(Screen o) {
        return this.screenLinks.remove(o);
    }

    public int sizeOfLinkedPlateAcquisitionList() {
        return this.plateAcquisitionLinks.size();
    }

    public List<PlateAcquisition> copyLinkedPlateAcquisitionList() {
        return new ArrayList<PlateAcquisition>(this.plateAcquisitionLinks);
    }

    public PlateAcquisition getLinkedPlateAcquisition(int index) {
        return this.plateAcquisitionLinks.get(index);
    }

    public PlateAcquisition setLinkedPlateAcquisition(int index, PlateAcquisition o) {
        return this.plateAcquisitionLinks.set(index, o);
    }

    public boolean linkPlateAcquisition(PlateAcquisition o) {
        return this.plateAcquisitionLinks.add(o);
    }

    public boolean unlinkPlateAcquisition(PlateAcquisition o) {
        return this.plateAcquisitionLinks.remove(o);
    }

    public int sizeOfLinkedWellList() {
        return this.wellLinks.size();
    }

    public List<Well> copyLinkedWellList() {
        return new ArrayList<Well>(this.wellLinks);
    }

    public Well getLinkedWell(int index) {
        return this.wellLinks.get(index);
    }

    public Well setLinkedWell(int index, Well o) {
        return this.wellLinks.set(index, o);
    }

    public boolean linkWell(Well o) {
        return this.wellLinks.add(o);
    }

    public boolean unlinkWell(Well o) {
        return this.wellLinks.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Annotation_element) {
        if (Annotation_element == null) {
            Annotation_element = document.createElementNS(NAMESPACE, "Annotation");
        }
        super.asXMLElement(document, Annotation_element);
        if (this.namespace != null) {
            Annotation_element.setAttribute("Namespace", this.namespace.toString());
        }
        if (this.id != null) {
            Annotation_element.setAttribute("ID", this.id.toString());
        }
        if (this.annotator != null) {
            Annotation_element.setAttribute("Annotator", this.annotator.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            Annotation_element.appendChild(description_element);
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Element child = document.createElementNS(NAMESPACE, "AnnotationRef");
                o.asXMLElement(document, child);
                Annotation_element.appendChild(child);
            }
        }
        if (this.imageLinks != null) {
            // empty if block
        }
        if (this.planeLinks != null) {
            // empty if block
        }
        if (this.channelLinks != null) {
            // empty if block
        }
        if (this.instrumentLinks != null) {
            // empty if block
        }
        if (this.lightSourceLinks != null) {
            // empty if block
        }
        if (this.projectLinks != null) {
            // empty if block
        }
        if (this.experimenterGroupLinks != null) {
            // empty if block
        }
        if (this.datasetLinks != null) {
            // empty if block
        }
        if (this.experimenterLinks != null) {
            // empty if block
        }
        if (this.folderLinks != null) {
            // empty if block
        }
        if (this.objectiveLinks != null) {
            // empty if block
        }
        if (this.detectorLinks != null) {
            // empty if block
        }
        if (this.filterLinks != null) {
            // empty if block
        }
        if (this.dichroicLinks != null) {
            // empty if block
        }
        if (this.lightPathLinks != null) {
            // empty if block
        }
        if (this.roiLinks != null) {
            // empty if block
        }
        if (this.shapeLinks != null) {
            // empty if block
        }
        if (this.plateLinks != null) {
            // empty if block
        }
        if (this.reagentLinks != null) {
            // empty if block
        }
        if (this.screenLinks != null) {
            // empty if block
        }
        if (this.plateAcquisitionLinks != null) {
            // empty if block
        }
        if (this.wellLinks != null) {
            // empty if block
        }
        return Annotation_element;
    }
}

