/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.units.quantity.Length;
import ome.xml.model.LightSource;
import ome.xml.model.MicrobeamManipulation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Settings;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LightSourceSettings
extends Settings {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(LightSourceSettings.class);
    private Length wavelength;
    private PercentFraction attenuation;
    private String id;
    private LightSource lightSource;
    private MicrobeamManipulation microbeamManipulation;

    public LightSourceSettings() {
    }

    public LightSourceSettings(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public LightSourceSettings(LightSourceSettings orig) {
        super(orig);
        this.wavelength = orig.wavelength;
        this.attenuation = orig.attenuation;
        this.id = orig.id;
        this.lightSource = orig.lightSource;
        this.microbeamManipulation = orig.microbeamManipulation;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (element.hasAttribute("Wavelength")) {
            String unitSymbol = element.getAttribute("WavelengthUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = LightSourceSettings.getWavelengthUnitXsdDefault();
            }
            UnitsLength modelUnit = UnitsLength.fromString(unitSymbol);
            PositiveFloat baseValue = PositiveFloat.valueOf(element.getAttribute("Wavelength"));
            if (baseValue != null) {
                this.setWavelength(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("Attenuation")) {
            this.setAttenuation(PercentFraction.valueOf(element.getAttribute("Attenuation")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("LightSourceSettings missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public Length getWavelength() {
        return this.wavelength;
    }

    public void setWavelength(Length wavelength) {
        this.wavelength = wavelength;
    }

    public PercentFraction getAttenuation() {
        return this.attenuation;
    }

    public void setAttenuation(PercentFraction attenuation) {
        this.attenuation = attenuation;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    public static String getWavelengthUnitXsdDefault() {
        return "nm";
    }

    public LightSource getLightSource() {
        return this.lightSource;
    }

    public void setLightSource(LightSource lightSource) {
        this.lightSource = lightSource;
    }

    public MicrobeamManipulation getMicrobeamManipulation() {
        return this.microbeamManipulation;
    }

    public void setMicrobeamManipulation(MicrobeamManipulation microbeamManipulation_BackReference) {
        this.microbeamManipulation = microbeamManipulation_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element LightSourceSettings_element) {
        if (LightSourceSettings_element == null) {
            LightSourceSettings_element = document.createElementNS(NAMESPACE, "LightSourceSettings");
        }
        super.asXMLElement(document, LightSourceSettings_element);
        if (this.wavelength != null) {
            if (this.wavelength.value() != null) {
                LightSourceSettings_element.setAttribute("Wavelength", this.wavelength.value().toString());
            }
            if (this.wavelength.unit() != null) {
                try {
                    UnitsLength enumUnits = UnitsLength.fromString(this.wavelength.unit().getSymbol());
                    LightSourceSettings_element.setAttribute("WavelengthUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for LightSourceSettings:WavelengthUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.attenuation != null) {
            LightSourceSettings_element.setAttribute("Attenuation", this.attenuation.toString());
        }
        if (this.id != null) {
            LightSourceSettings_element.setAttribute("ID", this.id.toString());
        }
        if (this.lightSource != null) {
            // empty if block
        }
        if (this.microbeamManipulation != null) {
            // empty if block
        }
        return LightSourceSettings_element;
    }
}

