/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AbstractProjectAction;

public class ToggleProjectPropertyAction
extends AbstractProjectAction {
    private String propertyName;
    private Class[] parameterClass;
    private Object selectedPropertyValue;
    private Object deselectedPropertyValue;
    private String setterName;
    private String getterName;
    private PropertyChangeListener projectListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == ToggleProjectPropertyAction.this.propertyName) {
                ToggleProjectPropertyAction.this.updateSelectedState();
            }
        }
    };

    public ToggleProjectPropertyAction(Application app, String propertyName) {
        this(app, propertyName, Boolean.TYPE, true, false);
    }

    public ToggleProjectPropertyAction(Application app, String propertyName, Class propertyClass, Object selectedPropertyValue, Object deselectedPropertyValue) {
        super(app);
        this.propertyName = propertyName;
        this.parameterClass = new Class[]{propertyClass};
        this.selectedPropertyValue = selectedPropertyValue;
        this.deselectedPropertyValue = deselectedPropertyValue;
        this.setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        this.getterName = (propertyClass == Boolean.TYPE || propertyClass == Boolean.class ? "is" : "get") + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        this.updateSelectedState();
    }

    public void actionPerformed(ActionEvent evt) {
        Project p = this.getCurrentProject();
        Object value = this.getCurrentValue();
        Object newValue = value == this.selectedPropertyValue || value != null && this.selectedPropertyValue != null && value.equals(this.selectedPropertyValue) ? this.deselectedPropertyValue : this.selectedPropertyValue;
        try {
            p.getClass().getMethod(this.setterName, this.parameterClass).invoke((Object)p, newValue);
        }
        catch (Throwable e) {
            InternalError error = new InternalError("No " + this.setterName + " method on " + p);
            error.initCause(e);
            throw error;
        }
    }

    private Object getCurrentValue() {
        Project p = this.getCurrentProject();
        if (p != null) {
            try {
                return p.getClass().getMethod(this.getterName, null).invoke((Object)p, new Object[0]);
            }
            catch (Throwable e) {
                InternalError error = new InternalError("No " + this.getterName + " method on " + p);
                error.initCause(e);
                throw error;
            }
        }
        return null;
    }

    protected void installProjectListeners(Project p) {
        super.installProjectListeners(p);
        p.addPropertyChangeListener(this.projectListener);
        this.updateSelectedState();
    }

    protected void uninstallProjectListeners(Project p) {
        super.uninstallProjectListeners(p);
        p.removePropertyChangeListener(this.projectListener);
    }

    private void updateSelectedState() {
        boolean isSelected = false;
        Project p = this.getCurrentProject();
        if (p != null) {
            try {
                Object value = p.getClass().getMethod(this.getterName, null).invoke((Object)p, new Object[0]);
                isSelected = value == this.selectedPropertyValue || value != null && this.selectedPropertyValue != null && value.equals(this.selectedPropertyValue);
            }
            catch (Throwable e) {
                InternalError error = new InternalError("No " + this.getterName + " method on " + p);
                error.initCause(e);
                throw error;
            }
        }
        this.putValue("selected", isSelected);
    }
}

