/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jhotdraw.application.DocumentOrientedApplication;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.application.action.AbstractApplicationAction;

public abstract class AbstractDocumentViewAction
extends AbstractApplicationAction {
    private String propertyName;
    private PropertyChangeListener applicationListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "currentView") {
                AbstractDocumentViewAction.this.updateProject((DocumentView)evt.getOldValue(), (DocumentView)evt.getNewValue());
            }
        }
    };
    private PropertyChangeListener viewListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "enabled") {
                AbstractDocumentViewAction.this.updateEnabled((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            } else if (name == AbstractDocumentViewAction.this.propertyName) {
                AbstractDocumentViewAction.this.updateProperty();
            }
        }
    };

    public AbstractDocumentViewAction() {
        this.enabled = true;
        DocumentOrientedApplication application = this.getApplication();
        if (application != null) {
            application.addPropertyChangeListener(this.applicationListener);
            this.updateProject(null, application.getCurrentView());
        }
    }

    protected void updateProject(DocumentView oldValue, DocumentView newValue) {
        if (oldValue != null) {
            this.uninstallProjectListeners(oldValue);
        }
        if (newValue != null) {
            this.installProjectListeners(newValue);
        }
        this.firePropertyChange("documentView", oldValue, newValue);
        this.updateEnabled(oldValue != null && oldValue.isEnabled(), newValue != null && newValue.isEnabled());
        this.updateProperty();
    }

    protected void setPropertyName(String name) {
        this.propertyName = name;
        if (name != null) {
            this.updateProperty();
        }
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    protected void updateProperty() {
    }

    protected void installProjectListeners(DocumentView p) {
        p.addPropertyChangeListener(this.viewListener);
    }

    protected void uninstallProjectListeners(DocumentView p) {
        p.removePropertyChangeListener(this.viewListener);
    }

    protected void updateEnabled(boolean oldValue, boolean newValue) {
        this.firePropertyChange("enabled", oldValue, newValue);
    }

    public DocumentView getCurrentView() {
        return this.getApplication().getCurrentView();
    }

    public boolean isEnabled() {
        return this.getCurrentView() != null && this.getCurrentView().isEnabled() && this.enabled;
    }

    public void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        this.enabled = newValue;
        boolean projIsEnabled = this.getCurrentView() != null && this.getCurrentView().isEnabled();
        this.firePropertyChange("enabled", oldValue && projIsEnabled, newValue && projIsEnabled);
    }
}

