/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.Timer;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.SelectionTool;
import org.jhotdraw.draw.Tool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegationSelectionTool
extends SelectionTool {
    private static final boolean DEBUG = false;
    private Collection<Action> drawingActions;
    private Collection<Action> selectionActions;
    private Timer popupTimer;
    private JPopupMenu popupMenu;
    private MouseEvent lastClickEvent;

    public DelegationSelectionTool() {
        this(new LinkedList<Action>(), new LinkedList<Action>());
    }

    public DelegationSelectionTool(Collection<Action> drawingActions, Collection<Action> selectionActions) {
        this.drawingActions = drawingActions;
        this.selectionActions = selectionActions;
    }

    public void setDrawingActions(Collection<Action> drawingActions) {
        this.drawingActions = drawingActions;
    }

    public void setFigureActions(Collection<Action> selectionActions) {
        this.selectionActions = selectionActions;
    }

    @Override
    public void mousePressed(final MouseEvent evt) {
        if (this.popupTimer != null) {
            this.popupTimer.stop();
            this.popupTimer = null;
        }
        if (evt.isPopupTrigger()) {
            this.getView().requestFocus();
            this.handlePopupMenu(evt);
        } else {
            super.mousePressed(evt);
            this.popupTimer = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent aevt) {
                    DelegationSelectionTool.this.handlePopupMenu(evt);
                    DelegationSelectionTool.this.popupTimer = null;
                }
            });
            this.popupTimer.setRepeats(false);
            this.popupTimer.start();
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.popupTimer != null) {
            this.popupTimer.stop();
            this.popupTimer = null;
        }
        super.mouseReleased(evt);
        if (evt.isPopupTrigger()) {
            this.handlePopupMenu(evt);
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (this.popupTimer != null) {
            this.popupTimer.stop();
            this.popupTimer = null;
        }
        if (this.popupMenu == null || !this.popupMenu.isVisible()) {
            super.mouseDragged(evt);
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        super.mouseClicked(evt);
        if (!evt.isConsumed()) {
            if (evt.getClickCount() == 2) {
                this.handleDoubleClick(evt);
            } else if (evt.getClickCount() == 1 && evt.getModifiersEx() == 0 && this.lastClickEvent != null && this.lastClickEvent.getClickCount() == 1 && this.lastClickEvent.getModifiersEx() == 0 && this.lastClickEvent.getX() == evt.getX() && this.lastClickEvent.getY() == evt.getY()) {
                this.handleMultiClick(evt);
            }
        }
        this.lastClickEvent = evt;
    }

    protected void handlePopupMenu(MouseEvent evt) {
        Point p = new Point(evt.getX(), evt.getY());
        Figure figure = this.getView().findFigure(p);
        if (figure != null || this.drawingActions.size() > 0) {
            this.showPopupMenu(figure, p, evt.getComponent());
        } else {
            this.popupMenu = null;
        }
    }

    protected void showPopupMenu(Figure figure, Point p, Component c) {
        JPopupMenu menu;
        this.popupMenu = menu = new JPopupMenu();
        JMenu submenu = null;
        String submenuName = null;
        LinkedList<Action> popupActions = new LinkedList<Action>();
        if (figure != null) {
            LinkedList<Action> figureActions = new LinkedList<Action>(figure.getActions(this.viewToDrawing(p)));
            if (popupActions.size() != 0 && figureActions.size() != 0) {
                popupActions.add(null);
            }
            popupActions.addAll(figureActions);
            if (popupActions.size() != 0 && this.selectionActions.size() != 0) {
                popupActions.add(null);
            }
            popupActions.addAll(this.selectionActions);
        }
        if (popupActions.size() != 0 && this.drawingActions.size() != 0) {
            popupActions.add(null);
        }
        popupActions.addAll(this.drawingActions);
        HashMap<Object, ButtonGroup> buttonGroups = new HashMap<Object, ButtonGroup>();
        for (Action a : popupActions) {
            JMenuItem button;
            if (a != null && a.getValue("submenu") != null) {
                if (submenuName == null || !submenuName.equals(a.getValue("submenu"))) {
                    submenuName = (String)a.getValue("submenu");
                    submenu = new JMenu(submenuName);
                    menu.add(submenu);
                }
            } else {
                submenuName = null;
                submenu = null;
            }
            if (a == null) {
                if (submenu != null) {
                    submenu.addSeparator();
                    continue;
                }
                menu.addSeparator();
                continue;
            }
            if (a.getValue("buttonGroup") != null) {
                ButtonGroup bg = (ButtonGroup)buttonGroups.get(a.getValue("buttonGroup"));
                if (bg == null) {
                    bg = new ButtonGroup();
                    buttonGroups.put(a.getValue("buttonGroup"), bg);
                }
                button = new JRadioButtonMenuItem(a);
                bg.add(button);
                button.setSelected(a.getValue("selected") == Boolean.TRUE);
            } else if (a.getValue("selected") != null) {
                button = new JCheckBoxMenuItem(a);
                button.setSelected(a.getValue("selected") == Boolean.TRUE);
            } else {
                button = new JMenuItem(a);
            }
            if (submenu != null) {
                submenu.add((Component)button);
                continue;
            }
            menu.add((Component)button);
        }
        menu.show(c, p.x, p.y);
    }

    protected void handleDoubleClick(MouseEvent evt) {
        Point pos;
        DrawingView v = this.getView();
        Handle handle = v.findHandle(pos = new Point(evt.getX(), evt.getY()));
        if (handle != null) {
            handle.trackDoubleClick(pos, evt.getModifiersEx());
        } else {
            Point2D.Double p = this.viewToDrawing(pos);
            Figure outerFigure = this.getView().findFigure(pos);
            Figure figure = outerFigure;
            if (figure != null) {
                Tool figureTool = figure.getTool(p);
                if (figureTool == null && (figure = this.getDrawing().findFigureInside(p)) != null) {
                    figureTool = figure.getTool(p);
                }
                if (figureTool != null) {
                    this.setTracker(figureTool);
                    figureTool.mousePressed(evt);
                } else if (outerFigure.handleMouseClick(p, evt, this.getView())) {
                    v.clearSelection();
                    v.addToSelection(outerFigure);
                } else {
                    v.clearSelection();
                    v.addToSelection(outerFigure);
                    v.setHandleDetailLevel(v.getHandleDetailLevel() + 1);
                }
            }
        }
        evt.consume();
    }

    protected void handleMultiClick(MouseEvent evt) {
        Point pos;
        DrawingView v = this.getView();
        Handle handle = v.findHandle(pos = new Point(evt.getX(), evt.getY()));
        if (handle == null) {
            v.setHandleDetailLevel(v.getHandleDetailLevel() + 1);
        }
    }
}

