/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.TextHolderFigure;

public class FloatingTextField {
    private JTextField editWidget = new JTextField(20);
    private DrawingView view;

    public void createOverlay(DrawingView view) {
        this.createOverlay(view, null);
    }

    public void requestFocus() {
        this.editWidget.requestFocus();
    }

    public void createOverlay(DrawingView view, TextHolderFigure figure) {
        view.getComponent().add((Component)this.editWidget, 0);
        Font f = figure.getFont();
        f = f.deriveFont(f.getStyle(), (float)((double)figure.getFontSize() * view.getScaleFactor()));
        this.editWidget.setFont(f);
        this.editWidget.setForeground(figure.getTextColor());
        this.editWidget.setBackground(figure.getFillColor());
        this.view = view;
    }

    public Insets getInsets() {
        return this.editWidget.getInsets();
    }

    public void addActionListener(ActionListener listener) {
        this.editWidget.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.editWidget.removeActionListener(listener);
    }

    public void setBounds(Rectangle r, String text) {
        this.editWidget.setText(text);
        this.editWidget.setBounds(r.x, r.y, r.width, r.height);
        this.editWidget.setVisible(true);
        this.editWidget.selectAll();
        this.editWidget.requestFocus();
    }

    public String getText() {
        return this.editWidget.getText();
    }

    public Dimension getPreferredSize(int cols) {
        this.editWidget.setColumns(cols);
        return this.editWidget.getPreferredSize();
    }

    public void endOverlay() {
        this.view.getComponent().requestFocus();
        if (this.editWidget != null) {
            this.editWidget.setVisible(false);
            this.view.getComponent().remove(this.editWidget);
            Rectangle bounds = this.editWidget.getBounds();
            this.view.getComponent().repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }
}

