/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.gui.AttributeField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeFieldEventHandler
implements PropertyChangeListener,
FigureSelectionListener,
FigureListener {
    private AttributeField field;
    private DrawingEditor editor;
    private DrawingView view;

    public AttributeFieldEventHandler(AttributeField field) {
        this.field = field;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Object src = evt.getSource();
        if (src == this.editor) {
            if (name == "activeView" && this.getView() != null) {
                DrawingView view;
                if (evt.getOldValue() != null) {
                    view = (DrawingView)evt.getOldValue();
                    for (Figure f : view.getSelectedFigures()) {
                        f.removeFigureListener(this);
                    }
                    view.removeFigureSelectionListener(this);
                    view.removePropertyChangeListener(this);
                }
                if (evt.getNewValue() != null) {
                    view = (DrawingView)evt.getNewValue();
                    for (Figure f : view.getSelectedFigures()) {
                        f.addFigureListener(this);
                    }
                    view.addFigureSelectionListener(this);
                    view.addPropertyChangeListener(this);
                }
                this.updateFieldEnabledState();
                this.updateField();
            }
        } else if (src == this.getCurrentView() && name == "enabled") {
            this.updateFieldEnabledState();
        }
    }

    @Override
    public void selectionChanged(FigureSelectionEvent evt) {
        for (Figure f : evt.getOldSelection()) {
            f.removeFigureListener(this);
        }
        for (Figure f : evt.getNewSelection()) {
            f.addFigureListener(this);
        }
        this.updateFieldEnabledState();
        this.updateField();
    }

    protected void updateFieldEnabledState() {
        if (this.getCurrentView() != null) {
            this.field.getComponent().setEnabled(this.getCurrentView().isEnabled() && this.getCurrentView().getSelectionCount() > 0);
        } else {
            this.field.getComponent().setEnabled(false);
        }
    }

    protected void updateField() {
        this.field.updateField(this.getCurrentView().getSelectedFigures());
    }

    protected Set<Figure> getCurrentSelection() {
        if (this.getCurrentView() != null) {
            return this.getCurrentView().getSelectedFigures();
        }
        return Collections.emptySet();
    }

    @Override
    public void figureAreaInvalidated(FigureEvent e) {
    }

    @Override
    public void figureAttributeChanged(FigureEvent e) {
        this.updateField();
    }

    @Override
    public void figureHandlesChanged(FigureEvent e) {
    }

    @Override
    public void figureChanged(FigureEvent e) {
    }

    @Override
    public void figureAdded(FigureEvent e) {
    }

    @Override
    public void figureRemoved(FigureEvent e) {
    }

    @Override
    public void figureRequestRemove(FigureEvent e) {
    }

    public void setEditor(DrawingEditor newValue) {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this);
            if (this.getCurrentView() != null) {
                this.getCurrentView().removeFigureSelectionListener(this);
            }
        }
        this.editor = newValue;
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(this);
            if (this.getCurrentView() != null) {
                this.getCurrentView().addFigureSelectionListener(this);
            }
        }
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    public void setView(DrawingView newValue) {
        if (this.getCurrentView() != null) {
            this.getCurrentView().removeFigureSelectionListener(this);
            for (Figure f : this.getCurrentView().getSelectedFigures()) {
                f.removeFigureListener(this);
            }
        }
        this.view = newValue;
        if (this.getCurrentView() != null) {
            this.getCurrentView().addFigureSelectionListener(this);
            for (Figure f : this.getCurrentView().getSelectedFigures()) {
                f.addFigureListener(this);
            }
        }
    }

    public DrawingView getView() {
        return this.view;
    }

    public DrawingView getCurrentView() {
        return this.view != null ? this.view : (this.editor == null ? null : this.editor.getActiveView());
    }

    public void dispose() {
        this.setEditor(null);
    }
}

