/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.Dimension;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.jhotdraw.gui.Arrangeable;
import org.jhotdraw.gui.MDIDesktopManager;

public class MDIDesktopPane
extends JDesktopPane
implements Arrangeable {
    private static int FRAME_OFFSET = 20;
    private MDIDesktopManager manager = new MDIDesktopManager(this);

    public MDIDesktopPane() {
        this.setDesktopManager(this.manager);
        this.setDragMode(1);
        this.setAlignmentX(0.0f);
    }

    public void setArrangement(Arrangeable.Arrangement newValue) {
        Arrangeable.Arrangement oldValue = this.getArrangement();
        switch (newValue) {
            case CASCADE: {
                this.arrangeFramesCascading();
                break;
            }
            case HORIZONTAL: {
                this.arrangeFramesHorizontally();
                break;
            }
            case VERTICAL: {
                this.arrangeFramesVertically();
            }
        }
        this.firePropertyChange("arrangement", (Object)oldValue, (Object)newValue);
    }

    public Arrangeable.Arrangement getArrangement() {
        return Arrangeable.Arrangement.CASCADE;
    }

    private void arrangeFramesCascading() {
        int x = 0;
        int y = 0;
        JInternalFrame[] allFrames = this.getAllFrames();
        if (allFrames.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int frameHeight = this.getBounds().height - 5 - allFrames.length * FRAME_OFFSET;
        int frameWidth = this.getBounds().width - 5 - allFrames.length * FRAME_OFFSET;
        for (int i = allFrames.length - 1; i >= 0; --i) {
            try {
                allFrames[i].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            allFrames[i].setBounds(x, y, frameWidth, frameHeight);
            x += FRAME_OFFSET;
            y += FRAME_OFFSET;
        }
        this.checkDesktopSize();
    }

    private void tileFramesHorizontally() {
        JInternalFrame[] allFrames = this.getAllFrames();
        if (allFrames.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int frameHeight = this.getBounds().height / allFrames.length;
        int y = 0;
        for (int i = 0; i < allFrames.length; ++i) {
            try {
                allFrames[i].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            allFrames[i].setBounds(0, y, this.getBounds().width, frameHeight);
            y += frameHeight;
        }
        this.checkDesktopSize();
    }

    public void tileFramesVertically() {
        JInternalFrame[] allFrames = this.getAllFrames();
        if (allFrames.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int frameWidth = this.getBounds().width / allFrames.length;
        int x = 0;
        for (int i = 0; i < allFrames.length; ++i) {
            try {
                allFrames[i].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            allFrames[i].setBounds(x, 0, frameWidth, this.getBounds().height);
            x += frameWidth;
        }
        this.checkDesktopSize();
    }

    public void arrangeFramesVertically() {
        JInternalFrame[] allFrames = this.getAllFrames();
        if (allFrames.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int vertFrames = (int)Math.floor(Math.sqrt(allFrames.length));
        int horFrames = (int)Math.ceil(Math.sqrt(allFrames.length));
        int frameWidth = this.getBounds().width / horFrames;
        int frameHeight = this.getBounds().height / vertFrames;
        int x = 0;
        int y = 0;
        int frameIdx = 0;
        for (int horCnt = 0; horCnt < horFrames - 1; ++horCnt) {
            y = 0;
            for (int vertCnt = 0; vertCnt < vertFrames; ++vertCnt) {
                try {
                    allFrames[frameIdx].setMaximum(false);
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
                allFrames[frameIdx].setBounds(x, y, frameWidth, frameHeight);
                ++frameIdx;
                y += frameHeight;
            }
            x += frameWidth;
        }
        frameHeight = this.getBounds().height / (allFrames.length - frameIdx);
        y = 0;
        while (frameIdx < allFrames.length) {
            try {
                allFrames[frameIdx].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            allFrames[frameIdx].setBounds(x, y, frameWidth, frameHeight);
            y += frameHeight;
            ++frameIdx;
        }
        this.checkDesktopSize();
    }

    public void arrangeFramesHorizontally() {
        JInternalFrame[] allFrames = this.getAllFrames();
        if (allFrames.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int vertFrames = (int)Math.ceil(Math.sqrt(allFrames.length));
        int horFrames = (int)Math.floor(Math.sqrt(allFrames.length));
        int frameWidth = this.getBounds().width / horFrames;
        int frameHeight = this.getBounds().height / vertFrames;
        int x = 0;
        int y = 0;
        int frameIdx = 0;
        for (int vertCnt = 0; vertCnt < vertFrames - 1; ++vertCnt) {
            x = 0;
            for (int horCnt = 0; horCnt < horFrames; ++horCnt) {
                try {
                    allFrames[frameIdx].setMaximum(false);
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
                allFrames[frameIdx].setBounds(x, y, frameWidth, frameHeight);
                ++frameIdx;
                x += frameWidth;
            }
            y += frameHeight;
        }
        frameWidth = this.getBounds().width / (allFrames.length - frameIdx);
        x = 0;
        while (frameIdx < allFrames.length) {
            try {
                allFrames[frameIdx].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            allFrames[frameIdx].setBounds(x, y, frameWidth, frameHeight);
            x += frameWidth;
            ++frameIdx;
        }
        this.checkDesktopSize();
    }

    public void setAllSize(Dimension d) {
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setPreferredSize(d);
        this.setBounds(0, 0, d.width, d.height);
    }

    public void setAllSize(int width, int height) {
        this.setAllSize(new Dimension(width, height));
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.manager.resizeDesktop();
        }
    }
}

