/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class InputStreamTransferable
implements Transferable {
    private DataFlavor[] flavors;
    private byte[] data;

    public InputStreamTransferable(DataFlavor flavor, byte[] data) {
        this(new DataFlavor[]{flavor}, data);
    }

    public InputStreamTransferable(DataFlavor[] flavors, byte[] data) {
        this.flavors = flavors;
        this.data = data;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])this.flavors.clone();
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor f : this.flavors) {
            if (!f.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return new ByteArrayInputStream(this.data);
    }
}

