/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.DefaultApplicationModel;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AbstractProjectAction;
import org.jhotdraw.app.action.Actions;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.ExportAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.ProjectPropertyAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.app.action.ToggleProjectPropertyAction;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.ImageTool;
import org.jhotdraw.draw.TextAreaTool;
import org.jhotdraw.draw.TextTool;
import org.jhotdraw.draw.action.ApplyAttributesAction;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.MoveToBackAction;
import org.jhotdraw.draw.action.MoveToFrontAction;
import org.jhotdraw.draw.action.PickAttributesAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.PathTool;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.SVGProject;
import org.jhotdraw.samples.svg.action.CombineAction;
import org.jhotdraw.samples.svg.action.SplitAction;
import org.jhotdraw.samples.svg.action.TogglePropertiesPanelAction;
import org.jhotdraw.samples.svg.action.ViewSourceAction;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGEllipseFigure;
import org.jhotdraw.samples.svg.figures.SVGGroupFigure;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;
import org.jhotdraw.samples.svg.figures.SVGRectFigure;
import org.jhotdraw.samples.svg.figures.SVGTextAreaFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGApplicationModel
extends DefaultApplicationModel {
    private static final double[] scaleFactors = new double[]{5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1};
    private DefaultDrawingEditor sharedEditor;

    public DefaultDrawingEditor getSharedEditor() {
        if (this.sharedEditor == null) {
            this.sharedEditor = new DefaultDrawingEditor();
        }
        return this.sharedEditor;
    }

    @Override
    public void initProject(Application a, Project p) {
        if (a.isSharingToolsAmongProjects()) {
            ((SVGProject)p).setEditor(this.getSharedEditor());
        }
    }

    @Override
    public void initApplication(Application a) {
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.svg.Labels");
        this.putAction("viewSource", new ViewSourceAction(a));
        this.putAction("export", new ExportAction(a));
        AbstractProjectAction aa = new ToggleProjectPropertyAction(a, "gridVisible");
        this.putAction("toggleGrid", aa);
        drawLabels.configureAction(aa, "alignGrid");
        for (double sf : scaleFactors) {
            aa = new ProjectPropertyAction(a, "scaleFactor", Double.TYPE, new Double(sf));
            this.putAction((int)(sf * 100.0) + "%", aa);
            aa.putValue("Name", (int)(sf * 100.0) + " %");
        }
        this.putAction("togglePropertiesPanel", new TogglePropertiesPanelAction(a));
    }

    @Override
    public List<JToolBar> createToolBars(Application a, Project pr) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        SVGProject p = (SVGProject)pr;
        DrawingEditor editor = p == null ? this.getSharedEditor() : p.getEditor();
        LinkedList<JToolBar> list = new LinkedList<JToolBar>();
        JToolBar tb = new JToolBar();
        this.addCreationButtonsTo(tb, editor);
        tb.setName(labels.getString("drawToolBarTitle"));
        list.add(tb);
        tb = new JToolBar();
        this.addAttributesButtonsTo(tb, editor);
        tb.setName(labels.getString("attributesToolBarTitle"));
        list.add(tb);
        tb = new JToolBar();
        ButtonFactory.addAlignmentButtonsTo(tb, editor);
        tb.setName(labels.getString("alignmentToolBarTitle"));
        list.add(tb);
        return list;
    }

    public static Collection<Action> createDrawingActions(DrawingEditor editor) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add(new CutAction());
        a.add(new CopyAction());
        a.add(new PasteAction());
        a.add(new SelectAllAction());
        a.add(new SelectSameAction(editor));
        return a;
    }

    public static Collection<Action> createSelectionActions(DrawingEditor editor) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add(new DuplicateAction());
        a.add(null);
        a.add(new GroupAction(editor, new SVGGroupFigure()));
        a.add(new UngroupAction(editor, new SVGGroupFigure()));
        a.add(new CombineAction(editor));
        a.add(new SplitAction(editor));
        a.add(null);
        a.add(new MoveToFrontAction(editor));
        a.add(new MoveToBackAction(editor));
        return a;
    }

    private void addCreationButtonsTo(JToolBar tb, DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.svg.Labels");
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        ButtonFactory.addSelectionToolTo(tb, editor, SVGApplicationModel.createDrawingActions(editor), SVGApplicationModel.createSelectionActions(editor));
        tb.addSeparator();
        HashMap<AttributeKey<Object>, Object> attributes = new HashMap<AttributeKey, Object>();
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new SVGRectFigure(), attributes), "createRectangle", drawLabels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new SVGEllipseFigure(), attributes), "createEllipse", drawLabels);
        ButtonFactory.addToolTo(tb, editor, new PathTool(new SVGPathFigure(), new SVGBezierFigure(true), attributes), "createPolygon", drawLabels);
        attributes = new HashMap();
        attributes.put(AttributeKeys.FILL_COLOR, null);
        attributes.put(AttributeKeys.STROKE_COLOR, Color.black);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new SVGPathFigure(), attributes), "createLine", drawLabels);
        ButtonFactory.addToolTo(tb, editor, new PathTool(new SVGPathFigure(), new SVGBezierFigure(false), attributes), "createScribble", drawLabels);
        attributes = new HashMap();
        attributes.put(AttributeKeys.FILL_COLOR, Color.black);
        attributes.put(AttributeKeys.STROKE_COLOR, null);
        ButtonFactory.addToolTo(tb, editor, new TextTool(new SVGTextFigure(), attributes), "createText", drawLabels);
        TextAreaTool tat = new TextAreaTool(new SVGTextAreaFigure(), attributes);
        tat.setRubberbandColor(Color.BLACK);
        ButtonFactory.addToolTo(tb, editor, tat, "createTextArea", drawLabels);
        attributes = new HashMap();
        attributes.put(AttributeKeys.FILL_COLOR, null);
        attributes.put(AttributeKeys.STROKE_COLOR, null);
        ButtonFactory.addToolTo(tb, editor, new ImageTool(new SVGImageFigure(), attributes), "createImage", drawLabels);
    }

    private void addAttributesButtonsTo(JToolBar bar, DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JButton b = bar.add(new PickAttributesAction(editor));
        b.setFocusable(false);
        b = bar.add(new ApplyAttributesAction(editor));
        b.setFocusable(false);
        bar.addSeparator();
        this.addColorButtonsTo(bar, editor);
        bar.addSeparator();
        this.addStrokeButtonsTo(bar, editor);
        bar.addSeparator();
        ButtonFactory.addFontButtonsTo(bar, editor);
    }

    private void addColorButtonsTo(JToolBar bar, DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        HashMap<AttributeKey<Object>, Object> defaultAttributes = new HashMap<AttributeKey, Object>();
        SVGAttributeKeys.STROKE_GRADIENT.set(defaultAttributes, (Gradient)null);
        bar.add(ButtonFactory.createEditorColorButton(editor, AttributeKeys.STROKE_COLOR, ButtonFactory.DEFAULT_COLORS, 8, "attributeStrokeColor", labels, defaultAttributes));
        defaultAttributes = new HashMap();
        SVGAttributeKeys.FILL_GRADIENT.set(defaultAttributes, (Gradient)null);
        bar.add(ButtonFactory.createEditorColorButton(editor, AttributeKeys.FILL_COLOR, ButtonFactory.DEFAULT_COLORS, 8, "attributeFillColor", labels, defaultAttributes));
    }

    private void addStrokeButtonsTo(JToolBar bar, DrawingEditor editor) {
        bar.add(ButtonFactory.createStrokeWidthButton(editor));
        bar.add(ButtonFactory.createStrokeDashesButton(editor));
        bar.add(ButtonFactory.createStrokeCapButton(editor));
        bar.add(ButtonFactory.createStrokeJoinButton(editor));
    }

    @Override
    public List<JMenu> createMenus(Application a, Project pr) {
        SVGProject p = (SVGProject)pr;
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        LinkedList<JMenu> mb = new LinkedList<JMenu>();
        mb.add(this.createEditMenu(a, pr));
        JMenu m = new JMenu();
        labels.configureMenu(m, "view");
        JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(this.getAction("toggleGrid"));
        Actions.configureJCheckBoxMenuItem(cbmi, this.getAction("toggleGrid"));
        m.add(cbmi);
        JMenu m2 = new JMenu("Zoom");
        for (double sf : scaleFactors) {
            String id = (int)(sf * 100.0) + "%";
            cbmi = new JCheckBoxMenuItem(this.getAction(id));
            Actions.configureJCheckBoxMenuItem(cbmi, this.getAction(id));
            m2.add(cbmi);
        }
        m.add(m2);
        cbmi = new JCheckBoxMenuItem(this.getAction("togglePropertiesPanel"));
        m.add(this.getAction("viewSource"));
        m.add(cbmi);
        mb.add(m);
        return mb;
    }
}

