/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.DOMStorable;

public class DefaultDOMFactory
implements DOMFactory {
    private static final HashMap<Class, String> classToNameMap = new HashMap();
    private static final HashMap<String, Object> nameToPrototypeMap = new HashMap();
    private static final HashMap<Class, String> enumClassToNameMap = new HashMap();
    private static final HashMap<String, Class> nameToEnumClassMap = new HashMap();
    private static final HashMap<Enum, String> enumToValueMap = new HashMap();
    private static final HashMap<String, Set<Enum>> valueToEnumMap = new HashMap();

    public void addStorableClass(String name, Class c) {
        nameToPrototypeMap.put(name, c);
        classToNameMap.put(c, name);
    }

    public void addStorable(String name, DOMStorable prototype) {
        nameToPrototypeMap.put(name, prototype);
        classToNameMap.put(prototype.getClass(), name);
    }

    public void addEnumClass(String name, Class c) {
        enumClassToNameMap.put(c, name);
        nameToEnumClassMap.put(name, c);
    }

    public void addEnum(String value, Enum e) {
        Set<Object> enums;
        enumToValueMap.put(e, value);
        if (valueToEnumMap.containsKey(value)) {
            enums = valueToEnumMap.get(value);
        } else {
            enums = new HashSet();
            valueToEnumMap.put(value, enums);
        }
        enums.add(e);
    }

    public Object create(String name) {
        Object o = nameToPrototypeMap.get(name);
        if (o == null) {
            throw new IllegalArgumentException("Storable name not known to factory: " + name);
        }
        if (o instanceof Class) {
            try {
                return ((Class)o).newInstance();
            }
            catch (Exception e) {
                IllegalArgumentException error = new IllegalArgumentException("Storable class not instantiable by factory: " + name);
                error.initCause(e);
                throw error;
            }
        }
        try {
            return o.getClass().getMethod("clone", null).invoke(o, (Object[])null);
        }
        catch (Exception e) {
            IllegalArgumentException error = new IllegalArgumentException("Storable prototype not cloneable by factory. Name: " + name);
            error.initCause(e);
            throw error;
        }
    }

    public String getName(DOMStorable o) {
        String name = classToNameMap.get(o.getClass());
        if (name == null) {
            throw new IllegalArgumentException("Storable class not known to factory. Storable:" + o + " Factory:" + this.getClass());
        }
        return name;
    }

    public String getEnumName(Enum e) {
        String name = enumClassToNameMap.get(e.getClass());
        if (name == null) {
            throw new IllegalArgumentException("Enum class not known to factory:" + e.getClass());
        }
        return name;
    }

    public String getEnumValue(Enum e) {
        return enumToValueMap.containsKey(e) ? enumToValueMap.get(e) : e.toString();
    }

    public Enum createEnum(String name, String value) {
        Class enumClass = nameToEnumClassMap.get(name);
        if (enumClass == null) {
            throw new IllegalArgumentException("Enum name not known to factory:" + name);
        }
        Set<Enum> enums = valueToEnumMap.get(value);
        if (enums == null) {
            return Enum.valueOf(enumClass, value);
        }
        for (Enum e : enums) {
            if (e.getClass() != enumClass) continue;
            return e;
        }
        throw new IllegalArgumentException("Enum value not known to factory:" + value);
    }
}

