/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml.css;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jhotdraw.xml.css.CSSRule;
import org.jhotdraw.xml.css.StyleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSParser {
    public void parse(String css, StyleManager rm) throws IOException {
        this.parse(new StringReader(css), rm);
    }

    public void parse(Reader css, StyleManager rm) throws IOException {
        StreamTokenizer tt = new StreamTokenizer(css);
        tt.resetSyntax();
        tt.wordChars(97, 122);
        tt.wordChars(65, 90);
        tt.wordChars(48, 57);
        tt.wordChars(160, 255);
        tt.whitespaceChars(0, 32);
        tt.commentChar(47);
        tt.slashStarComments(true);
        this.parseStylesheet(tt, rm);
    }

    private void parseStylesheet(StreamTokenizer tt, StyleManager rm) throws IOException {
        while (tt.nextToken() != -1) {
            tt.pushBack();
            this.parseRuleset(tt, rm);
        }
    }

    private void parseRuleset(StreamTokenizer tt, StyleManager rm) throws IOException {
        List<String> selectors = this.parseSelectorList(tt);
        if (tt.nextToken() != 123) {
            throw new IOException("Ruleset '{' missing for " + selectors);
        }
        Map<String, String> declarations = this.parseDeclarationMap(tt);
        if (tt.nextToken() != 125) {
            throw new IOException("Ruleset '}' missing for " + selectors);
        }
        for (String selector : selectors) {
            rm.add(new CSSRule(selector, declarations));
        }
    }

    private List<String> parseSelectorList(StreamTokenizer tt) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        StringBuilder selector = new StringBuilder();
        boolean needsWhitespace = false;
        block4: while (tt.nextToken() != -1 && tt.ttype != 123) {
            switch (tt.ttype) {
                case -3: {
                    if (needsWhitespace) {
                        selector.append(' ');
                    }
                    selector.append(tt.sval);
                    needsWhitespace = true;
                    continue block4;
                }
                case 44: {
                    list.add(selector.toString());
                    selector.setLength(0);
                    needsWhitespace = false;
                    continue block4;
                }
            }
            if (needsWhitespace) {
                selector.append(' ');
            }
            selector.append((char)tt.ttype);
            needsWhitespace = false;
        }
        if (selector.length() != 0) {
            list.add(selector.toString());
        }
        tt.pushBack();
        return list;
    }

    private Map<String, String> parseDeclarationMap(StreamTokenizer tt) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        do {
            StringBuilder key = new StringBuilder();
            block7: while (tt.nextToken() != -1 && tt.ttype != 125 && tt.ttype != 58 && tt.ttype != 59) {
                switch (tt.ttype) {
                    case -3: {
                        key.append(tt.sval);
                        continue block7;
                    }
                }
                key.append((char)tt.ttype);
            }
            if (tt.ttype == 125 && key.length() == 0) break;
            if (tt.ttype != 58) {
                throw new IOException("Declaration ':' missing for " + key);
            }
            StringBuilder value = new StringBuilder();
            boolean needsWhitespace = false;
            block8: while (tt.nextToken() != -1 && tt.ttype != 59 && tt.ttype != 125) {
                switch (tt.ttype) {
                    case -3: {
                        if (needsWhitespace) {
                            value.append(' ');
                        }
                        value.append(tt.sval);
                        needsWhitespace = true;
                        continue block8;
                    }
                }
                value.append((char)tt.ttype);
                needsWhitespace = false;
            }
            map.put(key.toString(), value.toString());
        } while (tt.ttype != 125 && tt.ttype != -1);
        tt.pushBack();
        return map;
    }
}

