/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5ReaderConfigurator;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import java.io.File;

class HDF5ReaderConfigurator
implements IHDF5ReaderConfigurator {
    protected final File hdf5File;
    protected boolean performNumericConversions;
    protected boolean useUTF8CharEncoding;
    protected boolean autoDereference = true;
    protected HDF5Reader readerWriterOrNull;

    HDF5ReaderConfigurator(File hdf5File) {
        assert (hdf5File != null);
        this.hdf5File = hdf5File.getAbsoluteFile();
    }

    @Override
    public boolean platformSupportsNumericConversions() {
        return true;
    }

    @Override
    public HDF5ReaderConfigurator performNumericConversions() {
        if (this.platformSupportsNumericConversions()) {
            this.performNumericConversions = true;
        }
        return this;
    }

    @Override
    public HDF5ReaderConfigurator useUTF8CharacterEncoding() {
        this.useUTF8CharEncoding = true;
        return this;
    }

    @Override
    public HDF5ReaderConfigurator noAutoDereference() {
        this.autoDereference = false;
        return this;
    }

    @Override
    public IHDF5Reader reader() {
        if (this.readerWriterOrNull == null) {
            this.readerWriterOrNull = new HDF5Reader(new HDF5BaseReader(this.hdf5File, this.performNumericConversions, this.autoDereference, IHDF5WriterConfigurator.FileFormat.ALLOW_1_8, false, ""));
        }
        return this.readerWriterOrNull;
    }
}

