/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import loci.common.enumeration.CodedEnum;
import loci.common.enumeration.EnumException;

public enum CompressionType implements CodedEnum
{
    UNCOMPRESSED(1, "Uncompressed"),
    ZLIB(2, "zlib"),
    CINEPAK(3, "Cinepak"),
    ANIMATION(4, "Animation"),
    H_263(5, "H.263"),
    SORENSON(6, "Sorenson"),
    SORENSON_3(7, "Sorenson 3"),
    MPEG_4(8, "MPEG 4"),
    LZW(9, "LZW"),
    J2K(10, "JPEG-2000"),
    J2K_LOSSY(11, "JPEG-2000 Lossy"),
    JPEG(12, "JPEG");

    private int code;
    private String compression;
    private static final Map<Integer, CompressionType> lookup;

    public static CompressionType get(int code) {
        CompressionType toReturn = lookup.get(code);
        if (toReturn == null) {
            throw new EnumException("Unable to find CompressionType with code: " + code);
        }
        return toReturn;
    }

    private CompressionType(int code, String compression) {
        this.code = code;
        this.compression = compression;
    }

    public int getCode() {
        return this.code;
    }

    public String getCompression() {
        return this.compression;
    }

    static {
        lookup = new HashMap<Integer, CompressionType>();
        for (CompressionType v : EnumSet.allOf(CompressionType.class)) {
            lookup.put(v.getCode(), v);
        }
    }
}

