/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.in.BIFormatReader;
import loci.formats.meta.MetadataStore;

public abstract class ImageIOReader
extends BIFormatReader {
    private transient BufferedImage img;

    public ImageIOReader(String name, String suffix) {
        super(name, suffix);
        this.domains = new String[]{"Graphics"};
    }

    public ImageIOReader(String name, String[] suffixes) {
        super(name, suffixes);
        this.domains = new String[]{"Graphics"};
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.img = null;
        }
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        return this.getSizeY();
    }

    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)-1, (int)x, (int)y, (int)w, (int)h);
        if (this.img == null) {
            this.initImage();
        }
        return AWTImageTools.getSubimage(this.img, this.isLittleEndian(), x, y, w, h);
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        LOGGER.info("Populating metadata");
        m.imageCount = 1;
        this.initImage();
        m.sizeX = this.img.getWidth();
        m.sizeY = this.img.getHeight();
        m.rgb = this.img.getRaster().getNumBands() > 1;
        m.sizeZ = 1;
        m.sizeC = this.isRGB() ? 3 : 1;
        m.sizeT = 1;
        m.dimensionOrder = "XYCZT";
        m.pixelType = AWTImageTools.getPixelType(this.img);
        m.interleaved = false;
        m.littleEndian = false;
        m.metadataComplete = true;
        m.indexed = false;
        m.falseColor = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initImage() throws IOException, FormatException {
        try (RandomAccessInputStream ras = new RandomAccessInputStream(this.currentId);
             DataInputStream dis = new DataInputStream((InputStream)ras);){
            this.img = ImageIO.read(dis);
        }
        if (this.img == null) {
            throw new FormatException("Invalid image stream");
        }
    }
}

