/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import ucar.bufr.BufrData;
import ucar.bufr.BufrDataSection;
import ucar.bufr.BufrIdentificationSection;
import ucar.bufr.BufrInput;
import ucar.bufr.BufrRecord;
import ucar.unidata.io.RandomAccessFile;

public final class BufrDump {
    private static final String line = "--------------------------------------------------------------------";

    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("BufrDatas:");
        System.out.println("<true or false> whether to display data");
        System.out.println("<true or false> one record only");
        System.out.println("<Bufr File to read> reads/scans file");
        System.out.println("[<output File>]");
        System.out.println();
        System.out.println("java " + className + " <true or false> <true or false> <BufrFileToRead>");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BufrDump func = new BufrDump();
        if (args.length < 1) {
            Class<?> cl = func.getClass();
            BufrDump.usage(cl.getName());
        }
        boolean displayData = true;
        boolean oneRecord = false;
        PrintStream ps = System.out;
        Date now = Calendar.getInstance().getTime();
        try {
            RandomAccessFile raf = null;
            if (args.length == 3 || args.length == 4) {
                raf = new RandomAccessFile(args[2], "r");
                displayData = args[0].equalsIgnoreCase("true");
                oneRecord = args[1].equalsIgnoreCase("true");
                if (args.length == 4) {
                    ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(args[3], false)));
                }
            } else if (args.length == 2) {
                raf = new RandomAccessFile(args[1], "r");
                if (args[0].equalsIgnoreCase("true") || args[0].equalsIgnoreCase("false")) {
                    displayData = args[0].equalsIgnoreCase("true");
                }
            } else if (args.length == 1) {
                raf = new RandomAccessFile(args[0], "r");
            } else {
                System.exit(0);
            }
            raf.order(0);
            BufrInput bi = new BufrInput(raf);
            bi.scan(oneRecord, false);
            int totalObs = bi.getTotalObs();
            ps.println("Total number observations =" + totalObs);
            ArrayList records = bi.getRecords();
            ps.println(line);
            for (int i = 0; i < records.size(); ++i) {
                BufrRecord record = (BufrRecord)records.get(i);
                BufrDump.printIds(record, ps);
                int numberDatasets = record.getNumberDatasets();
                ArrayList dorder = record.getDorder();
                HashMap bufrdatas = record.getBufrDatas();
                for (int j = 0; j < dorder.size(); ++j) {
                    int k;
                    Object[] data;
                    String bKey = (String)dorder.get(j);
                    BufrData bd = (BufrData)bufrdatas.get(bKey);
                    ps.print(bd.getKey() + " " + bd.getName());
                    if (bKey.equals("0-4-250")) {
                        data = bd.getLongData();
                        ps.println(" size =" + data.length + " varCount =" + bd.getVarCount());
                        if (!displayData) continue;
                        for (k = 0; k < data.length; ++k) {
                            ps.print(" " + data[k]);
                        }
                        ps.println();
                        continue;
                    }
                    if (bd.isNumeric()) {
                        data = bd.getFloatData();
                        ps.println(" size =" + data.length + " varCount =" + bd.getVarCount());
                        if (!displayData) continue;
                        for (k = 0; k < data.length; ++k) {
                            ps.print(" " + data[k]);
                        }
                        ps.println();
                        continue;
                    }
                    data = bd.getStringData();
                    ps.println(" size =" + data.length);
                    if (!displayData) continue;
                    for (k = 0; k < data.length; ++k) {
                        ps.print(" " + (String)data[k]);
                    }
                    ps.println();
                }
                ps.println();
            }
            raf.close();
        }
        catch (FileNotFoundException noFileError) {
            System.err.println("FileNotFoundException : " + noFileError);
        }
        catch (IOException ioError) {
            System.err.println("IOException : " + ioError);
        }
        finally {
            ps.close();
        }
        now = Calendar.getInstance().getTime();
    }

    private static void printIds(BufrRecord record, PrintStream ps) {
        BufrIdentificationSection ids = record.getIds();
        ps.println("                          BUFR Product ");
        ps.println("                        Header : " + record.getHeader());
        ps.println("                Reference Time : " + ids.getReferenceTime());
        ps.println("                  Nominal Time : " + ids.getNominalTime());
        ps.println("                     Center Id : " + ids.getCenter_id() + " " + ids.getCenter_idName(ids.getCenter_id()));
        ps.println("                 Sub Center Id : " + ids.getSubCenter_id() + " " + ids.getCenter_idName(ids.getSubCenter_id()));
        String cat = Integer.toString(ids.getCategory());
        ps.println("                      Category : " + cat + " " + (String)BufrDataSection.tableA.get(cat));
        ps.println(line);
    }
}

