/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.bufr.BufrDataDescriptionSection;
import ucar.bufr.BufrDataSection;
import ucar.bufr.BufrIdentificationSection;
import ucar.bufr.BufrIndicatorSection;
import ucar.bufr.BufrReadTables;
import ucar.bufr.BufrRecord;
import ucar.unidata.io.RandomAccessFile;

public final class BufrInput {
    private RandomAccessFile raf = null;
    private String header = "BUFR";
    private static final Pattern productID = Pattern.compile("(\\w{6} \\w{4} \\d{6})");
    private final ArrayList records = new ArrayList();
    private int numberObs = 0;

    public BufrInput(RandomAccessFile raf) {
        this.raf = raf;
    }

    public final void scan(boolean oneRecord, boolean getData) throws IOException {
        long start = System.currentTimeMillis();
        while (this.raf.getFilePointer() < this.raf.length()) {
            BufrDataSection ds;
            if (!this.seekHeader(this.raf, this.raf.length())) continue;
            BufrIndicatorSection is = new BufrIndicatorSection(this.raf);
            long EOR = this.raf.getFilePointer() + is.getBufrLength() - (long)is.getLength();
            BufrIdentificationSection ids = new BufrIdentificationSection(this.raf, is);
            BufrDataDescriptionSection dds = new BufrDataDescriptionSection(this.raf);
            if (ids.getCategory() == 11) {
                ds = new BufrDataSection(this.raf, ids.getMasterTableFilename());
                BufrReadTables brt = new BufrReadTables(this.raf, ids, dds, BufrDataSection.tableA, BufrDataSection.tableB, BufrDataSection.tableD);
                BufrDataSection.tableA = brt.getTableA();
                BufrDataSection.tableB = brt.getTableB();
                BufrDataSection.tableD = brt.getTableD();
                continue;
            }
            ds = new BufrDataSection(this.raf, ids.getMasterTableFilename());
            boolean goodData = ds.read(dds);
            if (goodData) {
                this.records.add(new BufrRecord(this.header, ids, dds, ds));
                this.numberObs += dds.getNumberDataSets();
            }
            if (oneRecord) {
                return;
            }
            this.raf.seek(EOR);
            if (this.raf.getFilePointer() <= this.raf.length()) continue;
            this.raf.seek(0L);
            System.err.println("BufrInput: possible file corruption");
            return;
        }
    }

    public final boolean isValidFile() throws IOException {
        long length;
        long l = length = this.raf.length() < 4000L ? this.raf.length() : 4000L;
        return this.seekHeader(this.raf, length);
    }

    private boolean seekHeader(RandomAccessFile raf, long stop) throws IOException {
        StringBuffer hdr = new StringBuffer();
        int match = 0;
        while (raf.getFilePointer() < stop) {
            if (hdr.length() > 512 && match == 0) {
                hdr.setLength(0);
            }
            char c = (char)raf.read();
            hdr.append(c);
            if (c == 'B') {
                match = 1;
                continue;
            }
            if (c == 'U' && match == 1) {
                match = 2;
                continue;
            }
            if (c == 'F' && match == 2) {
                match = 3;
                continue;
            }
            if (c == 'R' && match == 3) {
                Matcher m;
                match = 4;
                if (hdr.length() > 35) {
                    this.header = hdr.substring(hdr.length() - 36);
                }
                this.header = (m = productID.matcher(this.header)).find() ? m.group(1) : "BUFR";
                return true;
            }
            match = 0;
        }
        return false;
    }

    public final ArrayList getRecords() {
        return this.records;
    }

    public final int getTotalObs() {
        return this.numberObs;
    }
}

