/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Index {
    private static final boolean debugTiming = false;
    private static final boolean debugParse = false;
    public static final String current_index_version = "1.1";
    private int numberObs = 0;
    private final ArrayList locations = new ArrayList();
    private final HashMap coordinates = new HashMap();
    private final HashMap observations = new HashMap();
    private final ArrayList times = new ArrayList();
    private final HashMap timelocations = new HashMap();
    private final ArrayList parameters = new ArrayList();
    private final HashMap atts = new HashMap();
    private boolean isCompressedData = false;
    private static final Pattern pInfo = Pattern.compile("^(.*)\\t(.*)\\t(.*)\\t(.*)\\t(.*)$");
    private static final String testName = "/home/rkambic/code/bufr/data/PROFILER_3.bufr.bfx";

    public final boolean open(String reference) throws IOException {
        InputStream ios;
        if (reference.startsWith("http:")) {
            URL url = new URL(reference);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(reference);
        }
        return this.open(reference, ios);
    }

    public final boolean open(String reference, InputStream ios) throws IOException {
        String line;
        String line2;
        long start = System.currentTimeMillis();
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        boolean versionOk = false;
        while ((line2 = dataIS.readLine()) != null && !line2.startsWith("--")) {
            int pos = line2.indexOf(" = ");
            if (pos <= 0) continue;
            String key = line2.substring(0, pos);
            String value = line2.substring(pos + 3);
            this.atts.put(key, value);
            if (key.equals("compressdata")) {
                this.isCompressedData = value.equalsIgnoreCase("true");
            }
            if (!key.equals("index_version")) continue;
            versionOk = value.equalsIgnoreCase(current_index_version);
        }
        if (!versionOk) {
            return false;
        }
        while ((line2 = dataIS.readLine()) != null && !line2.startsWith("--")) {
            ArrayList loc;
            ArrayList obs;
            StringTokenizer stoke = new StringTokenizer(line2);
            String name = stoke.nextToken();
            String ISOdate = stoke.nextToken();
            String dim = stoke.nextToken();
            String latitude = stoke.nextToken();
            String longitude = stoke.nextToken();
            String altitude = stoke.nextToken();
            String DDSoffset = stoke.nextToken();
            String obsOffset = stoke.nextToken();
            String bitPos = stoke.nextToken();
            String bitBuf = stoke.nextToken();
            BufrObs bo = new BufrObs(name, ISOdate, dim, DDSoffset, obsOffset, bitPos, bitBuf);
            if (this.observations.containsKey(name)) {
                obs = (ArrayList)this.observations.get(name);
                obs.add(bo);
            } else {
                obs = new ArrayList();
                obs.add(bo);
            }
            this.observations.put(name, obs);
            if (!this.times.contains(ISOdate)) {
                this.times.add(ISOdate);
            }
            if (!this.locations.contains(name)) {
                this.locations.add(name);
                coordinate coord = new coordinate(latitude, longitude, altitude);
                this.coordinates.put(name, coord);
            }
            if (this.timelocations.containsKey(ISOdate)) {
                loc = (ArrayList)this.timelocations.get(ISOdate);
                loc.add(name);
            } else {
                loc = new ArrayList();
                loc.add(name);
            }
            this.timelocations.put(ISOdate, loc);
        }
        this.finish();
        while ((line = dataIS.readLine()) != null) {
            Matcher m = pInfo.matcher(line);
            if (!m.find()) continue;
            this.parameters.add(new parameter(m.group(1), Integer.parseInt(m.group(2)), m.group(3).equals("true"), m.group(4), m.group(5)));
        }
        dataIS.close();
        return true;
    }

    public final void finish() {
        Collections.sort(this.times);
        for (int i = 0; i < this.times.size(); ++i) {
            String ISOdate = (String)this.times.get(i);
            ArrayList locs = (ArrayList)this.timelocations.get(ISOdate);
            Collections.sort(locs);
            this.timelocations.put(ISOdate, locs);
        }
        for (int i = 0; i < this.locations.size(); ++i) {
            String name = (String)this.locations.get(i);
            ArrayList obs = (ArrayList)this.observations.get(name);
            Collections.sort(obs, new CompareObsByTime());
            this.observations.put(name, obs);
        }
    }

    public final HashMap getGlobalAttributes() {
        return this.atts;
    }

    public final int getNumberObs() {
        return this.numberObs;
    }

    public final ArrayList getLocations() {
        return this.locations;
    }

    public final HashMap getObservations() {
        return this.observations;
    }

    public final ArrayList getObsTimes() {
        return this.times;
    }

    public final HashMap getObsLocations() {
        return this.timelocations;
    }

    public final HashMap getCoordinates() {
        return this.coordinates;
    }

    public final ArrayList getParameters() {
        return this.parameters;
    }

    public final void addObservation(String name, String ISOdate, int dim, float latitude, float longitude, int altitude, long DDSoffset, long obsOffset, int bitPos, int bitBuf) {
        ArrayList loc;
        ArrayList obs;
        BufrObs bo = new BufrObs(name, ISOdate, dim, DDSoffset, obsOffset, bitPos, bitBuf);
        if (this.observations.containsKey(name)) {
            obs = (ArrayList)this.observations.get(name);
            obs.add(bo);
        } else {
            obs = new ArrayList();
            obs.add(bo);
        }
        this.observations.put(name, obs);
        if (!this.times.contains(ISOdate)) {
            this.times.add(ISOdate);
        }
        if (!this.locations.contains(name)) {
            this.locations.add(name);
            coordinate coord = new coordinate(latitude, longitude, altitude);
            this.coordinates.put(name, coord);
        }
        if (this.timelocations.containsKey(ISOdate)) {
            loc = (ArrayList)this.timelocations.get(ISOdate);
            loc.add(name);
        } else {
            loc = new ArrayList();
            loc.add(name);
        }
        this.timelocations.put(ISOdate, loc);
    }

    public final void addGlobalAttribute(String name, String value) {
        this.atts.put(name, value);
        if (name.equals("compressdata")) {
            this.isCompressedData = value.equalsIgnoreCase("true");
        }
    }

    public BufrObs getBufrObs(String name, String ISOdate, int dim, long DDSoffset, long obsOffset, int bitPos, int bitBuf) {
        return new BufrObs(name, ISOdate, dim, DDSoffset, obsOffset, bitPos, bitBuf);
    }

    public final void addParameter(String key, int dimension, boolean isNumeric, String name, String units) {
        this.parameters.add(new parameter(key, dimension, isNumeric, name, units));
    }

    public static void main(String[] args) throws IOException {
        new Index().open(testName);
    }

    private static final class CompareObsByTime
    implements Comparator {
        private CompareObsByTime() {
        }

        public int compare(Object o1, Object o2) {
            BufrObs bo1 = (BufrObs)o1;
            BufrObs bo2 = (BufrObs)o2;
            return bo1.ISOdate.compareTo(bo2.ISOdate);
        }
    }

    public static final class parameter {
        public final String key;
        public final String name;
        public final String units;
        public final int dimension;
        public final boolean isNumeric;

        public parameter(String key, int dimension, boolean isNumeric, String name, String units) {
            this.key = key;
            this.dimension = dimension;
            this.isNumeric = isNumeric;
            this.name = name;
            this.units = units;
        }
    }

    public static final class coordinate {
        public final float latitude;
        public final float longitude;
        public final int altitude;

        public coordinate(String latitude, String longitude, String altitude) {
            this.latitude = Float.parseFloat(latitude);
            this.longitude = Float.parseFloat(longitude);
            this.altitude = Integer.parseInt(altitude);
        }

        public coordinate(float latitude, float longitude, int altitude) {
            this.latitude = latitude;
            this.longitude = longitude;
            this.altitude = altitude;
        }
    }

    public final class BufrObs {
        public String name;
        public String ISOdate;
        public int dim;
        public int bitPos;
        public int bitBuf;
        public long DDSoffset;
        public long obsOffset;

        public BufrObs() {
        }

        BufrObs(String name, String ISOdate, String dimS, String DDSoffsetS, String obsOffsetS, String bitPosS, String bitBufS) {
            this.name = name;
            this.ISOdate = ISOdate;
            try {
                this.DDSoffset = Long.parseLong(DDSoffsetS);
                this.obsOffset = Long.parseLong(obsOffsetS);
                this.dim = Integer.parseInt(dimS);
                this.bitPos = Integer.parseInt(bitPosS);
                this.bitBuf = Integer.parseInt(bitBufS);
                if (Index.this.isCompressedData) {
                    Index.this.numberObs += this.bitBuf;
                } else {
                    Index.this.numberObs++;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }

        BufrObs(String name, String ISOdate, int dim, long DDSoffset, long obsOffset, int bitPos, int bitBuf) {
            this.name = name;
            this.ISOdate = ISOdate;
            this.dim = dim;
            this.DDSoffset = DDSoffset;
            this.obsOffset = obsOffset;
            this.bitPos = bitPos;
            this.bitBuf = bitBuf;
            if (Index.this.isCompressedData) {
                Index.this.numberObs += bitBuf;
            } else {
                Index.this.numberObs++;
            }
        }
    }
}

