/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.plugin.MacroInstaller;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.applet.Applet;
import java.awt.CheckboxMenuItem;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PopupMenu;
import java.awt.Window;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Menus {
    public static final char PLUGINS_MENU = 'p';
    public static final char IMPORT_MENU = 'i';
    public static final char SAVE_AS_MENU = 's';
    public static final char SHORTCUTS_MENU = 'h';
    public static final char ABOUT_MENU = 'a';
    public static final char FILTERS_MENU = 'f';
    public static final char TOOLS_MENU = 't';
    public static final char UTILITIES_MENU = 'u';
    public static final int WINDOW_MENU_ITEMS = 6;
    public static final int NORMAL_RETURN = 0;
    public static final int COMMAND_IN_USE = -1;
    public static final int INVALID_SHORTCUT = -2;
    public static final int SHORTCUT_IN_USE = -3;
    public static final int NOT_INSTALLED = -4;
    public static final int COMMAND_NOT_FOUND = -5;
    public static final int MAX_OPEN_RECENT_ITEMS = 15;
    private static Menus instance;
    private static MenuBar mbar;
    private static CheckboxMenuItem gray8Item;
    private static CheckboxMenuItem gray16Item;
    private static CheckboxMenuItem gray32Item;
    private static CheckboxMenuItem color256Item;
    private static CheckboxMenuItem colorRGBItem;
    private static CheckboxMenuItem RGBStackItem;
    private static CheckboxMenuItem HSBStackItem;
    private static PopupMenu popup;
    private static ImageJ ij;
    private static boolean isFiji;
    private static Applet applet;
    private Hashtable demoImagesTable = new Hashtable();
    private static String ImageJPath;
    private static String pluginsPath;
    private static String macrosPath;
    private static Properties menus;
    private static Properties menuSeparators;
    private static Menu pluginsMenu;
    private static Menu saveAsMenu;
    private static Menu shortcutsMenu;
    private static Menu utilitiesMenu;
    private static Menu macrosMenu;
    static Menu window;
    static Menu openRecentMenu;
    private static Hashtable pluginsTable;
    private static int nPlugins;
    private static int nMacros;
    private static Hashtable shortcuts;
    private static Hashtable macroShortcuts;
    private static Vector pluginsPrefs;
    static int windowMenuItems2;
    private String error;
    private String jarError;
    private String pluginError;
    private boolean isJarErrorHeading;
    private static boolean installingJars;
    private static boolean duplicateCommand;
    private static Vector jarFiles;
    private Map menuEntry2jarFile = new HashMap();
    private static Vector macroFiles;
    private static int userPluginsIndex;
    private static boolean addSorted;
    private static int defaultFontSize;
    private static int fontSize;
    private static Font menuFont;
    static boolean jnlp;
    static final int RGB_STACK = 10;
    static final int HSB_STACK = 11;

    Menus(ImageJ ijInstance, Applet appletInstance) {
        ij = ijInstance;
        String title = ij != null ? ij.getTitle() : null;
        isFiji = title != null && title.contains("Fiji");
        applet = appletInstance;
        instance = this;
    }

    String addMenuBar() {
        userPluginsIndex = 0;
        nMacros = 0;
        nPlugins = 0;
        duplicateCommand = false;
        installingJars = false;
        addSorted = false;
        this.error = null;
        mbar = null;
        menus = new Properties();
        pluginsTable = new Hashtable();
        shortcuts = new Hashtable();
        pluginsPrefs = new Vector();
        macroShortcuts = null;
        this.setupPluginsAndMacrosPaths();
        Menu file = Menus.getMenu("File");
        Menu newMenu = Menus.getMenu("File>New", true);
        this.addPlugInItem(file, "Open...", "ij.plugin.Commands(\"open\")", 79, false);
        this.addPlugInItem(file, "Open Next", "ij.plugin.NextImageOpener", 79, true);
        Menu openSamples = Menus.getMenu("File>Open Samples", true);
        if (!isFiji) {
            openSamples.addSeparator();
            this.addPlugInItem(openSamples, "Cache Sample Images ", "ij.plugin.URLOpener(\"cache\")", 0, false);
        }
        this.addOpenRecentSubMenu(file);
        Menu importMenu = Menus.getMenu("File>Import", true);
        file.addSeparator();
        this.addPlugInItem(file, "Close", "ij.plugin.Commands(\"close\")", 87, false);
        this.addPlugInItem(file, "Close All", "ij.plugin.Commands(\"close-all\")", 0, false);
        this.addPlugInItem(file, "Save", "ij.plugin.Commands(\"save\")", 83, false);
        saveAsMenu = Menus.getMenu("File>Save As", true);
        this.addPlugInItem(file, "Revert", "ij.plugin.Commands(\"revert\")", 82, false);
        file.addSeparator();
        this.addPlugInItem(file, "Page Setup...", "ij.plugin.filter.Printer(\"setup\")", 0, false);
        this.addPlugInItem(file, "Print...", "ij.plugin.filter.Printer(\"print\")", 80, false);
        Menu edit = Menus.getMenu("Edit");
        this.addPlugInItem(edit, "Undo", "ij.plugin.Commands(\"undo\")", 90, false);
        edit.addSeparator();
        this.addPlugInItem(edit, "Cut", "ij.plugin.Clipboard(\"cut\")", 88, false);
        this.addPlugInItem(edit, "Copy", "ij.plugin.Clipboard(\"copy\")", 67, false);
        this.addPlugInItem(edit, "Copy to System", "ij.plugin.Clipboard(\"scopy\")", 0, false);
        this.addPlugInItem(edit, "Paste", "ij.plugin.Clipboard(\"paste\")", 86, false);
        this.addPlugInItem(edit, "Paste Control...", "ij.plugin.frame.PasteController", 0, false);
        edit.addSeparator();
        this.addPlugInItem(edit, "Clear", "ij.plugin.filter.Filler(\"clear\")", 0, false);
        this.addPlugInItem(edit, "Clear Outside", "ij.plugin.filter.Filler(\"outside\")", 0, false);
        this.addPlugInItem(edit, "Fill", "ij.plugin.filter.Filler(\"fill\")", 70, false);
        this.addPlugInItem(edit, "Draw", "ij.plugin.filter.Filler(\"draw\")", 68, false);
        this.addPlugInItem(edit, "Invert", "ij.plugin.filter.Filters(\"invert\")", 73, true);
        edit.addSeparator();
        Menus.getMenu("Edit>Selection", true);
        Menu optionsMenu = Menus.getMenu("Edit>Options", true);
        Menu image = Menus.getMenu("Image");
        Menu imageType = Menus.getMenu("Image>Type");
        gray8Item = this.addCheckboxItem(imageType, "8-bit", "ij.plugin.Converter(\"8-bit\")");
        gray16Item = this.addCheckboxItem(imageType, "16-bit", "ij.plugin.Converter(\"16-bit\")");
        gray32Item = this.addCheckboxItem(imageType, "32-bit", "ij.plugin.Converter(\"32-bit\")");
        color256Item = this.addCheckboxItem(imageType, "8-bit Color", "ij.plugin.Converter(\"8-bit Color\")");
        colorRGBItem = this.addCheckboxItem(imageType, "RGB Color", "ij.plugin.Converter(\"RGB Color\")");
        imageType.add(new MenuItem("-"));
        RGBStackItem = this.addCheckboxItem(imageType, "RGB Stack", "ij.plugin.Converter(\"RGB Stack\")");
        HSBStackItem = this.addCheckboxItem(imageType, "HSB Stack", "ij.plugin.Converter(\"HSB Stack\")");
        image.add(imageType);
        image.addSeparator();
        Menus.getMenu("Image>Adjust", true);
        this.addPlugInItem(image, "Show Info...", "ij.plugin.filter.Info", 73, false);
        this.addPlugInItem(image, "Properties...", "ij.plugin.filter.ImageProperties", 80, true);
        Menus.getMenu("Image>Color", true);
        Menus.getMenu("Image>Stacks", true);
        Menus.getMenu("Image>Stacks>Tools_", true);
        Menu hyperstacksMenu = Menus.getMenu("Image>Hyperstacks", true);
        image.addSeparator();
        this.addPlugInItem(image, "Crop", "ij.plugin.Resizer(\"crop\")", 88, true);
        this.addPlugInItem(image, "Duplicate...", "ij.plugin.Duplicator", 68, true);
        this.addPlugInItem(image, "Rename...", "ij.plugin.SimpleCommands(\"rename\")", 0, false);
        this.addPlugInItem(image, "Scale...", "ij.plugin.Scaler", 69, false);
        Menus.getMenu("Image>Transform", true);
        Menus.getMenu("Image>Zoom", true);
        Menus.getMenu("Image>Overlay", true);
        image.addSeparator();
        Menus.getMenu("Image>Lookup Tables", true);
        Menu process = Menus.getMenu("Process");
        this.addPlugInItem(process, "Smooth", "ij.plugin.filter.Filters(\"smooth\")", 83, true);
        this.addPlugInItem(process, "Sharpen", "ij.plugin.filter.Filters(\"sharpen\")", 0, false);
        this.addPlugInItem(process, "Find Edges", "ij.plugin.filter.Filters(\"edge\")", 0, false);
        this.addPlugInItem(process, "Find Maxima...", "ij.plugin.filter.MaximumFinder", 0, false);
        this.addPlugInItem(process, "Enhance Contrast...", "ij.plugin.ContrastEnhancer", 0, false);
        Menus.getMenu("Process>Noise", true);
        Menus.getMenu("Process>Shadows", true);
        Menus.getMenu("Process>Binary", true);
        Menus.getMenu("Process>Math", true);
        Menus.getMenu("Process>FFT", true);
        Menu filtersMenu = Menus.getMenu("Process>Filters", true);
        process.addSeparator();
        Menus.getMenu("Process>Batch", true);
        this.addPlugInItem(process, "Image Calculator...", "ij.plugin.ImageCalculator", 0, false);
        this.addPlugInItem(process, "Subtract Background...", "ij.plugin.filter.BackgroundSubtracter", 0, false);
        Menus.addItem(process, "Repeat Command", 82, true);
        Menu analyzeMenu = Menus.getMenu("Analyze");
        this.addPlugInItem(analyzeMenu, "Measure", "ij.plugin.filter.Analyzer", 77, false);
        this.addPlugInItem(analyzeMenu, "Analyze Particles...", "ij.plugin.filter.ParticleAnalyzer", 0, false);
        this.addPlugInItem(analyzeMenu, "Summarize", "ij.plugin.filter.Analyzer(\"sum\")", 0, false);
        this.addPlugInItem(analyzeMenu, "Distribution...", "ij.plugin.Distribution", 0, false);
        this.addPlugInItem(analyzeMenu, "Label", "ij.plugin.filter.Filler(\"label\")", 0, false);
        this.addPlugInItem(analyzeMenu, "Clear Results", "ij.plugin.filter.Analyzer(\"clear\")", 0, false);
        this.addPlugInItem(analyzeMenu, "Set Measurements...", "ij.plugin.filter.Analyzer(\"set\")", 0, false);
        analyzeMenu.addSeparator();
        this.addPlugInItem(analyzeMenu, "Set Scale...", "ij.plugin.filter.ScaleDialog", 0, false);
        this.addPlugInItem(analyzeMenu, "Calibrate...", "ij.plugin.filter.Calibrator", 0, false);
        this.addPlugInItem(analyzeMenu, "Histogram", "ij.plugin.Histogram", 72, false);
        this.addPlugInItem(analyzeMenu, "Plot Profile", "ij.plugin.Profiler(\"plot\")", 75, false);
        this.addPlugInItem(analyzeMenu, "Surface Plot...", "ij.plugin.SurfacePlotter", 0, false);
        Menus.getMenu("Analyze>Gels", true);
        Menu toolsMenu = Menus.getMenu("Analyze>Tools", true);
        this.addPluginsMenu();
        Menu window = Menus.getMenu("Window");
        this.addPlugInItem(window, "Show All", "ij.plugin.WindowOrganizer(\"show\")", 93, false);
        String key = IJ.isWindows() ? "enter" : "return";
        this.addPlugInItem(window, "Main Window [" + key + "]", "ij.plugin.WindowOrganizer(\"imagej\")", 0, false);
        this.addPlugInItem(window, "Put Behind [tab]", "ij.plugin.Commands(\"tab\")", 0, false);
        this.addPlugInItem(window, "Cascade", "ij.plugin.WindowOrganizer(\"cascade\")", 0, false);
        this.addPlugInItem(window, "Tile", "ij.plugin.WindowOrganizer(\"tile\")", 0, false);
        window.addSeparator();
        Menu help = Menus.getMenu("Help");
        this.addPlugInItem(help, "ImageJ Website...", "ij.plugin.BrowserLauncher", 0, false);
        this.addPlugInItem(help, "ImageJ News...", "ij.plugin.BrowserLauncher(\"http://imagej.nih.gov/ij/notes.html\")", 0, false);
        this.addPlugInItem(help, "Documentation...", "ij.plugin.BrowserLauncher(\"http://imagej.nih.gov/ij/docs\")", 0, false);
        this.addPlugInItem(help, "Installation...", "ij.plugin.SimpleCommands(\"install\")", 0, false);
        this.addPlugInItem(help, "Mailing List...", "ij.plugin.BrowserLauncher(\"https://list.nih.gov/archives/imagej.html\")", 0, false);
        help.addSeparator();
        this.addPlugInItem(help, "Dev. Resources...", "ij.plugin.BrowserLauncher(\"http://imagej.nih.gov/ij/developer/index.html\")", 0, false);
        this.addPlugInItem(help, "Plugins...", "ij.plugin.BrowserLauncher(\"http://imagej.nih.gov/ij/plugins\")", 0, false);
        this.addPlugInItem(help, "Macros...", "ij.plugin.BrowserLauncher(\"http://imagej.nih.gov/ij/macros/\")", 0, false);
        this.addPlugInItem(help, "Macro Functions...", "ij.plugin.BrowserLauncher(\"http://imagej.nih.gov/ij/developer/macro/functions.html\")", 0, false);
        help.addSeparator();
        this.addPlugInItem(help, "Update ImageJ...", "ij.plugin.ImageJ_Updater", 0, false);
        this.addPlugInItem(help, "Refresh Menus", "ij.plugin.ImageJ_Updater(\"menus\")", 0, false);
        help.addSeparator();
        Menu aboutMenu = Menus.getMenu("Help>About Plugins", true);
        this.addPlugInItem(help, "About ImageJ...", "ij.plugin.AboutBox", 0, false);
        if (applet == null) {
            menuSeparators = new Properties();
            this.installPlugins();
        }
        file.addSeparator();
        this.addPlugInItem(file, "Quit", "ij.plugin.Commands(\"quit\")", 0, false);
        if (fontSize != 0) {
            mbar.setFont(Menus.getFont());
        }
        if (ij != null) {
            ij.setMenuBar(mbar);
        }
        if (this.pluginError != null) {
            String string = this.error = this.error != null ? (this.error = this.error + "\n" + this.pluginError) : this.pluginError;
        }
        if (this.jarError != null) {
            this.error = this.error != null ? (this.error = this.error + "\n" + this.jarError) : this.jarError;
        }
        return this.error;
    }

    void addOpenRecentSubMenu(Menu menu) {
        String path;
        openRecentMenu = Menus.getMenu("File>Open Recent");
        for (int i = 0; i < 15 && (path = Prefs.getString("recent" + i / 10 % 10 + i % 10)) != null; ++i) {
            MenuItem item = new MenuItem(path);
            openRecentMenu.add(item);
            item.addActionListener(ij);
        }
        menu.add(openRecentMenu);
    }

    static void addItem(Menu menu, String label, int shortcut, boolean shift) {
        MenuItem item;
        if (menu == null) {
            return;
        }
        if (shortcut == 0) {
            item = new MenuItem(label);
        } else if (shift) {
            item = new MenuItem(label, new MenuShortcut(shortcut, true));
            shortcuts.put(new Integer(shortcut + 200), label);
        } else {
            item = new MenuItem(label, new MenuShortcut(shortcut));
            shortcuts.put(new Integer(shortcut), label);
        }
        if (addSorted) {
            if (menu == pluginsMenu) {
                Menus.addItemSorted(menu, item, userPluginsIndex);
            } else {
                Menus.addOrdered(menu, item);
            }
        } else {
            menu.add(item);
        }
        item.addActionListener(ij);
    }

    void addPlugInItem(Menu menu, String label, String className, int shortcut, boolean shift) {
        pluginsTable.put(label, className);
        ++nPlugins;
        Menus.addItem(menu, label, shortcut, shift);
    }

    CheckboxMenuItem addCheckboxItem(Menu menu, String label, String className) {
        pluginsTable.put(label, className);
        ++nPlugins;
        CheckboxMenuItem item = new CheckboxMenuItem(label);
        menu.add(item);
        item.addItemListener(ij);
        item.setState(false);
        return item;
    }

    static Menu addSubMenu(Menu menu, String name) {
        String value;
        String key = name.toLowerCase(Locale.US);
        Menu submenu = new Menu(name.replace('_', ' '));
        int index = key.indexOf(32);
        if (index > 0) {
            key = key.substring(0, index);
        }
        for (int count = 1; count < 100 && (value = Prefs.getString(key + count / 10 % 10 + count % 10)) != null; ++count) {
            if (count == 1) {
                menu.add(submenu);
            }
            if (value.equals("-")) {
                submenu.addSeparator();
                continue;
            }
            Menus.addPluginItem(submenu, value);
        }
        if (name.equals("Lookup Tables") && applet == null) {
            Menus.addLuts(submenu);
        }
        return submenu;
    }

    static void addLuts(Menu submenu) {
        String path = IJ.getDirectory("luts");
        if (path == null) {
            return;
        }
        File f = new File(path);
        String[] list = null;
        if (applet == null && f.exists() && f.isDirectory()) {
            list = f.list();
        }
        if (list == null) {
            return;
        }
        if (IJ.isLinux()) {
            StringSorter.sort(list);
        }
        submenu.addSeparator();
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (!name.endsWith(".lut")) continue;
            name = name.substring(0, name.length() - 4);
            if (!isFiji && name.contains("_") && !name.contains(" ")) {
                name = name.replace("_", " ");
            }
            MenuItem item = new MenuItem(name);
            submenu.add(item);
            item.addActionListener(ij);
            ++nPlugins;
        }
    }

    static void addPluginItem(Menu submenu, String s) {
        int openBracket;
        if (s.startsWith("\"-\"")) {
            Menus.addSeparator(submenu);
            return;
        }
        int lastComma = s.lastIndexOf(44);
        if (lastComma <= 0) {
            return;
        }
        String command = s.substring(1, lastComma - 1);
        int keyCode = 0;
        boolean shift = false;
        if (command.endsWith("]") && (openBracket = command.lastIndexOf(91)) > 0) {
            boolean functionKey;
            String shortcut = command.substring(openBracket + 1, command.length() - 1);
            keyCode = Menus.convertShortcutToCode(shortcut);
            boolean bl = functionKey = keyCode >= 112 && keyCode <= 123;
            if (keyCode > 0 && !functionKey) {
                command = command.substring(0, openBracket);
            }
        }
        if (keyCode >= 112 && keyCode <= 123) {
            shortcuts.put(new Integer(keyCode), command);
            keyCode = 0;
        } else if (keyCode >= 265 && keyCode <= 290) {
            keyCode -= 200;
            shift = true;
        }
        Menus.addItem(submenu, command, keyCode, shift);
        while (s.charAt(lastComma + 1) == ' ' && lastComma + 2 < s.length()) {
            ++lastComma;
        }
        String className = s.substring(lastComma + 1, s.length());
        if (installingJars) {
            duplicateCommand = pluginsTable.get(command) != null;
        }
        pluginsTable.put(command, className);
        ++nPlugins;
    }

    void checkForDuplicate(String command) {
        if (pluginsTable.get(command) != null) {
            // empty if block
        }
    }

    void addPluginsMenu() {
        String value;
        pluginsMenu = Menus.getMenu("Plugins");
        for (int count = 1; count < 100 && (value = Prefs.getString("plug-in" + count / 10 % 10 + count % 10)) != null; ++count) {
            char firstChar = value.charAt(0);
            if (firstChar == '-') {
                pluginsMenu.addSeparator();
                continue;
            }
            if (firstChar == '>') {
                String submenu = value.substring(2, value.length() - 1);
                Menu menu = Menus.addSubMenu(pluginsMenu, submenu);
                if (submenu.equals("Shortcuts")) {
                    shortcutsMenu = menu;
                    continue;
                }
                if (submenu.equals("Utilities")) {
                    utilitiesMenu = menu;
                    continue;
                }
                if (!submenu.equals("Macros")) continue;
                macrosMenu = menu;
                continue;
            }
            Menus.addPluginItem(pluginsMenu, value);
        }
        userPluginsIndex = pluginsMenu.getItemCount();
        if (userPluginsIndex < 0) {
            userPluginsIndex = 0;
        }
    }

    void installPlugins() {
        String value;
        String[] pluginList = Menus.getPlugins();
        String[] pluginsList2 = null;
        Hashtable<String, String> skipList = new Hashtable<String, String>();
        for (int index = 0; index < 100 && (value = Prefs.getString("plugin" + index / 10 % 10 + index % 10)) != null; ++index) {
            int argStart;
            Menu menu;
            char menuCode = value.charAt(0);
            switch (menuCode) {
                default: {
                    menu = pluginsMenu;
                    break;
                }
                case 'i': {
                    menu = Menus.getMenu("File>Import");
                    break;
                }
                case 's': {
                    menu = Menus.getMenu("File>Save As");
                    break;
                }
                case 'h': {
                    menu = shortcutsMenu;
                    break;
                }
                case 'a': {
                    menu = Menus.getMenu("Help>About Plugins");
                    break;
                }
                case 'f': {
                    menu = Menus.getMenu("Process>Filters");
                    break;
                }
                case 't': {
                    menu = Menus.getMenu("Analyze>Tools");
                    break;
                }
                case 'u': {
                    menu = utilitiesMenu;
                }
            }
            String prefsValue = value;
            value = value.substring(2, value.length());
            String className = value.substring(value.lastIndexOf(44) + 1, value.length());
            boolean found = className.startsWith("ij.");
            if (!found && pluginList != null) {
                if (pluginsList2 == null) {
                    pluginsList2 = this.getStrippedPlugins(pluginList);
                }
                for (int i = 0; i < pluginsList2.length; ++i) {
                    if (!className.startsWith(pluginsList2[i])) continue;
                    found = true;
                    break;
                }
            }
            if (!found || menu == pluginsMenu) continue;
            Menus.addPluginItem(menu, value);
            pluginsPrefs.addElement(prefsValue);
            if (className.endsWith("\")") && (argStart = className.lastIndexOf("(\"")) > 0) {
                className = className.substring(0, argStart);
            }
            skipList.put(className, "");
        }
        if (pluginList != null) {
            for (int i = 0; i < pluginList.length; ++i) {
                if (skipList.containsKey(pluginList[i])) continue;
                this.installUserPlugin(pluginList[i]);
            }
        }
        this.installJarPlugins();
        this.installMacros();
    }

    void installMacros() {
        if (macroFiles == null) {
            return;
        }
        for (int i = 0; i < macroFiles.size(); ++i) {
            String name = (String)macroFiles.elementAt(i);
            this.installMacro(name);
        }
    }

    void installMacro(String name) {
        String command;
        Menu menu = pluginsMenu;
        String dir = null;
        int slashIndex = name.indexOf(47);
        if (slashIndex > 0) {
            dir = name.substring(0, slashIndex);
            name = name.substring(slashIndex + 1, name.length());
            menu = this.getPluginsSubmenu(dir);
            slashIndex = name.indexOf(47);
            if (slashIndex > 0) {
                String dir2 = name.substring(0, slashIndex);
                name = name.substring(slashIndex + 1, name.length());
                String menuName = "Plugins>" + dir + ">" + dir2;
                menu = Menus.getMenu(menuName);
                dir = dir + File.separator + dir2;
            }
        }
        command = (command = name.replace('_', ' ')).endsWith(".js") || command.endsWith(".py") ? command.substring(0, command.length() - 3) : command.substring(0, command.length() - 4);
        command.trim();
        if (pluginsTable.get(command) != null) {
            command = command + " Macro";
        }
        MenuItem item = new MenuItem(command);
        Menus.addOrdered(menu, item);
        item.addActionListener(ij);
        String path = (dir != null ? dir + File.separator : "") + name;
        pluginsTable.put(command, "ij.plugin.Macro_Runner(\"" + path + "\")");
        ++nMacros;
    }

    static int addPluginSeparatorIfNeeded(Menu menu) {
        if (menuSeparators == null) {
            return 0;
        }
        Integer i = (Integer)menuSeparators.get(menu);
        if (i == null) {
            if (menu.getItemCount() > 0) {
                Menus.addSeparator(menu);
            }
            i = new Integer(menu.getItemCount());
            menuSeparators.put(menu, i);
        }
        return i;
    }

    static void addOrdered(Menu menu, MenuItem item) {
        int start;
        String label = item.getLabel();
        for (int i = start = Menus.addPluginSeparatorIfNeeded(menu); i < menu.getItemCount(); ++i) {
            if (label.compareTo(menu.getItem(i).getLabel()) >= 0) continue;
            menu.insert(item, i);
            return;
        }
        menu.add(item);
    }

    public static String getJarFileForMenuEntry(String menuEntry) {
        if (instance == null) {
            return null;
        }
        return (String)Menus.instance.menuEntry2jarFile.get(menuEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void installJarPlugins() {
        if (jarFiles == null) {
            return;
        }
        installingJars = true;
        for (int i = 0; i < jarFiles.size(); ++i) {
            this.isJarErrorHeading = false;
            String jar = (String)jarFiles.elementAt(i);
            InputStream is = this.getConfigurationFile(jar);
            if (is == null) continue;
            int maxEntries = 100;
            String[] entries = new String[maxEntries];
            int nEntries = 0;
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
            try {
                String s;
                while ((s = lnr.readLine()) != null) {
                    if (nEntries == maxEntries - 1) {
                        break;
                    }
                    if (s.length() < 3 || s.startsWith("#")) continue;
                    entries[nEntries++] = s;
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (lnr != null) {
                        lnr.close();
                    }
                }
                catch (IOException e) {}
            }
            for (int j = 0; j < nEntries; ++j) {
                this.installJarPlugin(jar, entries[j]);
            }
        }
    }

    void installJarPlugin(String jar, String s) {
        int comma;
        int firstQuote;
        String name;
        Menu menu;
        addSorted = false;
        if ((s = s.trim()).startsWith("Plugins>")) {
            int firstComma = s.indexOf(44);
            if (firstComma == -1 || firstComma <= 8) {
                menu = null;
            } else {
                name = s.substring(8, firstComma);
                menu = this.getPluginsSubmenu(name);
            }
        } else if (s.startsWith("\"") || s.startsWith("Plugins")) {
            String name2 = this.getSubmenuName(jar);
            menu = name2 != null ? this.getPluginsSubmenu(name2) : pluginsMenu;
            addSorted = true;
        } else {
            firstQuote = s.indexOf(34);
            name = firstQuote < 0 ? s : s.substring(0, firstQuote).trim();
            comma = name.indexOf(44);
            if (comma >= 0) {
                name = name.substring(0, comma);
            }
            if (name.startsWith("Help>About")) {
                name = "Help>About Plugins";
            }
            menu = Menus.getMenu(name);
        }
        firstQuote = s.indexOf(34);
        if (firstQuote == -1) {
            return;
        }
        s = s.substring(firstQuote, s.length());
        if (menu != null) {
            Menus.addPluginSeparatorIfNeeded(menu);
            Menus.addPluginItem(menu, s);
            addSorted = false;
        }
        String menuEntry = s;
        if (s.startsWith("\"")) {
            int quote = s.indexOf(34, 1);
            menuEntry = quote < 0 ? s.substring(1) : s.substring(1, quote);
        } else {
            comma = s.indexOf(44);
            if (comma > 0) {
                menuEntry = s.substring(0, comma);
            }
        }
        if (duplicateCommand) {
            if (this.jarError == null) {
                this.jarError = "";
            }
            this.addJarErrorHeading(jar);
            String jar2 = (String)this.menuEntry2jarFile.get(menuEntry);
            if (jar2 != null && jar2.startsWith(pluginsPath)) {
                jar2 = jar2.substring(pluginsPath.length());
            }
            this.jarError = this.jarError + "    Duplicate command: " + s + (jar2 != null ? " (already in " + jar2 + ")" : "") + "\n";
        } else {
            this.menuEntry2jarFile.put(menuEntry, jar);
        }
        duplicateCommand = false;
    }

    void addJarErrorHeading(String jar) {
        if (!this.isJarErrorHeading) {
            if (!this.jarError.equals("")) {
                this.jarError = this.jarError + " \n";
            }
            this.jarError = this.jarError + "Plugin configuration error: " + jar + "\n";
            this.isJarErrorHeading = true;
        }
    }

    public static Menu getImageJMenu(String menuPath) {
        if (menus.get(menuPath) != null) {
            return Menus.getMenu(menuPath, false);
        }
        return null;
    }

    private static Menu getMenu(String menuPath) {
        return Menus.getMenu(menuPath, false);
    }

    private static Menu getMenu(String menuName, boolean readFromProps) {
        Menu result;
        if (menuName.endsWith(">")) {
            menuName = menuName.substring(0, menuName.length() - 1);
        }
        if ((result = (Menu)menus.get(menuName)) == null) {
            int offset = menuName.lastIndexOf(62);
            if (offset < 0) {
                result = new Menu(menuName);
                if (mbar == null) {
                    mbar = new MenuBar();
                }
                if (menuName.equals("Help")) {
                    mbar.setHelpMenu(result);
                } else {
                    mbar.add(result);
                }
                if (menuName.equals("Window")) {
                    window = result;
                } else if (menuName.equals("Plugins")) {
                    pluginsMenu = result;
                }
            } else {
                String parentName = menuName.substring(0, offset);
                String menuItemName = menuName.substring(offset + 1);
                Menu parentMenu = Menus.getMenu(parentName);
                result = new Menu(menuItemName);
                Menus.addPluginSeparatorIfNeeded(parentMenu);
                if (readFromProps) {
                    result = Menus.addSubMenu(parentMenu, menuItemName);
                } else if (parentName.startsWith("Plugins") && menuSeparators != null) {
                    Menus.addItemSorted(parentMenu, result, parentName.equals("Plugins") ? userPluginsIndex : 0);
                } else {
                    parentMenu.add(result);
                }
                if (menuName.equals("File>Open Recent")) {
                    openRecentMenu = result;
                }
            }
            menus.put(menuName, result);
        }
        return result;
    }

    Menu getPluginsSubmenu(String submenuName) {
        return Menus.getMenu("Plugins>" + submenuName);
    }

    String getSubmenuName(String jarPath) {
        int index;
        if (pluginsPath == null) {
            return null;
        }
        if (jarPath.startsWith(pluginsPath)) {
            jarPath = jarPath.substring(pluginsPath.length() - 1);
        }
        if ((index = jarPath.lastIndexOf(File.separatorChar)) < 0) {
            return null;
        }
        String name = jarPath.substring(0, index);
        if ((index = name.lastIndexOf(File.separatorChar)) < 0) {
            return null;
        }
        if ((name = name.substring(index + 1)).equals("plugins")) {
            return null;
        }
        return name;
    }

    static void addItemSorted(Menu menu, MenuItem item, int startingIndex) {
        String itemLabel = item.getLabel();
        int count = menu.getItemCount();
        boolean inserted = false;
        for (int i = startingIndex; i < count; ++i) {
            MenuItem mi = menu.getItem(i);
            String label = mi.getLabel();
            if (itemLabel.compareTo(label) >= 0) continue;
            menu.insert(item, i);
            inserted = true;
            break;
        }
        if (!inserted) {
            menu.add(item);
        }
    }

    static void addSeparator(Menu menu) {
        menu.addSeparator();
    }

    InputStream getConfigurationFile(String jar) {
        try {
            ZipFile jarFile = new ZipFile(jar);
            Enumeration<? extends ZipEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().endsWith("plugins.config")) continue;
                return jarFile.getInputStream(entry);
            }
        }
        catch (Throwable e) {
            IJ.log(jar + ": " + e);
        }
        return this.autoGenerateConfigFile(jar);
    }

    InputStream autoGenerateConfigFile(String jar) {
        StringBuffer sb = null;
        try {
            ZipFile jarFile = new ZipFile(jar);
            Enumeration<? extends ZipEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class") || name.indexOf("_") <= 0 || name.indexOf("$") != -1 || name.indexOf("/_") != -1 || name.startsWith("_") || Character.isLowerCase(name.charAt(0)) && name.indexOf("/") != -1) continue;
                if (sb == null) {
                    sb = new StringBuffer();
                }
                String className = name.substring(0, name.length() - 6);
                int slashIndex = className.lastIndexOf(47);
                String plugins = "Plugins";
                if (slashIndex >= 0) {
                    plugins = plugins + ">" + className.substring(0, slashIndex).replace('/', '>').replace('_', ' ');
                    name = className.substring(slashIndex + 1);
                } else {
                    name = className;
                }
                name = name.replace('_', ' ');
                className = className.replace('/', '.');
                sb.append(plugins + ", \"" + name + "\", " + className + "\n");
            }
        }
        catch (Throwable e) {
            IJ.log(jar + ": " + e);
        }
        if (sb == null) {
            return null;
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    String[] getStrippedPlugins(String[] plugins) {
        String[] plugins2 = new String[plugins.length];
        for (int i = 0; i < plugins2.length; ++i) {
            plugins2[i] = plugins[i];
            int slashPos = plugins2[i].lastIndexOf(47);
            if (slashPos < 0) continue;
            plugins2[i] = plugins[i].substring(slashPos + 1, plugins2[i].length());
        }
        return plugins2;
    }

    void setupPluginsAndMacrosPaths() {
        File f;
        macrosPath = null;
        pluginsPath = null;
        ImageJPath = null;
        String currentDir = Prefs.getHomeDir();
        if (currentDir == null) {
            return;
        }
        if (currentDir.endsWith("plugins")) {
            ImageJPath = pluginsPath = currentDir + File.separator;
        } else {
            String pluginsDir = System.getProperty("plugins.dir");
            if (pluginsDir != null) {
                if (pluginsDir.endsWith("/") || pluginsDir.endsWith("\\")) {
                    pluginsDir = pluginsDir.substring(0, pluginsDir.length() - 1);
                }
                if (pluginsDir.endsWith("/plugins") || pluginsDir.endsWith("\\plugins")) {
                    pluginsDir = pluginsDir.substring(0, pluginsDir.length() - 8);
                }
            }
            if (pluginsDir == null) {
                pluginsDir = currentDir;
            } else if (pluginsDir.equals("user.home")) {
                pluginsDir = System.getProperty("user.home");
                if (!new File(pluginsDir + File.separator + "plugins").isDirectory()) {
                    pluginsDir = pluginsDir + File.separator + "ImageJ";
                }
                if (applet == null) {
                    System.setSecurityManager(null);
                }
                jnlp = true;
            }
            pluginsPath = pluginsDir + File.separator + "plugins" + File.separator;
            macrosPath = pluginsDir + File.separator + "macros" + File.separator;
            ImageJPath = pluginsDir + File.separator;
        }
        File file = f = pluginsPath != null ? new File(pluginsPath) : null;
        if (!(f != null && f.isDirectory() || (f = new File(pluginsPath = (ImageJPath = currentDir + File.separator) + "plugins" + File.separator)).isDirectory())) {
            String altPluginsPath = System.getProperty("plugins.dir");
            if (altPluginsPath != null) {
                f = new File(altPluginsPath);
                if (!f.isDirectory()) {
                    altPluginsPath = null;
                } else {
                    ImageJPath = f.getParent() + File.separator;
                    pluginsPath = ImageJPath + f.getName() + File.separator;
                    macrosPath = ImageJPath + "macros" + File.separator;
                }
            }
            if (altPluginsPath == null) {
                pluginsPath = null;
                ImageJPath = null;
            }
        }
        File file2 = f = macrosPath != null ? new File(macrosPath) : null;
        if (f != null && !f.isDirectory() && !(f = new File(macrosPath = currentDir + File.separator + "macros" + File.separator)).isDirectory()) {
            macrosPath = null;
        }
        if (IJ.debugMode) {
            IJ.log("Menus.setupPluginsAndMacrosPaths");
            IJ.log("   user.dir: " + currentDir);
            IJ.log("   plugins.dir: " + System.getProperty("plugins.dir"));
            IJ.log("   ImageJPath: " + ImageJPath);
            IJ.log("   pluginsPath: " + pluginsPath);
        }
    }

    public static synchronized String[] getPlugins() {
        File f;
        File file = f = pluginsPath != null ? new File(pluginsPath) : null;
        if (f == null || f != null && !f.isDirectory()) {
            return null;
        }
        Object[] list = f.list();
        if (list == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        jarFiles = null;
        macroFiles = null;
        for (int i = 0; i < list.length; ++i) {
            boolean hasUnderscore;
            String name = list[i];
            boolean isClassFile = name.endsWith(".class");
            boolean bl = hasUnderscore = name.indexOf(95) >= 0;
            if (hasUnderscore && isClassFile && name.indexOf(36) < 0) {
                name = name.substring(0, name.length() - 6);
                v.addElement(name);
                continue;
            }
            if (hasUnderscore && (name.endsWith(".jar") || name.endsWith(".zip"))) {
                if (jarFiles == null) {
                    jarFiles = new Vector();
                }
                jarFiles.addElement(pluginsPath + name);
                continue;
            }
            if (Menus.validMacroName(name, hasUnderscore)) {
                if (macroFiles == null) {
                    macroFiles = new Vector();
                }
                macroFiles.addElement(name);
                continue;
            }
            if (isClassFile) continue;
            Menus.checkSubdirectory(pluginsPath, name, v);
        }
        list = new String[v.size()];
        v.copyInto(list);
        StringSorter.sort((String[])list);
        return list;
    }

    private static void checkSubdirectory(String path, String dir, Vector v) {
        if (dir.endsWith(".java")) {
            return;
        }
        File f = new File(path, dir);
        if (!f.isDirectory()) {
            return;
        }
        String[] list = f.list();
        if (list == null) {
            return;
        }
        dir = dir + "/";
        int classCount = 0;
        int otherCount = 0;
        String className = null;
        for (int i = 0; i < list.length; ++i) {
            boolean hasUnderscore;
            String name = list[i];
            boolean bl = hasUnderscore = name.indexOf(95) >= 0;
            if (hasUnderscore && name.endsWith(".class") && name.indexOf(36) < 0) {
                name = name.substring(0, name.length() - 6);
                v.addElement(dir + name);
                ++classCount;
                className = name;
                continue;
            }
            if (hasUnderscore && (name.endsWith(".jar") || name.endsWith(".zip"))) {
                if (jarFiles == null) {
                    jarFiles = new Vector();
                }
                jarFiles.addElement(f.getPath() + File.separator + name);
                ++otherCount;
                continue;
            }
            if (Menus.validMacroName(name, hasUnderscore)) {
                if (macroFiles == null) {
                    macroFiles = new Vector();
                }
                macroFiles.addElement(dir + name);
                ++otherCount;
                continue;
            }
            File f2 = new File(f, name);
            if (!f2.isDirectory()) continue;
            Menus.installSubdirectorMacros(f2, dir + name);
        }
        if (Prefs.moveToMisc && classCount == 1 && otherCount == 0 && dir.indexOf("_") == -1) {
            v.setElementAt("Miscellaneous/" + className, v.size() - 1);
        }
    }

    private static void installSubdirectorMacros(File f2, String dir) {
        if (dir.endsWith("Launchers")) {
            return;
        }
        String[] list = f2.list();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            boolean hasUnderscore;
            String name = list[i];
            boolean bl = hasUnderscore = name.indexOf(95) >= 0;
            if (!Menus.validMacroName(name, hasUnderscore)) continue;
            if (macroFiles == null) {
                macroFiles = new Vector();
            }
            macroFiles.addElement(dir + "/" + name);
        }
    }

    private static boolean validMacroName(String name, boolean hasUnderscore) {
        return hasUnderscore && name.endsWith(".txt") || name.endsWith(".ijm") || name.endsWith(".js") || name.endsWith(".bsh") && !isFiji || name.endsWith(".py") && !isFiji;
    }

    void installUserPlugin(String className) {
        this.installUserPlugin(className, false);
    }

    public void installUserPlugin(String className, boolean force) {
        boolean itemExists;
        int slashIndex = className.indexOf(47);
        String menuName = slashIndex < 0 ? "Plugins" : "Plugins>" + className.substring(0, slashIndex).replace('/', '>');
        Menu menu = Menus.getMenu(menuName);
        String command = className;
        if (slashIndex > 0) {
            command = className.substring(slashIndex + 1);
        }
        command = command.replace('_', ' ');
        command.trim();
        boolean bl = itemExists = pluginsTable.get(command) != null;
        if (force && itemExists) {
            return;
        }
        if (!force && itemExists) {
            command = command + " Plugin";
        }
        MenuItem item = new MenuItem(command);
        if (force) {
            Menus.addItemSorted(menu, item, 0);
        } else {
            Menus.addOrdered(menu, item);
        }
        item.addActionListener(ij);
        pluginsTable.put(command, className.replace('/', '.'));
        ++nPlugins;
    }

    void installPopupMenu(ImageJ ij) {
        String s;
        int count = 0;
        popup = new PopupMenu("");
        if (fontSize != 0) {
            popup.setFont(Menus.getFont());
        }
        while ((s = Prefs.getString("popup" + ++count / 10 % 10 + count % 10)) != null) {
            if (s.equals("-")) {
                popup.addSeparator();
                continue;
            }
            if (s.equals("")) continue;
            MenuItem mi = new MenuItem(s);
            mi.addActionListener(ij);
            popup.add(mi);
        }
    }

    public static MenuBar getMenuBar() {
        return mbar;
    }

    public static Menu getMacrosMenu() {
        return macrosMenu;
    }

    public static Menu getOpenRecentMenu() {
        return openRecentMenu;
    }

    public int getMacroCount() {
        return nMacros;
    }

    public int getPluginCount() {
        return nPlugins;
    }

    public static void updateMenus() {
        ImageProcessor ip;
        if (ij == null) {
            return;
        }
        gray8Item.setState(false);
        gray16Item.setState(false);
        gray32Item.setState(false);
        color256Item.setState(false);
        colorRGBItem.setState(false);
        RGBStackItem.setState(false);
        HSBStackItem.setState(false);
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        int type = imp.getType();
        if (imp.getStackSize() > 1) {
            ImageStack stack = imp.getStack();
            if (stack.isRGB()) {
                type = 10;
            } else if (stack.isHSB()) {
                type = 11;
            }
        }
        if (type == 0 && (ip = imp.getProcessor()) != null && ip.getMinThreshold() == -808080.0 && ip.isColorLut() && !ip.isPseudoColorLut()) {
            type = 3;
            imp.setType(3);
        }
        switch (type) {
            case 0: {
                gray8Item.setState(true);
                break;
            }
            case 1: {
                gray16Item.setState(true);
                break;
            }
            case 2: {
                gray32Item.setState(true);
                break;
            }
            case 3: {
                color256Item.setState(true);
                break;
            }
            case 4: {
                colorRGBItem.setState(true);
                break;
            }
            case 10: {
                RGBStackItem.setState(true);
                break;
            }
            case 11: {
                HSBStackItem.setState(true);
            }
        }
        int nItems = window.getItemCount();
        int start = 6 + windowMenuItems2;
        int index = start + WindowManager.getCurrentIndex();
        try {
            for (int i = start; i < nItems; ++i) {
                CheckboxMenuItem item = (CheckboxMenuItem)window.getItem(i);
                item.setState(i == index);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    static boolean isColorLut(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        IndexColorModel cm = (IndexColorModel)ip.getColorModel();
        if (cm == null) {
            return false;
        }
        int mapSize = cm.getMapSize();
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        cm.getReds(reds);
        cm.getGreens(greens);
        cm.getBlues(blues);
        boolean isColor = false;
        for (int i = 0; i < mapSize; ++i) {
            if (reds[i] == greens[i] && greens[i] == blues[i]) continue;
            isColor = true;
            break;
        }
        return isColor;
    }

    static String getImageJPath() {
        return ImageJPath;
    }

    public static String getPlugInsPath() {
        return pluginsPath;
    }

    public static String getMacrosPath() {
        return macrosPath;
    }

    public static Hashtable getCommands() {
        return pluginsTable;
    }

    public static Hashtable getShortcuts() {
        return shortcuts;
    }

    public static Hashtable getMacroShortcuts() {
        if (macroShortcuts == null) {
            macroShortcuts = new Hashtable();
        }
        return macroShortcuts;
    }

    static synchronized void insertWindowMenuItem(Window win) {
        if (ij == null || win == null) {
            return;
        }
        String title = win instanceof Frame ? ((Frame)win).getTitle() : ((Dialog)win).getTitle();
        CheckboxMenuItem item = new CheckboxMenuItem(title);
        item.addItemListener(ij);
        int index = 6 + windowMenuItems2;
        if (windowMenuItems2 >= 2) {
            --index;
        }
        window.insert(item, index);
        if (++windowMenuItems2 == 1) {
            window.insertSeparator(6 + windowMenuItems2);
            ++windowMenuItems2;
        }
    }

    static synchronized void addWindowMenuItem(ImagePlus imp) {
        if (ij == null) {
            return;
        }
        String name = imp.getTitle();
        int size = imp.getWidth() * imp.getHeight() * imp.getStackSize() / 1024;
        switch (imp.getType()) {
            case 2: 
            case 4: {
                size *= 4;
                break;
            }
            case 1: {
                size *= 2;
                break;
            }
        }
        CheckboxMenuItem item = new CheckboxMenuItem(name + " " + size + "K");
        item.setActionCommand("" + imp.getID());
        window.add(item);
        item.addItemListener(ij);
    }

    static synchronized void removeWindowMenuItem(int index) {
        if (ij == null) {
            return;
        }
        try {
            if (index >= 0 && index < window.getItemCount()) {
                window.remove(6 + index);
                if (index < windowMenuItems2 && --windowMenuItems2 == 1) {
                    window.remove(6);
                    windowMenuItems2 = 0;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void updateWindowMenuItem(String oldLabel, String newLabel) {
        if (oldLabel == null || oldLabel.equals(newLabel)) {
            return;
        }
        int first = 6;
        int last = window.getItemCount() - 1;
        try {
            for (int i = first; i <= last; ++i) {
                int index;
                MenuItem item = window.getItem(i);
                String label = item.getLabel();
                if (item == null || !label.startsWith(oldLabel)) continue;
                if (label.endsWith("K") && (index = label.lastIndexOf(32)) > -1) {
                    newLabel = newLabel + label.substring(index, label.length());
                }
                item.setLabel(newLabel);
                return;
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public static synchronized void addOpenRecentItem(String path) {
        if (ij == null) {
            return;
        }
        int count = openRecentMenu.getItemCount();
        int i = 0;
        while (i < count) {
            if (openRecentMenu.getItem(i).getLabel().equals(path)) {
                openRecentMenu.remove(i);
                --count;
                continue;
            }
            ++i;
        }
        if (count == 15) {
            openRecentMenu.remove(14);
        }
        MenuItem item = new MenuItem(path);
        openRecentMenu.insert(item, 0);
        item.addActionListener(ij);
    }

    public static PopupMenu getPopupMenu() {
        return popup;
    }

    public static Menu getSaveAsMenu() {
        return saveAsMenu;
    }

    public static int installPlugin(String plugin, char menuCode, String command, String shortcut, ImageJ ij) {
        MenuItem item;
        boolean functionKey;
        Menu menu;
        if (command.equals("")) {
            return 0;
        }
        if (Menus.commandInUse(command)) {
            return -1;
        }
        if (!Menus.validShortcut(shortcut)) {
            return -2;
        }
        if (Menus.shortcutInUse(shortcut)) {
            return -3;
        }
        switch (menuCode) {
            case 'p': {
                menu = pluginsMenu;
                break;
            }
            case 'i': {
                menu = Menus.getMenu("File>Import");
                break;
            }
            case 's': {
                menu = Menus.getMenu("File>Save As");
                break;
            }
            case 'h': {
                menu = shortcutsMenu;
                break;
            }
            case 'a': {
                menu = Menus.getMenu("Help>About Plugins");
                break;
            }
            case 'f': {
                menu = Menus.getMenu("Process>Filters");
                break;
            }
            case 't': {
                menu = Menus.getMenu("Analyze>Tools");
                break;
            }
            case 'u': {
                menu = utilitiesMenu;
                break;
            }
            default: {
                return 0;
            }
        }
        int code = Menus.convertShortcutToCode(shortcut);
        boolean bl = functionKey = code >= 112 && code <= 123;
        if (code == 0) {
            item = new MenuItem(command);
        } else if (functionKey) {
            command = command + " [F" + (code - 112 + 1) + "]";
            shortcuts.put(new Integer(code), command);
            item = new MenuItem(command);
        } else {
            shortcuts.put(new Integer(code), command);
            int keyCode = code;
            boolean shift = false;
            if (keyCode >= 265 && keyCode <= 290) {
                keyCode -= 200;
                shift = true;
            }
            item = new MenuItem(command, new MenuShortcut(keyCode, shift));
        }
        menu.add(item);
        item.addActionListener(ij);
        pluginsTable.put(command, plugin);
        shortcut = code > 0 && !functionKey ? "[" + shortcut + "]" : "";
        pluginsPrefs.addElement(menuCode + ",\"" + command + shortcut + "\"," + plugin);
        return 0;
    }

    public static int uninstallPlugin(String command) {
        boolean found = false;
        Enumeration en = pluginsPrefs.elements();
        while (en.hasMoreElements()) {
            String cmd = (String)en.nextElement();
            if (cmd.indexOf(command) <= 0) continue;
            pluginsPrefs.removeElement(cmd);
            found = true;
            break;
        }
        if (found) {
            return 0;
        }
        return -5;
    }

    public static boolean commandInUse(String command) {
        return pluginsTable.get(command) != null;
    }

    public static int convertShortcutToCode(String shortcut) {
        int code = 0;
        int len = shortcut.length();
        if (len == 2 && shortcut.charAt(0) == 'F') {
            code = 112 + shortcut.charAt(1) - 49;
            if (code >= 112 && code <= 120) {
                return code;
            }
            return 0;
        }
        if (len == 3 && shortcut.charAt(0) == 'F') {
            code = 121 + shortcut.charAt(2) - 48;
            if (code >= 121 && code <= 123) {
                return code;
            }
            return 0;
        }
        if (len == 2 && shortcut.charAt(0) == 'N') {
            code = 96 + shortcut.charAt(1) - 48;
            if (code >= 96 && code <= 105) {
                return code;
            }
            switch (shortcut.charAt(1)) {
                case '/': {
                    return 111;
                }
                case '*': {
                    return 106;
                }
                case '-': {
                    return 109;
                }
                case '+': {
                    return 107;
                }
                case '.': {
                    return 110;
                }
            }
            return 0;
        }
        if (len != 1) {
            return 0;
        }
        char c = shortcut.charAt(0);
        if (c >= 'A' && c <= 'Z') {
            code = 65 + c - 65 + 200;
        } else if (c >= 'a' && c <= 'z') {
            code = 65 + c - 97;
        } else if (c >= '0' && c <= '9') {
            code = 48 + c - 48;
        }
        return code;
    }

    void installStartupMacroSet() {
        if (applet != null) {
            int index;
            String docBase = "" + applet.getDocumentBase();
            if (!docBase.endsWith("/") && (index = docBase.lastIndexOf("/")) != -1) {
                docBase = docBase.substring(0, index + 1);
            }
            IJ.runPlugIn("ij.plugin.URLOpener", docBase + "StartupMacros.txt");
            return;
        }
        if (macrosPath == null) {
            try {
                new MacroInstaller().installFromIJJar("/macros/StartupMacros.txt");
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        String path = macrosPath + "StartupMacros.txt";
        File f = new File(path);
        if (!f.exists() && !(f = new File(path = macrosPath + "StartupMacros.ijm")).exists()) {
            new MacroInstaller().installFromIJJar("/macros/StartupMacros.txt");
            return;
        }
        String libraryPath = macrosPath + "Library.txt";
        f = new File(libraryPath);
        boolean isLibrary = f.exists();
        try {
            MacroInstaller mi = new MacroInstaller();
            if (isLibrary) {
                mi.installLibrary(libraryPath);
            }
            mi.installFile(path);
            nMacros += mi.getMacroCount();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    static boolean validShortcut(String shortcut) {
        int len = shortcut.length();
        if (shortcut.equals("")) {
            return true;
        }
        if (len == 1) {
            return true;
        }
        return shortcut.startsWith("F") && (len == 2 || len == 3);
    }

    public static boolean shortcutInUse(String shortcut) {
        int code = Menus.convertShortcutToCode(shortcut);
        return shortcuts.get(new Integer(code)) != null;
    }

    public static void setFontSize(int size) {
        if (size < 9 && size != 0) {
            size = 9;
        }
        if (size > 24) {
            size = 24;
        }
        fontSize = size;
    }

    public static int getFontSize() {
        return IJ.isMacintosh() ? 0 : fontSize;
    }

    public static Font getFont() {
        if (menuFont == null) {
            menuFont = new Font("SanSerif", 0, fontSize == 0 ? 12 : fontSize);
        }
        return menuFont;
    }

    public static void savePreferences(Properties prefs) {
        int index = 0;
        Enumeration en = pluginsPrefs.elements();
        while (en.hasMoreElements()) {
            String key = "plugin" + index / 10 % 10 + index % 10;
            String value = (String)en.nextElement();
            prefs.put(key, value);
            ++index;
        }
        int n = openRecentMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            String key = "" + i;
            if (key.length() == 1) {
                key = "0" + key;
            }
            key = "recent" + key;
            prefs.put(key, openRecentMenu.getItem(i).getLabel());
        }
        prefs.put("menu.size", Integer.toString(fontSize));
    }

    public static void updateImageJMenus() {
        macroFiles = null;
        jarFiles = null;
        Menus m = new Menus(IJ.getInstance(), IJ.getApplet());
        String err = m.addMenuBar();
        if (err != null) {
            IJ.error(err);
        }
        IJ.resetClassLoader();
        IJ.runPlugIn("ij.plugin.ClassChecker", "");
        IJ.showStatus("Menus updated: " + nPlugins + " commands, " + nMacros + " macros");
    }

    static {
        defaultFontSize = IJ.isWindows() ? 15 : 0;
        fontSize = Prefs.getInt("menu.size", defaultFontSize);
    }
}

