/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImageJ;
import ij.macro.Interpreter;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class ProgressBar
extends Canvas {
    private int canvasWidth;
    private int canvasHeight;
    private int x;
    private int y;
    private int width;
    private int height;
    private double percent;
    private long lastTime = 0L;
    private boolean showBar;
    private boolean batchMode;
    private Color barColor = Color.gray;
    private Color fillColor = new Color(204, 204, 255);
    private Color backgroundColor = ImageJ.backgroundColor;
    private Color frameBrighter = this.backgroundColor.brighter();
    private Color frameDarker = this.backgroundColor.darker();

    public ProgressBar(int canvasWidth, int canvasHeight) {
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.x = 3;
        this.y = 5;
        this.width = canvasWidth - 8;
        this.height = canvasHeight - 7;
    }

    void fill3DRect(Graphics g, int x, int y, int width, int height) {
        g.setColor(this.fillColor);
        g.fillRect(x + 1, y + 1, width - 2, height - 2);
        g.setColor(this.frameDarker);
        g.drawLine(x, y, x, y + height);
        g.drawLine(x + 1, y, x + width - 1, y);
        g.setColor(this.frameBrighter);
        g.drawLine(x + 1, y + height, x + width, y + height);
        g.drawLine(x + width, y, x + width, y + height - 1);
    }

    public void show(double percent) {
        this.show(percent, false);
    }

    public void show(double percent, boolean showInBatchMode) {
        if (!showInBatchMode && (this.batchMode || Interpreter.isBatchMode())) {
            return;
        }
        if (percent >= 1.0) {
            percent = 0.0;
            this.showBar = false;
            this.repaint();
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastTime < 90L && percent != 1.0) {
            return;
        }
        this.lastTime = time;
        this.showBar = true;
        this.percent = percent;
        this.repaint();
    }

    public void show(int currentIndex, int finalIndex) {
        this.show(((double)currentIndex + 1.0) / (double)finalIndex, true);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.showBar) {
            this.fill3DRect(g, this.x - 1, this.y - 1, this.width + 1, this.height + 1);
            this.drawBar(g);
        } else {
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        }
    }

    void drawBar(Graphics g) {
        if (this.percent < 0.0) {
            this.percent = 0.0;
        }
        int barEnd = (int)((double)this.width * this.percent);
        g.setColor(this.barColor);
        g.fillRect(this.x, this.y, barEnd, this.height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.canvasWidth, this.canvasHeight);
    }

    public void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }
}

