/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class YesNoCancelDialog
extends Dialog
implements ActionListener,
KeyListener,
WindowListener {
    private Button yesB;
    private Button noB;
    private Button cancelB;
    private boolean cancelPressed;
    private boolean yesPressed;
    private boolean firstPaint = true;

    public YesNoCancelDialog(Frame parent, String title, String msg) {
        super(parent, title, true);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 10, 10));
        MultiLineLabel message = new MultiLineLabel(msg);
        message.setFont(new Font("Dialog", 0, 12));
        panel.add(message);
        this.add("North", panel);
        panel = new Panel();
        panel.setLayout(new FlowLayout(2, 15, 8));
        if (IJ.isMacintosh() && msg.startsWith("Save")) {
            this.yesB = new Button("  Save  ");
            this.noB = new Button("Don't Save");
            this.cancelB = new Button("  Cancel  ");
        } else {
            this.yesB = new Button("  Yes  ");
            this.noB = new Button("  No  ");
            this.cancelB = new Button(" Cancel ");
        }
        this.yesB.addActionListener(this);
        this.noB.addActionListener(this);
        this.cancelB.addActionListener(this);
        this.yesB.addKeyListener(this);
        this.noB.addKeyListener(this);
        this.cancelB.addKeyListener(this);
        if (IJ.isMacintosh()) {
            panel.add(this.noB);
            panel.add(this.cancelB);
            panel.add(this.yesB);
            this.setResizable(false);
        } else {
            panel.add(this.yesB);
            panel.add(this.noB);
            panel.add(this.cancelB);
        }
        this.add("South", panel);
        this.addWindowListener(this);
        this.pack();
        GUI.center(this);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelB) {
            this.cancelPressed = true;
        } else if (e.getSource() == this.yesB) {
            this.yesPressed = true;
        }
        this.closeDialog();
    }

    public boolean cancelPressed() {
        return this.cancelPressed;
    }

    public boolean yesPressed() {
        return this.yesPressed;
    }

    void closeDialog() {
        this.dispose();
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyDown(keyCode);
        if (keyCode == 10) {
            if (this.cancelB.isFocusOwner()) {
                this.cancelPressed = true;
                this.closeDialog();
            } else if (this.noB.isFocusOwner()) {
                this.closeDialog();
            } else {
                this.yesPressed = true;
                this.closeDialog();
            }
        } else if (keyCode == 89 || keyCode == 83) {
            this.yesPressed = true;
            this.closeDialog();
        } else if (keyCode == 78 || keyCode == 68) {
            this.closeDialog();
        } else if (keyCode == 27 || keyCode == 67) {
            this.cancelPressed = true;
            this.closeDialog();
            IJ.resetEscape();
        }
    }

    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyUp(keyCode);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.firstPaint) {
            this.yesB.requestFocus();
            this.firstPaint = false;
        }
    }

    public void windowClosing(WindowEvent e) {
        this.cancelPressed = true;
        this.closeDialog();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

