/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.VirtualStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.io.TiffDecoder;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.IOException;
import java.util.Properties;

public class FileInfoVirtualStack
extends VirtualStack
implements PlugIn {
    FileInfo[] info;
    int nImages;

    public FileInfoVirtualStack() {
    }

    public FileInfoVirtualStack(FileInfo fi) {
        this.info = new FileInfo[1];
        this.info[0] = fi;
        this.open(true);
    }

    public FileInfoVirtualStack(FileInfo fi, boolean show) {
        this.info = new FileInfo[1];
        this.info[0] = fi;
        this.open(show);
    }

    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open TIFF", arg);
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        if (name.endsWith(".zip")) {
            IJ.error("Virtual Stack", "ZIP compressed stacks not supported");
            return;
        }
        String dir = od.getDirectory();
        TiffDecoder td = new TiffDecoder(dir, name);
        if (IJ.debugMode) {
            td.enableDebugging();
        }
        IJ.showStatus("Decoding TIFF header...");
        try {
            this.info = td.getTiffInfo();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.error("TiffDecoder", msg);
            return;
        }
        if (this.info == null || this.info.length == 0) {
            IJ.error("Virtual Stack", "This does not appear to be a TIFF stack");
            return;
        }
        if (IJ.debugMode) {
            IJ.log(this.info[0].debugInfo);
        }
        this.open(true);
    }

    void open(boolean show) {
        FileInfo fi = this.info[0];
        int n = fi.nImages;
        if (this.info.length == 1 && n > 1) {
            this.info = new FileInfo[n];
            long size = fi.width * fi.height * fi.getBytesPerPixel();
            for (int i = 0; i < n; ++i) {
                this.info[i] = (FileInfo)fi.clone();
                this.info[i].nImages = 1;
                this.info[i].longOffset = fi.getOffset() + (long)i * (size + (long)fi.gapBetweenImages);
            }
        }
        this.nImages = this.info.length;
        FileOpener fo = new FileOpener(this.info[0]);
        ImagePlus imp = fo.open(false);
        if (this.nImages == 1 && fi.fileType == 12) {
            if (show) {
                imp.show();
            }
            return;
        }
        Properties props = fo.decodeDescriptionString(fi);
        ImagePlus imp2 = new ImagePlus(fi.fileName, this);
        imp2.setFileInfo(fi);
        if (imp != null && props != null) {
            int frames;
            int slices;
            int channels;
            this.setBitDepth(imp.getBitDepth());
            imp2.setCalibration(imp.getCalibration());
            imp2.setOverlay(imp.getOverlay());
            if (fi.info != null) {
                imp2.setProperty("Info", fi.info);
            }
            if ((channels = this.getInt(props, "channels")) * (slices = this.getInt(props, "slices")) * (frames = this.getInt(props, "frames")) == this.nImages) {
                imp2.setDimensions(channels, slices, frames);
                if (this.getBoolean(props, "hyperstack")) {
                    imp2.setOpenAsHyperStack(true);
                }
            }
            if (channels > 1 && fi.description != null) {
                int mode = 1;
                if (fi.description.indexOf("mode=color") != -1) {
                    mode = 2;
                } else if (fi.description.indexOf("mode=gray") != -1) {
                    mode = 3;
                }
                imp2 = new CompositeImage(imp2, mode);
            }
        }
        if (show) {
            imp2.show();
        }
    }

    int getInt(Properties props, String key) {
        Double n = this.getNumber(props, key);
        return n != null ? (int)n.doubleValue() : 1;
    }

    Double getNumber(Properties props, String key) {
        String s = props.getProperty(key);
        if (s != null) {
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return null;
    }

    boolean getBoolean(Properties props, String key) {
        String s = props.getProperty(key);
        return s != null && s.equals("true");
    }

    public void deleteSlice(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.nImages < 1) {
            return;
        }
        for (int i = n; i < this.nImages; ++i) {
            this.info[i - 1] = this.info[i];
        }
        this.info[this.nImages - 1] = null;
        --this.nImages;
    }

    public ImageProcessor getProcessor(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (IJ.debugMode) {
            IJ.log("FileInfoVirtualStack: " + n + ", " + this.info[n - 1].getOffset());
        }
        this.info[n - 1].nImages = 1;
        FileOpener fo = new FileOpener(this.info[n - 1]);
        ImagePlus imp = fo.open(false);
        if (imp != null) {
            return imp.getProcessor();
        }
        int w = this.getWidth();
        int h = this.getHeight();
        IJ.log("Read error or file not found (" + n + "): " + this.info[n - 1].directory + this.info[n - 1].fileName);
        switch (this.getBitDepth()) {
            case 8: {
                return new ByteProcessor(w, h);
            }
            case 16: {
                return new ShortProcessor(w, h);
            }
            case 24: {
                return new ColorProcessor(w, h);
            }
            case 32: {
                return new FloatProcessor(w, h);
            }
        }
        return null;
    }

    public int getSize() {
        return this.nImages;
    }

    public String getSliceLabel(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.info[0].sliceLabels == null || this.info[0].sliceLabels.length != this.nImages) {
            return null;
        }
        return this.info[0].sliceLabels[n - 1];
    }

    public int getWidth() {
        return this.info[0].width;
    }

    public int getHeight() {
        return this.info[0].height;
    }
}

