/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.process.ByteProcessor;
import ij.process.ByteStatistics;
import ij.process.ColorStatistics;
import ij.process.EllipseFitter;
import ij.process.FloatStatistics;
import ij.process.ImageProcessor;
import ij.process.ShortStatistics;
import java.awt.Rectangle;

public class ImageStatistics
implements Measurements {
    public int[] histogram;
    public int pixelCount;
    public long longPixelCount;
    public int mode;
    public double dmode;
    public double area;
    public double min;
    public double max;
    public double mean;
    public double median;
    public double stdDev;
    public double skewness;
    public double kurtosis;
    public double xCentroid;
    public double yCentroid;
    public double xCenterOfMass;
    public double yCenterOfMass;
    public double roiX;
    public double roiY;
    public double roiWidth;
    public double roiHeight;
    public double umean;
    public double major;
    public double minor;
    public double angle;
    public int[] histogram16;
    protected long[] longHistogram;
    public double areaFraction;
    public int xstart;
    public int ystart;
    public double histMin;
    public double histMax;
    public int histYMax;
    public int maxCount;
    public int nBins = 256;
    public double binSize = 1.0;
    protected int width;
    protected int height;
    protected int rx;
    protected int ry;
    protected int rw;
    protected int rh;
    protected double pw;
    protected double ph;
    protected Calibration cal;
    EllipseFitter ef;

    public static ImageStatistics getStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        Object pixels = ip.getPixels();
        if (pixels instanceof byte[]) {
            return new ByteStatistics(ip, mOptions, cal);
        }
        if (pixels instanceof short[]) {
            return new ShortStatistics(ip, mOptions, cal);
        }
        if (pixels instanceof int[]) {
            return new ColorStatistics(ip, mOptions, cal);
        }
        if (pixels instanceof float[]) {
            return new FloatStatistics(ip, mOptions, cal);
        }
        throw new IllegalArgumentException("Pixels are not byte, short, int or float");
    }

    void getRawMinAndMax(int minThreshold, int maxThreshold) {
        int max;
        int min;
        for (min = minThreshold; this.histogram[min] == 0 && min < 255; ++min) {
        }
        this.min = min;
        for (max = maxThreshold; this.histogram[max] == 0 && max > 0; --max) {
        }
        this.max = max;
    }

    void getRawStatistics(int minThreshold, int maxThreshold) {
        double sum = 0.0;
        double sum2 = 0.0;
        for (int i = minThreshold; i <= maxThreshold; ++i) {
            int count = this.histogram[i];
            this.longPixelCount += (long)count;
            sum += (double)i * (double)count;
            double value = i;
            sum2 += value * value * (double)count;
            if (count <= this.maxCount) continue;
            this.maxCount = count;
            this.mode = i;
        }
        this.pixelCount = (int)this.longPixelCount;
        this.area = (double)this.longPixelCount * this.pw * this.ph;
        this.umean = this.mean = sum / (double)this.longPixelCount;
        this.dmode = this.mode;
        this.calculateStdDev(this.longPixelCount, sum, sum2);
        this.histMin = 0.0;
        this.histMax = 255.0;
    }

    void calculateStdDev(double n, double sum, double sum2) {
        if (n > 0.0) {
            this.stdDev = (n * sum2 - sum * sum) / n;
            this.stdDev = this.stdDev > 0.0 ? Math.sqrt(this.stdDev / (n - 1.0)) : 0.0;
        } else {
            this.stdDev = 0.0;
        }
    }

    void setup(ImageProcessor ip, Calibration cal) {
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.cal = cal;
        Rectangle roi = ip.getRoi();
        if (roi != null) {
            this.rx = roi.x;
            this.ry = roi.y;
            this.rw = roi.width;
            this.rh = roi.height;
        } else {
            this.rx = 0;
            this.ry = 0;
            this.rw = this.width;
            this.rh = this.height;
        }
        if (cal != null) {
            this.pw = cal.pixelWidth;
            this.ph = cal.pixelHeight;
        } else {
            this.pw = 1.0;
            this.ph = 1.0;
        }
        this.roiX = cal != null ? cal.getX(this.rx) : (double)this.rx;
        this.roiY = cal != null ? cal.getY(this.ry, this.height) : (double)this.ry;
        this.roiWidth = (double)this.rw * this.pw;
        this.roiHeight = (double)this.rh * this.ph;
    }

    void getCentroid(ImageProcessor ip) {
        byte[] mask = ip.getMaskArray();
        int count = 0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int mi = my * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                if (mask != null && mask[mi++] == 0) continue;
                ++count;
                xsum += (double)x;
                ysum += (double)y;
            }
            ++y;
            ++my;
        }
        this.xCentroid = xsum / (double)count + 0.5;
        this.yCentroid = ysum / (double)count + 0.5;
        if (this.cal != null) {
            this.xCentroid = this.cal.getX(this.xCentroid);
            this.yCentroid = this.cal.getY(this.yCentroid, this.height);
        }
    }

    void fitEllipse(ImageProcessor ip, int mOptions) {
        boolean limitToThreshold;
        ImageProcessor originalMask = null;
        boolean bl = limitToThreshold = (mOptions & 0x100) != 0 && ip.getMinThreshold() != -808080.0;
        if (limitToThreshold) {
            ImageProcessor mask = ip.getMask();
            Rectangle r = ip.getRoi();
            if (mask == null) {
                mask = new ByteProcessor(r.width, r.height);
                mask.invert();
            } else {
                originalMask = mask;
                mask = mask.duplicate();
            }
            int n = r.width * r.height;
            double t1 = ip.getMinThreshold();
            double t2 = ip.getMaxThreshold();
            for (int y = 0; y < r.height; ++y) {
                for (int x = 0; x < r.width; ++x) {
                    double value = ip.getf(r.x + x, r.y + y);
                    if (!(value < t1) && !(value > t2)) continue;
                    mask.setf(x, y, 0.0f);
                }
            }
            ip.setMask(mask);
        }
        if (this.ef == null) {
            this.ef = new EllipseFitter();
        }
        this.ef.fit(ip, this);
        if (limitToThreshold) {
            if (originalMask == null) {
                ip.setMask(null);
            } else {
                ip.setMask(originalMask);
            }
        }
        double psize = Math.abs(this.pw - this.ph) / this.pw < 0.01 ? this.pw : 0.0;
        this.major = this.ef.major * psize;
        this.minor = this.ef.minor * psize;
        this.angle = this.ef.angle;
        this.xCentroid = this.ef.xCenter;
        this.yCentroid = this.ef.yCenter;
        if (this.cal != null) {
            this.xCentroid = this.cal.getX(this.xCentroid);
            this.yCentroid = this.cal.getY(this.yCentroid, this.height);
        }
    }

    public void drawEllipse(ImageProcessor ip) {
        if (this.ef != null) {
            this.ef.drawEllipse(ip);
        }
    }

    void calculateMedian(int[] hist, int first, int last, Calibration cal) {
        double sum = 0.0;
        int i = first - 1;
        double halfCount = (double)this.pixelCount / 2.0;
        while ((sum += (double)hist[++i]) <= halfCount && i < last) {
        }
        this.median = cal != null ? cal.getCValue(i) : (double)i;
    }

    void calculateAreaFraction(ImageProcessor ip, int[] hist) {
        int sum = 0;
        int total = 0;
        int t1 = (int)Math.round(ip.getMinThreshold());
        int t2 = (int)Math.round(ip.getMaxThreshold());
        if ((double)t1 == -808080.0) {
            for (int i = 0; i < hist.length; ++i) {
                total += hist[i];
            }
            sum = total - hist[0];
        } else {
            for (int i = 0; i < hist.length; ++i) {
                if (i >= t1 && i <= t2) {
                    sum += hist[i];
                }
                total += hist[i];
            }
        }
        this.areaFraction = (double)sum * 100.0 / (double)total;
    }

    public long[] getHistogram() {
        long[] hist = new long[this.histogram.length];
        for (int i = 0; i < hist.length; ++i) {
            hist[i] = this.longHistogram != null ? this.longHistogram[i] : (long)this.histogram[i];
        }
        return hist;
    }

    public String toString() {
        return "stats[count=" + this.pixelCount + ", mean=" + this.mean + ", min=" + this.min + ", max=" + this.max + "]";
    }
}

