/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

class Convert {
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    Convert() {
    }

    protected static String escape(String line) {
        int len = line.length();
        StringBuilder buffer = new StringBuilder(len * 2);
        for (int i = 0; i < len; ++i) {
            char c = line.charAt(i);
            int idx = "\\\t\n\f".indexOf(c);
            if (idx >= 0) {
                buffer.append('\\');
                buffer.append("\\tnf".charAt(idx));
                continue;
            }
            if (c < ' ' || c > '~') {
                buffer.append("\\u");
                buffer.append(HEX[c >>> 12 & 0xF]);
                buffer.append(HEX[c >>> 8 & 0xF]);
                buffer.append(HEX[c >>> 4 & 0xF]);
                buffer.append(HEX[c & 0xF]);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    protected static String unescape(String line) {
        int n = line.length();
        StringBuilder buffer = new StringBuilder(n);
        int i = 0;
        while (i < n) {
            char c;
            if ((c = line.charAt(i++)) == '\\') {
                if ((c = line.charAt(i++)) == 'u') {
                    try {
                        c = (char)Integer.parseInt(line.substring(i, i += 4), 16);
                    }
                    catch (RuntimeException x) {
                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                    }
                } else {
                    int idx = "\\tnf".indexOf(c);
                    if (idx >= 0) {
                        c = "\\\t\n\f".charAt(idx);
                    }
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

