/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserFactory;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsCopied;
import org.openmicroscopy.shoola.agents.events.metadata.AnnotatedEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.CopyItems;
import org.openmicroscopy.shoola.agents.events.treeviewer.DisplayModeEvent;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.events.ReconnectedEvent;
import org.openmicroscopy.shoola.env.data.events.UserGroupSwitched;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;

public class DataBrowserAgent
implements Agent,
AgentEventListener {
    private static Registry registry;
    private int displayMode = -1;

    public static Registry getRegistry() {
        return registry;
    }

    public static Collection getAvailableUserGroups() {
        return (Collection)registry.lookup("/userGroup/details");
    }

    public static SecurityContext getAdminContext() {
        if (!DataBrowserAgent.isAdministrator()) {
            return null;
        }
        Collection groups = DataBrowserAgent.getAvailableUserGroups();
        Iterator i = groups.iterator();
        AdminService svc = registry.getAdminService();
        while (i.hasNext()) {
            GroupData g = (GroupData)i.next();
            if (!svc.isSecuritySystemGroup(g.getId(), "system")) continue;
            return new SecurityContext(g.getId());
        }
        return null;
    }

    public static int runAsPlugin() {
        Environment env = (Environment)registry.lookup("/env");
        if (env == null) {
            return -1;
        }
        return env.runAsPlugin();
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    public static boolean isAdministrator() {
        Boolean b = (Boolean)registry.lookup("/users/administrator");
        if (b == null) {
            return false;
        }
        return b;
    }

    public static boolean isEditUser() {
        Boolean b = (Boolean)registry.lookup("/users/edit");
        if (b == null) {
            return false;
        }
        return b;
    }

    public static boolean isEditGroup() {
        Boolean b = (Boolean)registry.lookup("/groups/edit");
        if (b == null) {
            return false;
        }
        return b;
    }

    public static boolean isAddToGroup() {
        Boolean b = (Boolean)registry.lookup("/groups/add");
        if (b == null) {
            return false;
        }
        return b;
    }

    public static boolean isMoveGroup() {
        Boolean b = (Boolean)registry.lookup("/groups/move");
        if (b == null) {
            return false;
        }
        return b;
    }

    public static Set getGroupsLeaderOf() {
        HashSet<GroupData> values = new HashSet<GroupData>();
        Collection groups = (Collection)registry.lookup("/userGroup/details");
        Iterator i = groups.iterator();
        ExperimenterData exp2 = DataBrowserAgent.getUserDetails();
        long id = exp2.getId();
        while (i.hasNext()) {
            GroupData g = (GroupData)i.next();
            Set leaders = g.getLeaders();
            if (leaders == null || leaders.size() <= 0) continue;
            for (ExperimenterData exp2 : leaders) {
                if (exp2.getId() != id) continue;
                values.add(g);
            }
        }
        return values;
    }

    public static boolean isLeaderOfCurrentGroup() {
        ExperimenterData exp = DataBrowserAgent.getUserDetails();
        Set groups = DataBrowserAgent.getGroupsLeaderOf();
        if (groups.size() == 0) {
            return false;
        }
        GroupData group = exp.getDefaultGroup();
        for (GroupData g : groups) {
            if (g.getId() != group.getId()) continue;
            return true;
        }
        return false;
    }

    public static ExperimenterData getExperimenter(long expID) {
        List l = (List)registry.lookup("/users/details");
        if (l == null) {
            return null;
        }
        for (ExperimenterData exp : l) {
            if (exp.getId() != expID) continue;
            return exp;
        }
        return null;
    }

    public static boolean canCreate() {
        Boolean b = (Boolean)registry.lookup("canCreate");
        return b;
    }

    private void handleRndSettingsCopied(RndSettingsCopied evt) {
        Collection<Long> ids = evt.getImagesIDs();
        DataBrowserFactory.refreshThumbnails(ids);
    }

    private void handleCopyRndSettings(CopyRndSettings evt) {
        DataBrowserFactory.setRndSettingsToCopy(evt.getImage(), evt.getRndDef());
    }

    private void handleCopyItems(CopyItems evt) {
        DataBrowserFactory.setDataToCopy(evt.getType());
    }

    private void handleUserGroupSwitched(UserGroupSwitched evt) {
        if (evt == null) {
            return;
        }
        DataBrowserFactory.onGroupSwitched(evt.isSuccessful());
    }

    private void handleReconnectedEvent(ReconnectedEvent evt) {
        if (evt == null) {
            return;
        }
        DataBrowserFactory.onGroupSwitched(true);
    }

    private void handleAnnotatedEvent(AnnotatedEvent evt) {
        DataBrowserFactory.onAnnotated(evt.getData(), evt.getCount());
    }

    private void handleDisplayModeEvent(DisplayModeEvent evt) {
        this.displayMode = evt.getDisplayMode();
        DataBrowserFactory.setDisplayMode(this.displayMode);
    }

    @Override
    public void activate(boolean master) {
    }

    @Override
    public void terminate() {
        Environment env = (Environment)registry.lookup("/env");
        if (env.isRunAsPlugin()) {
            DataBrowserFactory.onGroupSwitched(true);
        }
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = registry.getEventBus();
        bus.register((AgentEventListener)this, RndSettingsCopied.class);
        bus.register((AgentEventListener)this, CopyRndSettings.class);
        bus.register((AgentEventListener)this, CopyItems.class);
        bus.register((AgentEventListener)this, UserGroupSwitched.class);
        bus.register((AgentEventListener)this, ReconnectedEvent.class);
        bus.register((AgentEventListener)this, AnnotatedEvent.class);
        bus.register((AgentEventListener)this, DisplayModeEvent.class);
    }

    @Override
    public boolean canTerminate() {
        return true;
    }

    @Override
    public AgentSaveInfo getDataToSave() {
        return null;
    }

    @Override
    public void save(List<Object> instances) {
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof RndSettingsCopied) {
            this.handleRndSettingsCopied((RndSettingsCopied)e);
        } else if (e instanceof CopyRndSettings) {
            this.handleCopyRndSettings((CopyRndSettings)e);
        } else if (e instanceof CopyItems) {
            this.handleCopyItems((CopyItems)e);
        } else if (e instanceof UserGroupSwitched) {
            this.handleUserGroupSwitched((UserGroupSwitched)e);
        } else if (e instanceof ReconnectedEvent) {
            this.handleReconnectedEvent((ReconnectedEvent)e);
        } else if (e instanceof AnnotatedEvent) {
            this.handleAnnotatedEvent((AnnotatedEvent)e);
        } else if (e instanceof DisplayModeEvent) {
            this.handleDisplayModeEvent((DisplayModeEvent)e);
        }
    }
}

