/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import omero.gateway.SecurityContext;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.DataHandlerView;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;
import org.openmicroscopy.shoola.env.data.views.HierarchyBrowsingView;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;

public abstract class DataBrowserLoader
extends DSCallAdapter {
    protected final DataBrowser viewer;
    protected final Registry registry;
    protected final HierarchyBrowsingView hiBrwView;
    protected final DataHandlerView dhView;
    protected final MetadataHandlerView mhView;
    protected final DataManagerView dmView;
    protected final SecurityContext ctx;

    protected DataBrowserLoader(DataBrowser viewer, SecurityContext ctx) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        if (ctx == null) {
            throw new NullPointerException("No security context.");
        }
        this.viewer = viewer;
        this.ctx = ctx;
        this.registry = DataBrowserAgent.getRegistry();
        this.hiBrwView = (HierarchyBrowsingView)this.registry.getDataServicesView(HierarchyBrowsingView.class);
        this.dhView = (DataHandlerView)this.registry.getDataServicesView(DataHandlerView.class);
        this.mhView = (MetadataHandlerView)this.registry.getDataServicesView(MetadataHandlerView.class);
        this.dmView = (DataManagerView)this.registry.getDataServicesView(DataManagerView.class);
    }

    protected long getCurrentUser() {
        return DataBrowserAgent.getUserDetails().getId();
    }

    @Override
    public void onEnd() {
        this.viewer.setStatus(null, 100);
    }

    @Override
    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    @Override
    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        this.registry.getUserNotifier().notifyInfo("Data Retrieval Cancellation", info);
    }

    @Override
    public void handleException(Throwable exc) {
        int state = this.viewer.getState();
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print("State: " + state);
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        if (state != 5) {
            this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        }
    }

    public abstract void load();

    public abstract void cancel();
}

