/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Icon;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DataBrowserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.events.treeviewer.MoveToEvent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MoveToAction
extends DataBrowserAction {
    public static final String NAME = "Move to";
    public static final String DESCRIPTION = "Select the group where to move the data.";
    private GroupData group;

    private void setPermissions() {
        IconManager im = IconManager.getInstance();
        Icon icon = im.getIcon(51);
        String desc = "";
        switch (this.group.getPermissions().getPermissionsLevel()) {
            case 0: {
                desc = "Private Group";
                icon = im.getIcon(52);
                break;
            }
            case 1: {
                desc = "Collaborators can only read your data.";
                icon = im.getIcon(53);
                break;
            }
            case 2: {
                desc = "Collaborators can read and annotate your data.";
                icon = im.getIcon(54);
                break;
            }
            case 3: {
                desc = "Collaborators can read, annotate, delete, etc., your data.";
                icon = im.getIcon(57);
                break;
            }
            case 4: {
                desc = "Public";
                icon = im.getIcon(55);
                break;
            }
            case 5: {
                desc = "Public";
                icon = im.getIcon(55);
            }
        }
        this.putValue("SmallIcon", icon);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(desc));
    }

    public MoveToAction(DataBrowser model, GroupData group) {
        super(model);
        if (group == null) {
            throw new IllegalArgumentException("No group.");
        }
        this.group = group;
        this.setEnabled(DataBrowserAgent.canCreate());
        this.putValue("Name", group.getName() + "...");
        this.setPermissions();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Browser b = this.model.getBrowser();
        if (b == null) {
            return;
        }
        MoveToEvent evt = new MoveToEvent(this.group, (List)b.getSelectedDataObjects());
        DataBrowserAgent.getRegistry().getEventBus().post(evt);
    }
}

