/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.WellSampleData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DataBrowserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class TaggingAction
extends DataBrowserAction {
    private static final String NAME = "Tag...";
    private static final String DESCRIPTION = "Add or remove tags.";

    @Override
    protected void onDisplayChange(ImageDisplay node) {
        if (!DataBrowserAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        if (node == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = node.getHierarchyObject();
        if (ho instanceof ImageData || ho instanceof DatasetData || ho instanceof ProjectData || ho instanceof ScreenData || ho instanceof PlateData || ho instanceof PlateAcquisitionData || ho instanceof WellSampleData) {
            if (this.model.canAnnotate(ho)) {
                Collection<DataObject> l = this.model.getBrowser().getSelectedDataObjects();
                ArrayList<Long> ids = new ArrayList<Long>();
                for (DataObject data : l) {
                    if (ids.contains(data.getGroupId())) continue;
                    ids.add(data.getGroupId());
                }
                this.setEnabled(ids.size() == 1);
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    public TaggingAction(DataBrowser model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(40));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.model.showTagWizard();
    }
}

