/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import ome.model.units.BigResult;
import omero.gateway.model.DataObject;
import omero.gateway.model.WellSampleData;
import omero.model.enums.UnitsLength;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailProvider;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;

public class WellSampleNode
extends ImageNode {
    private WellImageSet parent;
    private int index;
    private int titleHeight;
    private boolean well;

    public WellSampleNode(String title, Object ho, Thumbnail t, int index, WellImageSet parent) {
        super(title, ho, t);
        if (parent == null) {
            throw new IllegalArgumentException("No parent.");
        }
        this.setTitleBarType(5);
        this.titleHeight = this.getTitleBar().getPreferredSize().height;
        this.setTitleBarType(0);
        this.index = index;
        this.parent = parent;
        this.well = true;
    }

    public boolean isWell() {
        return this.well;
    }

    public void setWell(boolean well) {
        this.well = well;
    }

    public boolean isSame(WellSampleNode other) {
        if (this.isWell() ^ other.isWell()) {
            return false;
        }
        if (this.isWell()) {
            WellImageSet d = this.getParentWell();
            WellImageSet dother = other.getParentWell();
            return d.getRow() == dother.getRow() && d.getColumn() == dother.getColumn();
        }
        WellSampleData d = (WellSampleData)this.getHierarchyObject();
        WellSampleData dother = (WellSampleData)other.getHierarchyObject();
        return d.getImage().getId() == dother.getImage().getId();
    }

    public static boolean isSame(Collection<WellSampleNode> sel1, Collection<WellSampleNode> sel2) {
        if (sel1 == null ^ sel2 == null) {
            return false;
        }
        if (sel1 == null && sel2 == null) {
            return true;
        }
        if (sel1.size() != sel2.size()) {
            return false;
        }
        ArrayList<WellSampleNode> tmp = new ArrayList<WellSampleNode>(sel1);
        Iterator it = tmp.iterator();
        block0: while (it.hasNext()) {
            WellSampleNode next = (WellSampleNode)it.next();
            for (WellSampleNode n2 : sel2) {
                if (!next.isSame(n2)) continue;
                it.remove();
                continue block0;
            }
        }
        return tmp.isEmpty();
    }

    @Override
    public WellSampleNode copy() {
        ThumbnailProvider thumbCopy = new ThumbnailProvider((DataObject)((WellSampleData)this.getHierarchyObject()).getImage());
        thumbCopy.setFullScaleThumb(this.getThumbnail().getFullScaleThumb());
        WellSampleNode copy = new WellSampleNode(this.getTitle(), this.getHierarchyObject(), thumbCopy, this.index, this.parent);
        copy.setWell(this.isWell());
        return copy;
    }

    public int getTitleHeight() {
        return this.titleHeight;
    }

    public double getPositionX() {
        WellSampleData data = (WellSampleData)this.getHierarchyObject();
        try {
            return data.getPositionX(UnitsLength.REFERENCEFRAME).getValue();
        }
        catch (BigResult e) {
            throw new RuntimeException(e);
        }
    }

    public double getPositionY() {
        WellSampleData data = (WellSampleData)this.getHierarchyObject();
        try {
            return data.getPositionY(UnitsLength.REFERENCEFRAME).getValue();
        }
        catch (BigResult e) {
            throw new RuntimeException(e);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public int getRow() {
        return this.parent.getRow();
    }

    public int getColumn() {
        return this.parent.getColumn();
    }

    public int getLayedoutRow() {
        return this.parent.getRow() - this.parent.getIndentRow();
    }

    public int getLayedoutColumn() {
        return this.parent.getColumn() - this.parent.getIndentColumn();
    }

    public Object getParentObject() {
        return this.parent.getHierarchyObject();
    }

    public WellImageSet getParentWell() {
        return this.parent;
    }
}

