/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import omero.gateway.model.DataObject;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TextualAnnotationData;
import org.jdesktop.swingx.JXDatePicker;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.util.SelectionWizard;
import org.openmicroscopy.shoola.agents.util.tagging.util.TagCellRenderer;
import org.openmicroscopy.shoola.agents.util.tagging.util.TagItem;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import org.openmicroscopy.shoola.util.ui.HistoryDialog;
import org.openmicroscopy.shoola.util.ui.RatingComponent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.search.SearchUtil;

public class FilteringDialog
extends JDialog
implements ActionListener,
DocumentListener,
PropertyChangeListener {
    public static final String LOAD_TAG_PROPERTY = "loadTag";
    public static final String FILTER_PROPERTY = "filter";
    private static final String TITLE = "Filtering elements in Workspace";
    private static final String DESCRIPTION = "Separate tags with ,";
    private static final int CANCEL = 0;
    private static final int FILTER = 1;
    private static final int LOAD_TAGS = 2;
    private static final int GREATER_EQUAL = 0;
    private static final int LOWER_EQUAL = 1;
    private static final int EQUAL = 2;
    private static final int MAX = 2;
    private static final String[] COMPARISON_OPTIONS = new String[3];
    private JCheckBox ratingBox;
    private JCheckBox commentsBox;
    private JCheckBox nameBox;
    private JCheckBox tagsBox;
    private JComboBox timeOptions;
    private JCheckBox roiBox;
    private JComboBox ratingOptions;
    private JComboBox roiOptions;
    private JXDatePicker fromDate;
    private JXDatePicker toDate;
    private RatingComponent rating;
    private JSpinner roiSpinner;
    private JTextField tagsArea;
    private JTextField commentsArea;
    private JTextField nameArea;
    private JButton cancelButton;
    private JButton filterButton;
    private JButton loadTagsButton;
    private HistoryDialog tagsDialog;
    private Collection existingTags;
    private boolean codeCompletion;

    private void showTagsWizard() {
        IconManager icons = IconManager.getInstance();
        String title = "Filter By Tags";
        String text = "Select the Tags to filter by.";
        ArrayList<Object> selected = new ArrayList<Object>();
        Iterator i = this.existingTags.iterator();
        List<String> l = SearchUtil.splitTerms(this.tagsArea.getText(), ",");
        ArrayList<Object> available = new ArrayList<Object>();
        while (i.hasNext()) {
            TagAnnotationData tag = (TagAnnotationData)i.next();
            if (l.contains(tag.getTagValue())) {
                selected.add(tag);
                continue;
            }
            available.add(tag);
        }
        SelectionWizard wizard = new SelectionWizard(DataBrowserAgent.getRegistry().getTaskBar().getFrame(), available, selected, TagAnnotationData.class, false, DataBrowserAgent.getUserDetails());
        wizard.setTitle(title, text, icons.getIcon(47));
        wizard.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(wizard);
    }

    private void handleTagsSelection(Collection tags) {
        if (tags == null || tags.size() == 0) {
            return;
        }
        this.tagsArea.getDocument().removeDocumentListener(this);
        this.tagsArea.setText("");
        this.tagsArea.getDocument().addDocumentListener(this);
        for (TagAnnotationData tag : tags) {
            this.enterTag(tag, false);
        }
    }

    private void enterTag(TagAnnotationData tag, boolean removeLast) {
        String text = tag.getTagValue();
        List<String> l = SearchUtil.splitTerms(this.tagsArea.getText(), ",");
        if (removeLast && l.size() > 0) {
            l.remove(l.size() - 1);
        }
        String result = SearchUtil.formatString(text, l);
        this.tagsArea.getDocument().removeDocumentListener(this);
        this.tagsArea.setText(result);
        this.tagsArea.getDocument().addDocumentListener(this);
    }

    private void handleTagInsert() {
        this.codeCompletion = true;
        if (this.existingTags == null) {
            this.firePropertyChange(LOAD_TAG_PROPERTY, (Object)false, (Object)true);
            return;
        }
        this.codeCompletion();
        if (this.tagsDialog == null) {
            return;
        }
        String name = this.tagsArea.getText();
        List<String> l = SearchUtil.splitTerms(name, ",");
        if (l.size() > 0) {
            if (this.tagsDialog.setSelectedTextValue(l.get(l.size() - 1).trim())) {
                Rectangle r = this.tagsArea.getBounds();
                this.tagsDialog.show(this.tagsArea, 0, r.height);
                this.tagsArea.requestFocus();
            } else {
                this.tagsDialog.setVisible(false);
            }
        }
    }

    private void codeCompletion() {
        if (this.tagsDialog != null) {
            return;
        }
        Rectangle r = this.tagsArea.getBounds();
        Object[] data = null;
        if (this.existingTags != null && this.existingTags.size() > 0) {
            data = new Object[this.existingTags.size()];
            Iterator j = this.existingTags.iterator();
            int i = 0;
            while (j.hasNext()) {
                DataObject object = (DataObject)j.next();
                TagItem item = new TagItem(object);
                data[i] = item;
                ++i;
            }
            long id = MetadataViewerAgent.getUserDetails().getId();
            this.tagsDialog = new HistoryDialog(data, r.width);
            this.tagsDialog.setListCellRenderer(new TagCellRenderer(id));
            this.tagsDialog.addPropertyChangeListener("selection", this);
        }
    }

    private void setProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
    }

    private void handleEnter() {
        if (this.tagsDialog == null || !this.tagsDialog.isVisible()) {
            return;
        }
        String name = this.tagsArea.getText();
        if (name == null) {
            return;
        }
        TagItem o = (TagItem)this.tagsDialog.getSelectedTextValue();
        if (o == null) {
            return;
        }
        DataObject ho = o.getDataObject();
        if (ho instanceof TagAnnotationData) {
            this.enterTag((TagAnnotationData)ho, true);
        }
    }

    private void initComponents() {
        this.ratingBox = new JCheckBox("Rating:");
        this.timeOptions = new JComboBox();
        this.timeOptions.setToolTipText("Select the type of date (Acquisition date applies to images only)");
        this.timeOptions.addItem("Import date");
        this.timeOptions.addItem("Acquisition date");
        this.commentsBox = new JCheckBox("Comments");
        this.nameBox = new JCheckBox("Name");
        this.tagsBox = new JCheckBox("Tags");
        this.tagsBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FilteringDialog.this.loadTagsButton.setEnabled(FilteringDialog.this.tagsBox.isSelected());
            }
        });
        this.roiBox = new JCheckBox("ROIs");
        this.ratingOptions = new JComboBox<String>(COMPARISON_OPTIONS);
        this.roiOptions = new JComboBox<String>(COMPARISON_OPTIONS);
        this.rating = new RatingComponent(5, 0);
        this.roiSpinner = new JSpinner(new SpinnerNumberModel(1, 0, Integer.MAX_VALUE, 1));
        this.fromDate = UIUtilities.createDatePicker(false, "yyyy-MM-dd");
        this.toDate = UIUtilities.createDatePicker(false, "yyyy-MM-dd");
        IconManager icons = IconManager.getInstance();
        this.loadTagsButton = new JButton(icons.getIcon(48));
        UIUtilities.unifiedButtonLookAndFeel(this.loadTagsButton);
        this.loadTagsButton.setToolTipText("Load existing Tags for filtering.");
        this.loadTagsButton.setEnabled(false);
        this.loadTagsButton.setActionCommand("2");
        this.loadTagsButton.addActionListener(this);
        this.tagsArea = new JTextField();
        this.tagsArea.setColumns(15);
        this.tagsArea.getDocument().addDocumentListener(this);
        this.tagsArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Object source = e.getSource();
                if (source != FilteringDialog.this.tagsArea) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 10: {
                        FilteringDialog.this.handleEnter();
                        break;
                    }
                    case 38: {
                        if (FilteringDialog.this.tagsDialog == null || !FilteringDialog.this.tagsDialog.isVisible()) break;
                        FilteringDialog.this.tagsDialog.setSelectedIndex(false);
                        break;
                    }
                    case 40: {
                        if (FilteringDialog.this.tagsDialog == null || !FilteringDialog.this.tagsDialog.isVisible()) break;
                        FilteringDialog.this.tagsDialog.setSelectedIndex(true);
                    }
                }
            }
        });
        this.commentsArea = new JTextField();
        this.commentsArea.setColumns(15);
        this.nameArea = new JTextField();
        this.nameArea.setColumns(15);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Close.");
        this.cancelButton.setActionCommand("0");
        this.cancelButton.addActionListener(this);
        this.filterButton = new JButton("Filter");
        this.filterButton.setToolTipText("Filter the data.");
        this.filterButton.setActionCommand("1");
        this.filterButton.addActionListener(this);
    }

    private void filter() {
        List<String> l;
        int index;
        FilterContext context = new FilterContext();
        if (this.ratingBox.isSelected()) {
            index = -1;
            switch (this.ratingOptions.getSelectedIndex()) {
                case 0: {
                    index = 0;
                    break;
                }
                case 1: {
                    index = 1;
                    break;
                }
                case 2: {
                    index = 2;
                }
            }
            context.setRate(index, this.rating.getCurrentValue());
        }
        if (this.roiBox.isSelected()) {
            index = -1;
            switch (this.roiOptions.getSelectedIndex()) {
                case 0: {
                    index = 0;
                    break;
                }
                case 1: {
                    index = 1;
                    break;
                }
                case 2: {
                    index = 2;
                }
            }
            context.setRois(index, ((Number)this.roiSpinner.getValue()).intValue());
        }
        Date d = this.fromDate.getDate();
        Timestamp start = null;
        if (d != null) {
            start = new Timestamp(d.getTime());
        }
        Timestamp end = null;
        d = this.toDate.getDate();
        if (d != null) {
            end = new Timestamp(d.getTime());
        }
        context.setTimeInterval(start, end);
        context.setTimeType(this.timeOptions.getSelectedItem().equals("Acquisition date") ? 1 : 0);
        if (this.tagsBox.isSelected() && (l = SearchUtil.splitTerms(this.tagsArea.getText(), ",")) != null && l.size() > 0) {
            context.addAnnotationType(TagAnnotationData.class, l);
        }
        if (this.commentsBox.isSelected() && (l = SearchUtil.splitTerms(this.commentsArea.getText(), ",")) != null && l.size() > 0) {
            context.addAnnotationType(TextualAnnotationData.class, l);
        }
        if (this.nameBox.isSelected() && (l = SearchUtil.splitTerms(this.nameArea.getText(), ",")) != null && l.size() > 0) {
            context.addName(l);
        }
        this.firePropertyChange(FILTER_PROPERTY, null, context);
        this.setVisible(false);
    }

    private JPanel buildRoiPane() {
        JPanel p = new JPanel();
        p.add(this.roiBox);
        p.add(this.roiOptions);
        p.add(this.roiSpinner);
        return UIUtilities.buildComponentPanel(p, 0, 0);
    }

    private JPanel buildRatingPane() {
        JPanel p = new JPanel();
        p.add(this.ratingBox);
        p.add(this.ratingOptions);
        p.add(this.rating);
        return UIUtilities.buildComponentPanel(p, 0, 0);
    }

    private JPanel buildCalendarPane() {
        JPanel date = new JPanel();
        date.add(UIUtilities.setTextFont("From: "));
        date.add((Component)this.fromDate);
        date.add(UIUtilities.setTextFont("To: "));
        date.add((Component)this.toDate);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.timeOptions);
        p.add(date);
        return UIUtilities.buildComponentPanel(p, 0, 0);
    }

    public JPanel buildTagsPane() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)this.tagsBox, c);
        ++c.gridx;
        p.add((Component)this.loadTagsButton, c);
        ++c.gridx;
        p.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.weightx = 0.5;
        p.add((Component)this.tagsArea, c);
        ++c.gridy;
        p.add((Component)UIUtilities.setTextFont(DESCRIPTION, 2, 10), c);
        return UIUtilities.buildComponentPanel(p, 5, 5);
    }

    public JPanel buildCommentsPane() {
        JPanel p = new JPanel();
        p.add(this.commentsBox);
        p.add(this.commentsArea);
        return UIUtilities.buildComponentPanel(p, 0, 0);
    }

    public JPanel buildNamePane() {
        JPanel p = new JPanel();
        p.add(this.nameBox);
        p.add(this.nameArea);
        return UIUtilities.buildComponentPanel(p, 0, 0);
    }

    private JPanel buildSelectionPane() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.buildTagsPane());
        p.add(new JSeparator(0));
        p.add(this.buildNamePane());
        p.add(new JSeparator(0));
        p.add(this.buildCommentsPane());
        p.add(new JSeparator(0));
        p.add(this.buildRatingPane());
        p.add(new JSeparator(0));
        p.add(this.buildRoiPane());
        p.add(new JSeparator(0));
        p.add(this.buildCalendarPane());
        p.add(new JSeparator(0));
        return p;
    }

    private JPanel buildToolBar() {
        JPanel p = new JPanel();
        p.add(this.filterButton);
        p.add(Box.createHorizontalStrut(5));
        p.add(this.cancelButton);
        return UIUtilities.buildComponentPanelRight(p);
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        c.add((Component)this.buildSelectionPane(), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    public FilteringDialog(JFrame owner) {
        super(owner);
        this.setProperties();
        this.initComponents();
        this.buildGUI();
        this.pack();
    }

    public void setTagsText(String text) {
        if (text == null) {
            return;
        }
        text = text.trim();
        this.tagsArea.getDocument().removeDocumentListener(this);
        this.tagsArea.setText(text);
        this.tagsArea.getDocument().addDocumentListener(this);
        this.tagsBox.setSelected(true);
    }

    public void setCommentsText(String text) {
        if (text == null) {
            return;
        }
        text = text.trim();
        this.commentsArea.setText(text);
        this.commentsBox.setSelected(true);
    }

    public void setRatingLevel(int value) {
        this.rating.setValue(value);
        this.ratingBox.setSelected(true);
    }

    public void setHasROIs() {
        this.roiSpinner.setValue(1);
        this.roiBox.setSelected(true);
        this.roiOptions.setSelectedIndex(0);
    }

    public void setNoROIs() {
        this.roiSpinner.setValue(0);
        this.roiBox.setSelected(true);
        this.roiOptions.setSelectedIndex(2);
    }

    public void unselectAll() {
        this.commentsBox.setSelected(false);
        this.nameBox.setSelected(false);
        this.ratingBox.setSelected(false);
        this.roiBox.setSelected(false);
        this.tagsBox.setSelected(false);
    }

    public void setTags(Collection tags, boolean notify) {
        if (tags == null) {
            return;
        }
        this.existingTags = tags;
        if (notify) {
            if (this.codeCompletion) {
                this.codeCompletion();
            } else {
                this.showTagsWizard();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.setVisible(false);
                break;
            }
            case 1: {
                this.filter();
                break;
            }
            case 2: {
                if (this.existingTags != null) {
                    this.showTagsWizard();
                    break;
                }
                this.codeCompletion = false;
                this.firePropertyChange(LOAD_TAG_PROPERTY, (Object)false, (Object)true);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selection".equals(name)) {
            Object item = evt.getNewValue();
            if (!(item instanceof TagItem)) {
                return;
            }
            DataObject ho = ((TagItem)item).getDataObject();
            if (ho instanceof TagAnnotationData) {
                this.enterTag((TagAnnotationData)ho, true);
            }
        } else if ("selectedItems".equals(name)) {
            Map m = (Map)evt.getNewValue();
            if (m == null || m.size() != 1) {
                return;
            }
            Set set = m.entrySet();
            for (Map.Entry entry : set) {
                Class type = (Class)entry.getKey();
                this.handleTagsSelection((Collection)entry.getValue());
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleTagInsert();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    static {
        FilteringDialog.COMPARISON_OPTIONS[0] = "greater or equal to";
        FilteringDialog.COMPARISON_OPTIONS[1] = "lower or equal to";
        FilteringDialog.COMPARISON_OPTIONS[2] = "equal to";
    }
}

