/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.GroupData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TableResult;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.dataBrowser.AnnotatedFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.CommentsFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.DataObjectCreator;
import org.openmicroscopy.shoola.agents.dataBrowser.DataObjectSaver;
import org.openmicroscopy.shoola.agents.dataBrowser.DatasetsLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.RateFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.ReportLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.TabularDataLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.TagsFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.TagsLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailsManager;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.Layout;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.LayoutFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.view.AdvancedResultSearchModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImageTableView;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SearchResultView;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellsModel;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.ResetThumbnailVisitor;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.util.FilterContext;

abstract class DataBrowserModel {
    static final int MAX_LOADER = 4;
    static final int DATASETS = 0;
    static final int IMAGES = 1;
    static final int PROJECTS = 2;
    static final int SEARCH = 3;
    static final int TAGSETS = 4;
    static final int WELLS = 5;
    static final int TAGS = 6;
    static final int PLATES = 7;
    static final int GROUP = 8;
    static final int FS_FOLDER = 9;
    protected int state = 1;
    private ThumbnailsManager thumbsManager;
    private ThumbnailsManager fullSizeThumbsManager;
    protected ViewerSorter sorter = new ViewerSorter();
    private DataBrowserLoader fieldsLoader;
    private DataBrowserLoader loader;
    private Collection existingTags;
    private Collection existingDatasets;
    private List<ApplicationData> applications;
    private ExperimenterData experimenter;
    protected boolean thumbnailLoaded;
    protected DataBrowser component;
    protected Browser browser;
    protected ImageTableView tableView;
    protected SearchResultView searchResultView;
    protected int numberOfImages;
    protected int imagesLoaded;
    protected Object parent;
    protected Object grandParent;
    protected SecurityContext ctx;
    protected int displayMode;

    private void checkDefaultDisplayMode() {
        Integer value = (Integer)DataBrowserAgent.getRegistry().lookup("DataDisplay");
        if (value == null) {
            this.setDisplayMode(1);
        } else {
            this.setDisplayMode(value);
        }
    }

    private boolean canRetrieveAll(Object ho) {
        GroupData group;
        if (!this.canAnnotate(ho)) {
            return false;
        }
        long groupID = -1L;
        if (ho instanceof DataObject) {
            DataObject data = (DataObject)ho;
            groupID = data.getGroupId();
        }
        if ((group = this.getGroup(groupID)) == null) {
            return false;
        }
        if (1 == group.getPermissions().getPermissionsLevel()) {
            if (DataBrowserAgent.isAdministrator()) {
                return true;
            }
            Set leaders = group.getLeaders();
            Iterator i = leaders.iterator();
            long userID = this.getCurrentUser().getId();
            while (i.hasNext()) {
                ExperimenterData exp = (ExperimenterData)i.next();
                if (exp.getId() != userID) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    ExperimenterData getCurrentUser() {
        return DataBrowserAgent.getUserDetails();
    }

    DataBrowserModel(SecurityContext ctx) {
        this.ctx = ctx;
        this.checkDefaultDisplayMode();
    }

    boolean canAnnotate(Object ho) {
        long id = DataBrowserAgent.getUserDetails().getId();
        boolean b = EditorUtil.isUserOwner(ho, id);
        if (b) {
            return b;
        }
        if (!(ho instanceof DataObject)) {
            return false;
        }
        DataObject data = (DataObject)ho;
        return data.canAnnotate();
    }

    Object getParent() {
        return this.parent;
    }

    Object getExperimenter() {
        return this.experimenter;
    }

    int getNumberOfImages() {
        return this.numberOfImages;
    }

    ViewerSorter getSorter() {
        return this.sorter;
    }

    void layoutBrowser() {
        this.layoutBrowser(1);
    }

    void layoutBrowser(int type) {
        if (this.browser == null) {
            return;
        }
        if (this.browser.getSelectedLayout() == null) {
            Layout layout = LayoutFactory.createLayout(type, this.sorter, 0);
            this.browser.setSelectedLayout(layout);
        }
        this.browser.accept(this.browser.getSelectedLayout());
    }

    ImageTableView createImageTableView() {
        if (this.tableView != null) {
            return this.tableView;
        }
        this.tableView = new ImageTableView(this, (ImageDisplay)this.browser.getUI());
        return this.tableView;
    }

    SearchResultView createSearchResultView() {
        if (this.searchResultView != null) {
            return this.searchResultView;
        }
        this.searchResultView = new SearchResultView((ImageDisplay)this.browser.getUI(), (AdvancedResultSearchModel)this);
        return this.searchResultView;
    }

    int getState() {
        return this.state;
    }

    void loadData(boolean refresh, Collection ids) {
        List<DataBrowserLoader> loaders;
        if (refresh) {
            this.browser.accept(new ResetThumbnailVisitor(ids), 0);
        }
        if ((loaders = this.createDataLoader(refresh, ids)) == null) {
            this.state = 3;
            return;
        }
        this.state = 2;
        Iterator<DataBrowserLoader> i = loaders.iterator();
        while (i.hasNext()) {
            i.next().load();
        }
    }

    boolean loadFields(int row, int column) {
        if (!(this instanceof WellsModel)) {
            return false;
        }
        this.fieldsLoader = ((WellsModel)this).createFieldsLoader(Arrays.asList(new Point(row, column)));
        if (this.fieldsLoader == null) {
            return false;
        }
        this.fieldsLoader.load();
        return true;
    }

    boolean loadFields(List<Point> fields) {
        if (!(this instanceof WellsModel)) {
            return false;
        }
        this.fieldsLoader = ((WellsModel)this).createFieldsLoader(fields);
        if (this.fieldsLoader == null) {
            return false;
        }
        this.fieldsLoader.load();
        return true;
    }

    void cancelFieldsLoading() {
        if (this.fieldsLoader != null) {
            this.fieldsLoader.cancel();
        }
    }

    void setGrandParent(Object grandParent) {
        this.grandParent = grandParent;
    }

    Object getGrandParent() {
        return this.grandParent;
    }

    Browser getBrowser() {
        return this.browser;
    }

    ImageTableView getTableView() {
        return this.tableView;
    }

    SearchResultView getSearchView() {
        return this.searchResultView;
    }

    void initialize(DataBrowser component) {
        this.component = component;
    }

    int setThumbnail(Object ref, BufferedImage thumb, boolean valid, int maxEntries) {
        if (this.thumbsManager == null) {
            this.thumbsManager = this.getType() == 5 ? new ThumbnailsManager(this.getNodes(), maxEntries) : new ThumbnailsManager(this.browser.getVisibleImageNodes(), maxEntries);
        }
        this.thumbsManager.setThumbnail(ref, thumb, valid);
        int perc = this.thumbsManager.getPercentDone();
        if (this.thumbsManager.isDone()) {
            this.state = 3;
            this.thumbsManager = null;
        }
        return perc;
    }

    boolean setSlideViewImage(long imageID, BufferedImage thumb) {
        if (this.fullSizeThumbsManager != null) {
            this.fullSizeThumbsManager.setFullSizeImage(imageID, thumb);
            if (this.fullSizeThumbsManager.isDone()) {
                this.state = 3;
                this.fullSizeThumbsManager = null;
                return true;
            }
        }
        return false;
    }

    void discard() {
    }

    void cancelFiltering() {
    }

    void cancelSlideShow() {
    }

    void setState(int state) {
        this.state = state;
    }

    void fireFilteringByRate(int rate, Set nodes) {
        this.state = 4;
        RateFilter loader = new RateFilter(this.component, this.ctx, rate, nodes);
        loader.load();
    }

    void fireFilteringByTags(List<String> tags, Set<DataObject> nodes) {
        this.state = 4;
        TagsFilter loader = new TagsFilter(this.component, this.ctx, tags, nodes);
        loader.load();
    }

    void fireFilteringByComments(List<String> comments, Set<DataObject> nodes) {
        this.state = 4;
        CommentsFilter loader = new CommentsFilter(this.component, this.ctx, comments, nodes);
        loader.load();
    }

    void fireFilteringByContext(FilterContext context, Set<DataObject> nodes) {
        this.state = 4;
        DataFilter loader = new DataFilter(this.component, this.ctx, context, nodes);
        loader.load();
    }

    void fireFilteringByAnnotated(Class annotationType, boolean annotated, Set<DataObject> nodes) {
        this.state = 4;
        AnnotatedFilter loader = new AnnotatedFilter(this.component, this.ctx, annotationType, annotated, nodes);
        loader.load();
    }

    void fireTagsLoading() {
        this.state = 2;
        TagsLoader loader = new TagsLoader(this.component, this.ctx, this.canRetrieveAll(this.parent));
        loader.load();
    }

    void fireExisitingDatasetsLoading() {
        DatasetsLoader loader = new DatasetsLoader(this.component, this.ctx);
        loader.load();
    }

    void fireFullSizeLoading(Collection<ImageNode> images) {
        HashSet<DataObject> nodes = new HashSet<DataObject>();
        HashSet<ImageNode> toKeep = new HashSet<ImageNode>();
        for (ImageNode node : images) {
            if (node.getThumbnail().getFullSizeImage() != null) continue;
            nodes.add((DataObject)node.getHierarchyObject());
            toKeep.add(node);
        }
        if (nodes.size() > 0) {
            this.fullSizeThumbsManager = new ThumbnailsManager(toKeep, toKeep.size());
            ThumbnailLoader loader = new ThumbnailLoader(this.component, this.ctx, nodes, false, 0, nodes.size());
            loader.load();
            this.state = 6;
        }
    }

    void fireDataSaving(DataObject data, Collection images) {
        TagAnnotationData tag;
        DataObject p = null;
        if (this.parent instanceof DataObject) {
            p = (DataObject)this.parent;
        }
        if (this.grandParent != null && this.grandParent instanceof DataObject) {
            p = (DataObject)this.grandParent;
        }
        if (data instanceof DatasetData) {
            if (!(p instanceof ProjectData)) {
                p = null;
            }
        } else if (data instanceof TagAnnotationData && p instanceof TagAnnotationData && !"openmicroscopy.org/omero/insight/tagset".equals((tag = (TagAnnotationData)p).getNameSpace())) {
            p = null;
        }
        DataObjectCreator loader = new DataObjectCreator(this.component, this.ctx, p, data, images);
        loader.load();
    }

    void fireDataSaving(Collection datasets, Collection images) {
        DataObjectSaver loader = new DataObjectSaver(this.component, this.ctx, datasets, images);
        loader.load();
    }

    void fireReportLoading(Collection images, List<Class> types, String name) {
        ReportLoader loader = new ReportLoader(this.component, this.ctx, types, this.sorter.sort(images), name);
        loader.load();
    }

    void setTags(Collection tags) {
        if (tags == null) {
            return;
        }
        Iterator i = tags.iterator();
        ArrayList<TagAnnotationData> l = new ArrayList<TagAnnotationData>();
        while (i.hasNext()) {
            TagAnnotationData tag = (TagAnnotationData)i.next();
            String ns = tag.getNameSpace();
            if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) continue;
            l.add(tag);
        }
        this.existingTags = this.sorter.sort(l);
    }

    void setExistingDatasets(Collection datasets) {
        this.existingDatasets = datasets;
    }

    Collection getExistingDatasets() {
        return this.existingDatasets;
    }

    boolean isImagesModel() {
        switch (this.getType()) {
            case 0: 
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    Collection getExistingTags() {
        return this.existingTags;
    }

    boolean isRollOver() {
        return this.browser.isRollOver();
    }

    boolean canLinkParent() {
        if (DataBrowserAgent.isAdministrator()) {
            return true;
        }
        switch (this.getDisplayMode()) {
            case 0: {
                if (this.parent == null || !(this.parent instanceof DataObject)) {
                    return false;
                }
                return ((DataObject)this.parent).canLink();
            }
        }
        long userID = DataBrowserAgent.getUserDetails().getId();
        if (this.parent == null) {
            if (this.experimenter == null) {
                return false;
            }
            return this.experimenter.getId() == userID;
        }
        if (!(this.parent instanceof DataObject)) {
            if (this.experimenter == null) {
                return false;
            }
            return this.experimenter.getId() == userID;
        }
        return EditorUtil.isUserOwner(this.parent, userID);
    }

    List sortCollection(Collection collection) {
        return this.sorter.sort(collection);
    }

    void setApplicationData(List<ApplicationData> applications) {
        this.applications = applications;
    }

    void setExperimenter(ExperimenterData experimenter) {
        this.experimenter = experimenter;
    }

    List<ApplicationData> getApplications() {
        return this.applications;
    }

    void fireTabularDataLoading(List<FileAnnotationData> data) {
        TabularDataLoader loader = null;
        if (data == null) {
            if (this instanceof WellsModel) {
                if (this.grandParent instanceof ScreenData) {
                    loader = new TabularDataLoader(this.component, this.ctx, (DataObject)this.grandParent, this.canRetrieveAll(this.grandParent));
                    loader.load();
                    if (this.parent instanceof PlateData) {
                        loader = new TabularDataLoader(this.component, this.ctx, (DataObject)this.parent, this.canRetrieveAll(this.parent));
                        loader.load();
                    }
                } else if (this.parent instanceof PlateData) {
                    loader = new TabularDataLoader(this.component, this.ctx, (DataObject)this.parent, this.canRetrieveAll(this.parent));
                    loader.load();
                }
            }
        } else if (data.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            Iterator<FileAnnotationData> i = data.iterator();
            while (i.hasNext()) {
                ids.add(i.next().getFileID());
            }
            loader = new TabularDataLoader(this.component, this.ctx, ids, this.canRetrieveAll(this.parent));
            loader.load();
        }
    }

    void setTabularData(List<TableResult> data) {
        if (this instanceof WellsModel) {
            ((WellsModel)this).setTabularData(data);
        }
    }

    int getLayoutIndex() {
        Browser b = this.getBrowser();
        if (b == null) {
            return 1;
        }
        Layout layout = b.getSelectedLayout();
        if (layout == null) {
            return 1;
        }
        return layout.getIndex();
    }

    SecurityContext getSecurityContext() {
        return this.ctx;
    }

    boolean isSingleGroup() {
        Collection l = DataBrowserAgent.getAvailableUserGroups();
        return l.size() <= 1;
    }

    GroupData getGroup(long groupId) {
        Collection groups = DataBrowserAgent.getAvailableUserGroups();
        if (groups == null) {
            return null;
        }
        for (GroupData group : groups) {
            if (group.getId() != groupId) continue;
            return group;
        }
        return null;
    }

    int getDisplayMode() {
        return this.displayMode;
    }

    boolean hasThumbnailsBeenLoaded() {
        return this.loader != null;
    }

    void setDisplayMode(int value) {
        if (value < 0) {
            this.checkDefaultDisplayMode();
            return;
        }
        switch (value) {
            case 0: 
            case 1: {
                this.displayMode = value;
                break;
            }
            default: {
                this.displayMode = 1;
            }
        }
        if (this.existingDatasets != null) {
            this.existingDatasets.clear();
            this.setExistingDatasets(null);
        }
        if (this.existingTags != null) {
            this.existingTags.clear();
            this.setTags(null);
        }
    }

    List<DataBrowserLoader> createThumbnailsLoader(List<DataObject> images) {
        if (images == null) {
            return null;
        }
        ArrayList<DataBrowserLoader> loaders = new ArrayList<DataBrowserLoader>();
        int n = images.size();
        int diff = n / 4;
        int step = 0;
        if (n < 4) {
            diff = 1;
        }
        for (int k = 0; k < 4; ++k) {
            List<Object> l = new ArrayList();
            int j = step + diff;
            if (k == 3) {
                j += n - j;
            }
            if (j <= n) {
                l = images.subList(step, j);
                step += l.size();
            }
            if (l.size() <= 0) continue;
            loaders.add(new ThumbnailLoader(this.component, this.ctx, l, n));
        }
        return loaders;
    }

    boolean isSystemUser(long id) {
        return DataBrowserAgent.getRegistry().getAdminService().isSystemUser(id);
    }

    boolean isSystemUser(long id, String key) {
        return DataBrowserAgent.getRegistry().getAdminService().isSystemUser(id, key);
    }

    boolean isSystemGroup(long id, String key) {
        return DataBrowserAgent.getRegistry().getAdminService().isSecuritySystemGroup(id, key);
    }

    protected abstract List<DataBrowserLoader> createDataLoader(boolean var1, Collection var2);

    protected abstract int getType();

    protected abstract List<ImageDisplay> getNodes();
}

