/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserTranslator;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;

class SearchModel
extends DataBrowserModel {
    private Map<SecurityContext, Collection<DataObject>> results;

    SearchModel(Map<SecurityContext, Collection<DataObject>> results) {
        super(null);
        if (results == null) {
            throw new IllegalArgumentException("No results.");
        }
        this.results = results;
        this.numberOfImages = 0;
        HashSet<ImageDisplay> vis = new HashSet<ImageDisplay>();
        Iterator<Map.Entry<SecurityContext, Collection<DataObject>>> i = results.entrySet().iterator();
        boolean singleGroup = this.isSingleGroup();
        while (i.hasNext()) {
            SecurityContext ctx;
            Map.Entry<SecurityContext, Collection<DataObject>> e = i.next();
            this.ctx = ctx = e.getKey();
            Collection<DataObject> objects = e.getValue();
            this.numberOfImages += objects.size();
            if (singleGroup) {
                vis.addAll(DataBrowserTranslator.transformObjects(objects));
                continue;
            }
            GroupData g = this.getGroup(ctx.getGroupID());
            if (g == null || objects == null || objects.size() <= 0) continue;
            vis.add(DataBrowserTranslator.transformObjects(objects, g));
        }
        this.browser = BrowserFactory.createBrowser(vis);
    }

    @Override
    void loadData(boolean refresh, Collection ids) {
        List imgs;
        long groupId;
        ImageData image;
        ImageNode node;
        if (refresh) {
            this.imagesLoaded = 0;
        }
        if (this.imagesLoaded != 0 && ids != null) {
            this.imagesLoaded -= ids.size();
        }
        if (this.imagesLoaded == this.numberOfImages) {
            return;
        }
        HashMap map = new HashMap();
        List<ImageNode> nodes = this.browser.getVisibleImageNodes();
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        Iterator<ImageNode> i = nodes.iterator();
        if (ids != null) {
            while (i.hasNext()) {
                node = i.next();
                ImageData img = (ImageData)node.getHierarchyObject();
                if (!ids.contains(img.getId()) || node.getThumbnail().getFullScaleThumb() != null) continue;
                image = (ImageData)node.getHierarchyObject();
                groupId = image.getGroupId();
                if (!map.containsKey(groupId)) {
                    map.put(groupId, new ArrayList());
                }
                imgs = (List)map.get(groupId);
                imgs.add(image);
                ++this.imagesLoaded;
            }
        } else {
            while (i.hasNext()) {
                node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null) continue;
                image = (ImageData)node.getHierarchyObject();
                groupId = image.getGroupId();
                if (!map.containsKey(groupId)) {
                    map.put(groupId, new ArrayList());
                }
                imgs = (List)map.get(groupId);
                imgs.add(image);
                ++this.imagesLoaded;
            }
        }
        if (map.size() == 0) {
            return;
        }
        for (Map.Entry e : map.entrySet()) {
            List l = this.sorter.sort((Collection)e.getValue());
            ThumbnailLoader loader = new ThumbnailLoader(this.component, new SecurityContext(((Long)e.getKey()).longValue()), l, l.size());
            ((DataBrowserLoader)loader).load();
        }
        this.state = 2;
    }

    @Override
    protected List<DataBrowserLoader> createDataLoader(boolean refresh, Collection ids) {
        return null;
    }

    @Override
    protected int getType() {
        return 3;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return null;
    }
}

