/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import org.jdesktop.swingx.JXTable;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.view.AdvancedResultSearchModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SearchResultTableModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SearchResultView;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImageObject;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class SearchResultTable
extends JXTable {
    private AdvancedResultSearchModel model;
    private List<DataObject> data;
    private SearchResultView parent;

    public SearchResultTable(SearchResultView parent, List<DataObject> data, AdvancedResultSearchModel browserModel) {
        this.parent = parent;
        this.data = data;
        this.model = browserModel;
        this.model.registerTable(this);
        this.initTable();
    }

    public void initTable() {
        MyRenderer defaultRenderer = new MyRenderer();
        this.setDefaultRenderer(DataObject.class, defaultRenderer);
        this.setDefaultRenderer(String.class, defaultRenderer);
        this.setDefaultRenderer(Icon.class, defaultRenderer);
        this.setDefaultEditor(DataObject.class, new DataObjectEditor());
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setRowHeight(42);
        this.getTableHeader().setReorderingAllowed(false);
        this.getSelectionModel().setSelectionMode(2);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                List<DataObject> selectedObjs = SearchResultTable.this.getSelectedObjects();
                if (!selectedObjs.isEmpty()) {
                    if (!this.isSelectionValid(selectedObjs)) {
                        UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
                        un.notifyInfo("Invalid Selection", "A selection of items of different groups is not supported.");
                        SearchResultTable.this.getSelectionModel().clearSelection();
                        return;
                    }
                    SearchResultTable.this.parent.fireSelectionEvent(selectedObjs);
                }
            }

            boolean isSelectionValid(List<DataObject> selectedObjs) {
                long groupId = -1L;
                for (DataObject obj : selectedObjs) {
                    if (groupId == -1L) {
                        groupId = obj.getGroupId();
                        continue;
                    }
                    if (groupId == obj.getGroupId()) continue;
                    return false;
                }
                return true;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e = SwingUtilities.convertMouseEvent((Component)e.getSource(), e, (Component)((Object)SearchResultTable.this));
                Point p = e.getPoint();
                if (e.getButton() == 3) {
                    SearchResultTable.this.parent.firePopupEvent(p);
                }
            }
        });
    }

    public List<DataObject> getSelectedObjects() {
        ArrayList<DataObject> selectedObjs = new ArrayList<DataObject>();
        for (int row : this.getSelectedRows()) {
            row = this.convertRowIndexToModel(row);
            DataObject obj = (DataObject)this.getModel().getValueAt(row, SearchResultTableModel.VIEWBUTTON_COLUMN_INDEX);
            if (obj == null) continue;
            selectedObjs.add(obj);
        }
        return selectedObjs;
    }

    public void refreshTable() {
        this.setModel(new SearchResultTableModel(this, this.data, this.model));
        this.getColumnExt(SearchResultTableModel.VIEWBUTTON_COLUMN_INDEX).setSortable(false);
        int wI = 80;
        int wB = 140;
        this.getColumn(0).setMinWidth(wI);
        this.getColumn(0).setMaxWidth(wI);
        this.getColumn(0).setPreferredWidth(wI);
        this.getColumn(0).setWidth(wI);
        this.getColumn(4).setMinWidth(wB);
        this.getColumn(4).setMaxWidth(wB);
        this.getColumn(4).setPreferredWidth(wB);
        this.getColumn(4).setWidth(wB);
    }

    private JButton createActionButton(final DataObject obj) {
        JButton button = null;
        if (obj instanceof ImageData) {
            button = new JButton("View");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageData img = (ImageData)obj;
                    ViewImage ev = new ViewImage(new SecurityContext(obj.getGroupId()), new ViewImageObject((DataObject)img), null);
                    ImViewerAgent.getRegistry().getEventBus().post(ev);
                }
            });
        }
        return button;
    }

    class DataObjectEditor
    implements TableCellEditor {
        @Override
        public void addCellEditorListener(CellEditorListener arg0) {
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject arg0) {
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener arg0) {
        }

        @Override
        public boolean shouldSelectCell(EventObject arg0) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            JPanel p = new JPanel();
            if (arg2) {
                p.setBackground(UIUtilities.SELECTED_BACKGROUND_COLOUR);
            } else {
                p.setBackground(arg3 % 2 == 0 ? UIUtilities.BACKGROUND_COLOUR_EVEN : UIUtilities.BACKGROUND_COLOUR_ODD);
            }
            DataObject dataObj = (DataObject)arg1;
            JButton b = SearchResultTable.this.createActionButton(dataObj);
            if (b != null) {
                p.add(b);
            }
            return p;
        }
    }

    class MyRenderer
    extends DefaultTableCellRenderer {
        MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JPanel p = new JPanel();
            if (isSelected) {
                p.setBackground(UIUtilities.SELECTED_BACKGROUND_COLOUR);
            } else {
                p.setBackground(row % 2 == 0 ? UIUtilities.BACKGROUND_COLOUR_EVEN : UIUtilities.BACKGROUND_COLOUR_ODD);
            }
            if (value == null) {
                JLabel l = new JLabel("--");
                p.add(l);
            } else if (value instanceof DataObject) {
                DataObject dataObj = (DataObject)value;
                JButton b = SearchResultTable.this.createActionButton(dataObj);
                if (b != null) {
                    p.add(b);
                }
            } else if (value instanceof Icon) {
                JLabel l = new JLabel((Icon)value);
                p.add(l);
            } else if (value instanceof Date) {
                JLabel l = new JLabel(UIUtilities.formatDefaultDate((Date)value));
                p.add(l);
            } else {
                String s = value.toString();
                if (s.matches(".*\\<.*\\>.*")) {
                    s = "<html>" + s + "</html>";
                }
                JLabel l = new JLabel(s);
                p.add(l);
                if (column == 1) {
                    p.setLayout(new FlowLayout(0));
                }
            }
            return p;
        }
    }
}

