/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.Timer;
import org.openmicroscopy.shoola.agents.dataBrowser.Colors;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SlideShowUI;
import org.openmicroscopy.shoola.agents.util.ui.RollOverThumbnailManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class SlideShowView
extends JDialog
implements ActionListener,
MouseListener,
PropertyChangeListener {
    static final String CLOSE_SLIDE_VIEW_PROPERTY = "closeSlideView";
    private static final int DELAY_MEDIUM = 2000;
    private static final int DELAY_SLOW = 3000;
    private static final int DELAY_FAST = 1000;
    private static final int SLOW_SPEED = 0;
    private static final int MEDIUM_SPEED = 1;
    private static final int FAST_SPEED = 2;
    private static final int SPEED = 10;
    private static final int PAUSE = 11;
    private static final int PLAY_FORWARD = 12;
    private static final int PLAY_BACKWARD = 13;
    private static final int PREVIOUS = 14;
    private static final int NEXT = 15;
    public static final int START = 0;
    public static final int STOP = 1;
    private static final String[] SPEEDS = new String[3];
    private List<ImageNode> nodes;
    private JButton next;
    private JButton previous;
    private JButton pause;
    private JToggleButton forwardPlay;
    private JToggleButton backwardPlay;
    private JComboBox speeds;
    private int selectedNodeIndex;
    private Timer timer;
    private int state;
    private int delay;
    private int playingIndex;
    private JSplitPane pane;
    private JScrollPane nodePane;
    private SlideShowUI uiDelegate;
    private Map<ImageNode, Integer> nodesMap;

    private ImageDisplay findParentDisplay(Object x) {
        while (true) {
            if (x instanceof ImageDisplay) {
                return (ImageDisplay)x;
            }
            if (!(x instanceof JComponent)) break;
            x = ((JComponent)x).getParent();
        }
        return null;
    }

    private void initComponents() {
        this.nodesMap = new HashMap<ImageNode, Integer>();
        IconManager icons = IconManager.getInstance();
        this.previous = new JButton(icons.getIcon(12));
        this.previous.setActionCommand("14");
        this.previous.addActionListener(this);
        UIUtilities.unifiedButtonLookAndFeel(this.previous);
        this.next = new JButton(icons.getIcon(13));
        this.next.setActionCommand("15");
        this.next.addActionListener(this);
        UIUtilities.unifiedButtonLookAndFeel(this.next);
        this.pause = new JButton(icons.getIcon(9));
        this.pause.setActionCommand("11");
        this.pause.addActionListener(this);
        this.pause.setEnabled(false);
        this.forwardPlay = new JToggleButton(icons.getIcon(10));
        this.forwardPlay.setActionCommand("12");
        this.forwardPlay.addActionListener(this);
        this.forwardPlay.setEnabled(false);
        this.backwardPlay = new JToggleButton(icons.getIcon(11));
        this.backwardPlay.setActionCommand("13");
        this.backwardPlay.addActionListener(this);
        this.backwardPlay.setEnabled(false);
        this.speeds = new JComboBox<String>(SPEEDS);
        this.speeds.setSelectedIndex(1);
        this.speeds.addActionListener(this);
        this.speeds.setActionCommand("10");
        this.delay = 2000;
        this.timer = new Timer(this.delay, this);
        this.timer.setInitialDelay(this.delay / 10);
        this.timer.setCoalesce(true);
        this.state = 1;
        this.playingIndex = -1;
        this.selectedNodeIndex = 0;
        this.uiDelegate = new SlideShowUI(this);
        this.pane = new JSplitPane();
        this.pane.setOrientation(0);
        this.pane.setOneTouchExpandable(true);
        this.pane.setContinuousLayout(true);
        this.pane.setTopComponent(this.uiDelegate);
        this.pane.setResizeWeight(1.0);
        this.pane.setBackground(UIUtilities.BACKGROUND);
    }

    private void attachWindowListener() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SlideShowView.this.stop();
                SlideShowView.this.firePropertyChange(SlideShowView.CLOSE_SLIDE_VIEW_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            }
        });
    }

    private void setSpeed() {
        switch (this.speeds.getSelectedIndex()) {
            case 0: {
                this.delay = 3000;
                break;
            }
            case 1: {
                this.delay = 2000;
                break;
            }
            case 2: {
                this.delay = 1000;
            }
        }
        this.timer.setDelay(this.delay);
        this.timer.setInitialDelay(this.delay);
    }

    private void play(int index) {
        if (index == this.playingIndex) {
            return;
        }
        if (this.state == 0) {
            this.stop();
        }
        this.playingIndex = index;
        this.forwardPlay.setSelected(this.playingIndex == 12);
        this.backwardPlay.setSelected(this.playingIndex == 13);
        this.state = 0;
        this.timer.start();
    }

    private void stop() {
        if (this.timer == null) {
            return;
        }
        if (this.state == 1) {
            return;
        }
        this.playingIndex = -1;
        this.state = 1;
        this.forwardPlay.setSelected(false);
        this.backwardPlay.setSelected(false);
        this.timer.stop();
    }

    private void setNodeColor(ImageNode node) {
        Iterator<ImageNode> i = this.nodes.iterator();
        Colors colors = Colors.getInstance();
        while (i.hasNext()) {
            ImageNode n = i.next();
            if (n == node) continue;
            n.setHighlight(colors.getColor(1));
            n.repaint();
        }
        node.setHighlight(colors.getColor(0));
        node.repaint();
    }

    private void paintImage() {
        ImageNode node = this.nodes.get(this.selectedNodeIndex);
        if (node == null) {
            return;
        }
        this.setTitle("Slideshow " + node.toString());
        this.uiDelegate.paintImage(node.getThumbnail().getFullSizeImage());
        this.setNodeColor(node);
        Rectangle viewRect = this.nodePane.getViewport().getViewRect();
        Rectangle bounds = node.getBounds();
        if (!viewRect.contains(bounds)) {
            this.nodePane.getVerticalScrollBar().setValue(bounds.y);
            this.nodePane.getHorizontalScrollBar().setValue(bounds.x);
        }
    }

    private JPanel buildToolBar() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0, 5, 0));
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setBorder(null);
        bar.add(this.backwardPlay);
        bar.add(this.pause);
        bar.add(this.forwardPlay);
        p.add(bar);
        JPanel speed = new JPanel();
        speed.setLayout(new FlowLayout(0, 5, 0));
        speed.add(new JLabel("Speed:"));
        speed.add(this.speeds);
        p.add(speed);
        return p;
    }

    private JComponent buildBottomBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setBorder(null);
        bar.add(this.previous);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.next);
        return UIUtilities.buildComponentPanelCenter(bar);
    }

    private JComponent buildNodesPane() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND);
        Iterator<ImageNode> i = this.nodes.iterator();
        int index = 0;
        while (i.hasNext()) {
            ImageNode node = i.next();
            node.setListenToBorder(false);
            node.addListenerToComponents(this);
            this.nodesMap.put(node, index);
            p.add(node);
            ++index;
        }
        this.nodePane = new JScrollPane(p);
        return this.nodePane;
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        this.pane.setBottomComponent(this.buildNodesPane());
        c.add((Component)this.pane, "Center");
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JPanel bar = this.buildToolBar();
        p.add((Component)bar, "Before");
        p.add((Component)this.buildBottomBar(), "Center");
        Dimension d = bar.getPreferredSize();
        p.add(Box.createHorizontalStrut(d.width), "After");
        c.add((Component)p, "South");
    }

    SlideShowView(JFrame parent, List<ImageNode> nodes) {
        super(parent);
        this.setTitle("Slideshow");
        this.nodes = nodes;
        this.initComponents();
        this.buildGUI();
        this.attachWindowListener();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = 6 * (screenSize.width / 10);
        int height = 6 * (screenSize.height / 10);
        this.setSize(width, height);
    }

    void setProgress(boolean hide, int value) {
        this.uiDelegate.setProgress(hide, value);
        if (hide) {
            this.pause.setEnabled(true);
            this.forwardPlay.setEnabled(true);
            this.backwardPlay.setEnabled(true);
            this.paintImage();
        }
        this.pane.revalidate();
        this.pane.repaint();
    }

    void close() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.timer) {
            int size = this.nodes.size();
            switch (this.playingIndex) {
                case 12: {
                    ++this.selectedNodeIndex;
                    if (this.selectedNodeIndex != size) break;
                    this.selectedNodeIndex = 0;
                    break;
                }
                case 13: {
                    if (this.selectedNodeIndex == 0) {
                        this.selectedNodeIndex = size;
                    }
                    --this.selectedNodeIndex;
                }
            }
            this.paintImage();
            return;
        }
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 11: {
                this.stop();
                break;
            }
            case 13: {
                this.play(13);
                break;
            }
            case 12: {
                this.play(12);
                break;
            }
            case 10: {
                this.setSpeed();
                break;
            }
            case 15: {
                ++this.selectedNodeIndex;
                if (this.selectedNodeIndex == this.nodes.size()) {
                    this.selectedNodeIndex = 0;
                }
                this.paintImage();
                break;
            }
            case 14: {
                if (this.selectedNodeIndex == 0) {
                    this.selectedNodeIndex = this.nodes.size();
                }
                --this.selectedNodeIndex;
                this.paintImage();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selectNext".equals(name)) {
            ++this.selectedNodeIndex;
            if (this.selectedNodeIndex == this.nodes.size()) {
                this.selectedNodeIndex = 0;
            }
            this.paintImage();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Object src = e.getSource();
        ImageDisplay n = this.findParentDisplay(src);
        if (n != null && n instanceof ImageNode) {
            ImageNode node = (ImageNode)n;
            Thumbnail prv = node.getThumbnail();
            BufferedImage full = prv.getFullScaleThumb();
            if (prv.getScalingFactor() == 2.5) {
                full = prv.getZoomedFullScaleThumb();
            }
            RollOverThumbnailManager.rollOverDisplay(full, node.getBounds(), node.getLocationOnScreen(), node.toString());
        } else {
            RollOverThumbnailManager.stopOverDisplay();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        RollOverThumbnailManager.stopOverDisplay();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ImageDisplay node = this.findParentDisplay(e.getSource());
        if (node == null) {
            return;
        }
        Integer value = this.nodesMap.get(node);
        if (value != null) {
            this.selectedNodeIndex = value;
            this.paintImage();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Object src = e.getSource();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    static {
        SlideShowView.SPEEDS[0] = "slow";
        SlideShowView.SPEEDS[1] = "medium";
        SlideShowView.SPEEDS[2] = "fast";
    }
}

