/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.visitor;

import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.dataBrowser.Colors;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;

public class FilesetVisitor
implements ImageDisplayVisitor {
    private final Collection<ImageData> selected;
    private final Collection<ImageData> deselected;
    private final Color borderColor;
    private final Set<Long> filesetIds;

    public FilesetVisitor(Collection<ImageData> selected, Collection<ImageData> deselected) {
        this.selected = selected;
        this.deselected = deselected;
        this.borderColor = Colors.getInstance().getColor(0).brighter();
        this.filesetIds = new HashSet<Long>();
        if (selected != null) {
            for (ImageData img : selected) {
                if (!img.isFSImage()) continue;
                this.filesetIds.add(img.getFilesetId());
            }
        }
    }

    @Override
    public void visit(ImageNode node) {
        Object ho = node.getHierarchyObject();
        if (!(ho instanceof ImageData)) {
            return;
        }
        ImageData data = (ImageData)ho;
        if (this.selected != null) {
            for (ImageData ref : this.selected) {
                if (!ref.isFSImage() || data.getId() == ref.getId() || data.getFilesetId() != ref.getFilesetId()) continue;
                node.setBorderColor(this.borderColor);
            }
        }
        if (this.deselected != null) {
            for (ImageData ref : this.deselected) {
                if (!ref.isFSImage() || data.getFilesetId() != ref.getFilesetId() || this.filesetIds.contains(data.getFilesetId())) continue;
                node.setBorderColor(null);
            }
        }
    }

    @Override
    public void visit(ImageSet node) {
    }
}

