/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter;

import java.util.Map;
import omero.log.LogMessage;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.fsimporter.DataImporterLoader;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class ImagesImporter
extends DataImporterLoader {
    private CallHandle handle;
    private ImportableObject context;
    private Integer loaderID;

    public ImagesImporter(Importer viewer, ImportableObject context, Integer loaderID) {
        super(viewer, null);
        if (context == null || CollectionUtils.isEmpty(context.getFiles())) {
            throw new IllegalArgumentException("No Files to import.");
        }
        this.context = context;
        this.loaderID = loaderID;
    }

    public ImportableObject getImportableObject() {
        return this.context;
    }

    @Override
    public void load() {
        this.handle = this.ivView.importFiles(this.context, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        if (this.viewer.getState() == 5) {
            return;
        }
        Map m = (Map)fe.getPartialResult();
        if (m != null) {
            for (Map.Entry entry : m.entrySet()) {
                this.viewer.uploadComplete((ImportableFile)entry.getKey(), entry.getValue(), this.loaderID);
            }
        }
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "Data Import Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyError("Data Import Failure", s, exc);
        this.viewer.cancelImport(this.loaderID);
    }

    @Override
    public void handleNullResult() {
    }
}

