/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.fsimporter.IconManager;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.actions.ImporterAction;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class PersonalManagementAction
extends ImporterAction
implements MouseListener {
    private static final String DESCRIPTION = "Select the group you wish to import the data to.";
    private Point point;
    private IconManager icons = IconManager.getInstance();

    private void setPermissions() {
        GroupData group = this.model.getSelectedGroup();
        String name = "";
        String desc = DESCRIPTION;
        Icon icon = this.icons.getIcon(26);
        if (group != null) {
            name = group.getName();
            switch (group.getPermissions().getPermissionsLevel()) {
                case 0: {
                    desc = "Private Group";
                    icon = this.icons.getIcon(27);
                    break;
                }
                case 1: {
                    desc = "Collaborators can only read your data.";
                    icon = this.icons.getIcon(28);
                    break;
                }
                case 2: {
                    desc = "Collaborators can read and annotate your data.";
                    icon = this.icons.getIcon(29);
                    break;
                }
                case 3: {
                    desc = "Collaborators can read, annotate, delete, etc., your data.";
                    icon = this.icons.getIcon(35);
                    break;
                }
                case 4: {
                    desc = "Public";
                    icon = this.icons.getIcon(30);
                    break;
                }
                case 5: {
                    desc = "Public";
                    icon = this.icons.getIcon(30);
                }
            }
        }
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(desc));
    }

    @Override
    protected void onStateChange() {
        if (this.model.getState() == 4) {
            this.setEnabled(false);
        } else {
            this.setEnabled(ImporterAgent.getAvailableUserGroups().size() > 1);
        }
    }

    public PersonalManagementAction(Importer model) {
        super(model);
        this.setPermissions();
        this.setEnabled(ImporterAgent.getAvailableUserGroups().size() > 1);
        model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("changedGroup".equals(name)) {
                    PersonalManagementAction.this.setPermissions();
                }
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        Object source = me.getSource();
        if (this.point == null) {
            this.point = me.getPoint();
        }
        if (source instanceof Component && this.isEnabled()) {
            this.model.showMenu(100, (Component)source, this.point);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

