/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import org.openmicroscopy.shoola.agents.fsimporter.IconManager;
import org.openmicroscopy.shoola.agents.fsimporter.util.ChecksumTableModel;
import org.openmicroscopy.shoola.agents.fsimporter.util.ChecksumTableRenderer;
import org.openmicroscopy.shoola.env.data.util.Status;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class CheckSumDialog
extends JDialog {
    private static final String TITLE = "Checksums";
    private static final String TEXT = "Client and Server checksums.";
    private JButton closeButton;
    private JTable table;

    private void initialize(Status label) {
        IconManager icons = IconManager.getInstance();
        ChecksumTableRenderer rnd = new ChecksumTableRenderer(icons.getIcon(10), icons.getIcon(16));
        ChecksumTableModel model = new ChecksumTableModel(label.getChecksumFiles(), label.getChecksums(), label.getFailingChecksums());
        this.table = new JTable(model);
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            tcm.getColumn(i).setCellRenderer(rnd);
        }
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckSumDialog.this.setVisible(false);
                CheckSumDialog.this.dispose();
            }
        });
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.add(this.closeButton);
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private void buildGUI() {
        JScrollPane scrollPane = new JScrollPane(this.table);
        StringBuffer buf = new StringBuffer();
        buf.append("Only the last ");
        buf.append(10);
        buf.append(" characters of the checksums are displayed.");
        TitlePanel tp = new TitlePanel(TEXT, buf.toString(), null);
        Container c = this.getContentPane();
        c.setLayout(new BoxLayout(c, 1));
        c.add((Component)((Object)tp), "North");
        c.add((Component)scrollPane, "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    public CheckSumDialog(JFrame owner, Status label) {
        super(owner);
        this.setTitle(TITLE);
        this.setModal(true);
        this.initialize(label);
        this.buildGUI();
        this.pack();
    }
}

