/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import org.openmicroscopy.shoola.agents.fsimporter.IconManager;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ErrorDialog
extends JDialog {
    private static final String TITLE = "Import Error";
    private static final String TEXT = "Follow the exception returned while attempting to import the image.";
    private Throwable error;
    private JButton closeButton;

    private void initComponents() {
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.close();
            }
        });
        this.getRootPane().setDefaultButton(this.closeButton);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private JTextPane buildExceptionArea() {
        JTextPane pane = UIUtilities.buildExceptionArea();
        StyledDocument document = pane.getStyledDocument();
        Style style = pane.getLogicalStyle();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.error.printStackTrace(pw);
        try {
            document.insertString(document.getLength(), sw.toString(), style);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return pane;
    }

    private void buildUI() {
        Container c = this.getContentPane();
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TITLE, TEXT, icons.getIcon(20));
        c.add((Component)((Object)tp), "North");
        JScrollPane pane = new JScrollPane(this.buildExceptionArea());
        c.add((Component)pane, "Center");
        c.add((Component)UIUtilities.buildComponentPanelRight(this.buildToolBar()), "South");
    }

    private JPanel buildToolBar() {
        JPanel toolBar = new JPanel();
        toolBar.add(this.closeButton);
        return toolBar;
    }

    public ErrorDialog(JFrame parent, Throwable error) {
        super(parent);
        this.setTitle(TITLE);
        this.setModal(true);
        this.error = error;
        this.initComponents();
        this.buildUI();
        this.setSize(500, 600);
    }
}

