/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import omero.gateway.model.DataObject;
import omero.gateway.model.FilesetData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.events.importer.BrowseContainer;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.util.CheckSumDialog;
import org.openmicroscopy.shoola.agents.fsimporter.util.FileImportComponent;
import org.openmicroscopy.shoola.agents.fsimporter.util.FileImportComponentI;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterControl;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterModel;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUI;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUIElement;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.data.model.DownloadAndLaunchActivityParam;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;
import org.openmicroscopy.shoola.env.data.util.Status;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ImporterUIElementDetailed
extends ImporterUIElement {
    private static final double[] COLUMNS = new double[]{-1.0};
    private JPanel entries;

    private void browse(Object data, Object node) {
        FileImportComponentI fc;
        EventBus bus = ImporterAgent.getRegistry().getEventBus();
        if (data instanceof TreeImageDisplay || data instanceof DataObject) {
            bus.post(new BrowseContainer(data, node));
        } else if (data instanceof FileImportComponent && (fc = (FileImportComponentI)data).getContainerFromFolder() != null) {
            bus.post(new BrowseContainer(fc.getContainerFromFolder(), node));
        }
    }

    @Override
    void showFailures() {
        String v = this.filterButton.getText();
        if ("Show Failed".equals(v)) {
            this.filterButton.setText("Show All");
            this.layoutEntries(true);
        } else {
            this.filterButton.setText("Show Failed");
            this.layoutEntries(false);
        }
    }

    @Override
    FileImportComponentI buildComponent(ImportableFile importable, boolean browsable, boolean singleGroup, int index, Collection<TagAnnotationData> tags) {
        return new FileImportComponent(importable, !this.controller.isMaster(), singleGroup, this.getID(), this.object.getTags());
    }

    @Override
    void downloadLogFile(long logFileID) {
        if (logFileID < 0L) {
            return;
        }
        Environment env = (Environment)ImporterAgent.getRegistry().lookup("/env");
        String path = env.getOmeroFilesHome();
        File f = new File(path, "importLog_" + logFileID);
        DownloadAndLaunchActivityParam activity = new DownloadAndLaunchActivityParam(logFileID, 0, f, null);
        activity.setUIRegister(false);
        UserNotifier un = ImporterAgent.getRegistry().getUserNotifier();
        un.notifyActivity(this.model.getSecurityContext(), activity);
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.buildHeader(), "North");
        this.entries = new JPanel();
        this.entries.setBackground(UIUtilities.BACKGROUND);
        this.layoutEntries(false);
        JScrollPane pane = new JScrollPane(this.entries);
        pane.setOpaque(false);
        pane.setBorder(new LineBorder(Color.LIGHT_GRAY));
        this.add((Component)pane, "Center");
    }

    private void layoutEntries(boolean failure) {
        this.entries.removeAll();
        TableLayout layout = new TableLayout();
        layout.setColumn(COLUMNS);
        this.entries.setLayout(layout);
        int index = 0;
        Iterator i = this.components.entrySet().iterator();
        if (failure) {
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                FileImportComponent fc = (FileImportComponent)entry.getValue();
                if (fc.hasComponents()) {
                    this.addRow(layout, index, fc);
                    fc.layoutEntries(failure);
                    ++index;
                    continue;
                }
                if (!fc.hasImportFailed()) continue;
                this.addRow(layout, index, fc);
                ++index;
            }
        } else {
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                FileImportComponent fc = (FileImportComponent)entry.getValue();
                this.addRow(layout, index, fc);
                fc.layoutEntries(failure);
                ++index;
            }
        }
        this.entries.revalidate();
        this.repaint();
        this.setNumberOfImport();
    }

    private void addRow(TableLayout layout, int index, FileImportComponent c) {
        layout.insertRow(index, -2.0);
        if (index % 2 == 0) {
            c.setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
        } else {
            c.setBackground(UIUtilities.BACKGROUND_COLOUR_ODD);
        }
        this.entries.add((Component)c, new TableLayoutConstraints(0, index));
    }

    ImporterUIElementDetailed(ImporterControl controller, ImporterModel model, ImporterUI view, int id, int index, String name, ImportableObject object) {
        super(controller, model, view, id, index, name, object);
        this.buildGUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("browse".equals(name)) {
            List<Object> refNodes = this.object.getRefNodes();
            Object node = null;
            if (refNodes != null && refNodes.size() > 0) {
                node = refNodes.get(0);
            }
            this.browse(evt.getNewValue(), node);
        } else if ("importFilesNumber".equals(name)) {
            Integer v = (Integer)evt.getNewValue() - 1;
            this.totalToImport += v.intValue();
            this.setNumberOfImport();
        } else if ("loadLogfile".equals(name)) {
            FileImportComponentI fc = (FileImportComponentI)evt.getNewValue();
            if (fc == null) {
                return;
            }
            long logFileID = fc.getStatus().getLogFileID();
            if (logFileID <= 0L) {
                FilesetData data = fc.getStatus().getFileset();
                if (data == null) {
                    return;
                }
                this.model.fireImportLogFileLoading(data.getId(), fc.getIndex());
            } else {
                this.downloadLogFile(logFileID);
            }
        } else if ("retrieveLogfile".equals(name)) {
            FilesetData data = (FilesetData)evt.getNewValue();
            if (data != null) {
                this.model.fireImportLogFileLoading(data.getId(), this.id);
            }
        } else if ("checksumDisplay".equals(name)) {
            Status label = (Status)evt.getNewValue();
            CheckSumDialog d = new CheckSumDialog(this.view, label);
            UIUtilities.centerAndShow(d);
        } else if ("retry".equals(name)) {
            this.controller.retryUpload((FileImportComponent)evt.getNewValue());
        } else if ("cancelImport".equals(name)) {
            this.controller.cancel((FileImportComponentI)evt.getNewValue());
        }
    }
}

